/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.db;

import cn.enilu.flash.core.db.EntityClassWrapper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

class SQLExecutor<T> {
    private final JdbcTemplate jdbcTemplate;
    private final EntityClassWrapper entityClassWrapper;
    private final String tableName;

    public SQLExecutor(JdbcTemplate jdbcTemplate, Class<T> klass) {
        this(jdbcTemplate, klass, null);
    }

    public SQLExecutor(JdbcTemplate jdbcTemplate, Class<T> klass, String tableName) {
        this.jdbcTemplate = jdbcTemplate;
        this.entityClassWrapper = EntityClassWrapper.wrap(klass);
        this.tableName = tableName;
    }

    private String buildColumns(Object entity, boolean includeId) {
        ArrayList list = Lists.newArrayList();
        for (EntityClassWrapper.ColumnField field : this.entityClassWrapper.getColumnFields()) {
            if (field.isId() && !includeId || this.isNull(entity, field)) continue;
            list.add(field.getColumnName());
        }
        return Joiner.on((String)",").join((Iterable)list);
    }

    private String buildColumnPlaceholders(Object entity, boolean includeId) {
        ArrayList list = Lists.newArrayList();
        for (EntityClassWrapper.ColumnField field : this.entityClassWrapper.getColumnFields()) {
            if (field.isId() && !includeId || this.isNull(entity, field)) continue;
            list.add("?");
        }
        return Joiner.on((String)",").join((Iterable)list);
    }

    private List<Object> buildParameters(Object entity, boolean includeId) {
        ArrayList list = Lists.newArrayList();
        for (EntityClassWrapper.ColumnField field : this.entityClassWrapper.getColumnFields()) {
            if (field.isId() && !includeId || this.isNull(entity, field)) continue;
            Object value = field.getJdbcValue(entity);
            list.add(value);
        }
        return list;
    }

    private boolean isNull(Object entity, EntityClassWrapper.ColumnField f) {
        return f.get(entity) == null;
    }

    private void setupTimestampFields(T entity) {
        for (EntityClassWrapper.ColumnField field : this.entityClassWrapper.getColumnFields()) {
            if (!field.isTimestamp() || !this.isNull(entity, field)) continue;
            if (field.getType() == DateTime.class) {
                field.set(entity, DateTime.now());
                continue;
            }
            if (field.getType() != Date.class) continue;
            field.set(entity, new Date());
        }
    }

    public int batchInsert(List<T> entities, boolean replace) {
        if (entities.isEmpty()) {
            return 0;
        }
        T firstEntity = entities.get(0);
        this.setupTimestampFields(firstEntity);
        boolean includeId = this.entityClassWrapper.isIdPresent(firstEntity);
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (replace) {
            sql.append("replace into ");
        } else {
            sql.append("insert into ");
        }
        sql.append(this.getTableName()).append("(");
        sql.append(this.buildColumns(firstEntity, includeId)).append(")");
        sql.append(" values");
        int size = entities.size();
        for (int i = 0; i < size; ++i) {
            T entity = entities.get(i);
            this.setupTimestampFields(entity);
            parameters.addAll(this.buildParameters(entity, includeId));
            sql.append("(");
            sql.append(this.buildColumnPlaceholders(entity, includeId));
            sql.append(")");
            if (i >= size - 1) continue;
            sql.append(",");
        }
        return this.jdbcTemplate.update(sql.toString(), parameters.toArray());
    }

    public int insert(T entity, boolean replace) {
        this.setupTimestampFields(entity);
        boolean includeId = this.entityClassWrapper.isIdPresent(entity);
        final StringBuilder sql = new StringBuilder();
        final List<Object> parameters = this.buildParameters(entity, includeId);
        if (replace) {
            sql.append("replace into ");
        } else {
            sql.append("insert into ");
        }
        sql.append(this.getTableName()).append("(");
        sql.append(this.buildColumns(entity, includeId)).append(")");
        sql.append(" values(");
        sql.append(this.buildColumnPlaceholders(entity, includeId));
        sql.append(")");
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        int result = this.jdbcTemplate.update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(sql.toString(), 1);
                int idx = 1;
                for (Object param : parameters) {
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)idx++, (int)Integer.MIN_VALUE, param);
                }
                return ps;
            }
        }, (KeyHolder)generatedKeyHolder);
        if (replace) {
            return result / 2;
        }
        Number key = generatedKeyHolder.getKey();
        if (key != null) {
            EntityClassWrapper.ColumnField idField = this.entityClassWrapper.getIdColumnField();
            if (idField == null) {
                throw new IllegalArgumentException("id column is required!");
            }
            Class<?> keyClass = idField.getField().getType();
            if (keyClass == Long.class || keyClass == Long.TYPE) {
                idField.set(entity, key.longValue());
            } else {
                idField.set(entity, key.intValue());
            }
        }
        return result;
    }

    private String buildSetsForUpdate(Object entity, boolean includeId) {
        ArrayList list = Lists.newArrayList();
        for (EntityClassWrapper.ColumnField field : this.entityClassWrapper.getColumnFields()) {
            if (field.isId() && !includeId) continue;
            if (this.isNull(entity, field)) {
                list.add(field.getColumnName() + " = NULL");
                continue;
            }
            list.add(field.getColumnName() + " = ?");
        }
        return Joiner.on((String)",").join((Iterable)list);
    }

    private String buildIdCondition() {
        EntityClassWrapper.ColumnField idField = this.entityClassWrapper.getIdColumnField();
        if (idField == null) {
            throw new IllegalStateException("id column is required");
        }
        return idField.getColumnName() + "=?";
    }

    private void touchUpdatedAtField(T entity) {
        for (EntityClassWrapper.ColumnField field : this.entityClassWrapper.getColumnFields()) {
            if (!field.isUpdatedAt()) continue;
            if (field.getType() == DateTime.class) {
                field.set(entity, DateTime.now());
                break;
            }
            if (field.getType() != Date.class) break;
            field.set(entity, new Date());
            break;
        }
    }

    public int update(T entity) {
        this.touchUpdatedAtField(entity);
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(this.getTableName()).append(" set ");
        sql.append(this.buildSetsForUpdate(entity, false));
        sql.append(" where ").append(this.buildIdCondition());
        List<Object> parameters = this.buildParameters(entity, false);
        Object id = this.entityClassWrapper.getIdColumnField().get(entity);
        parameters.add(id);
        return this.jdbcTemplate.update(sql.toString(), parameters.toArray());
    }

    private String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        return this.entityClassWrapper.getTableName();
    }

    public int update(T entity, String ... properties) {
        if (properties == null || properties.length == 0) {
            throw new IllegalArgumentException("properties can't be empty");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(this.getTableName()).append(" set ");
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (String field : properties) {
            EntityClassWrapper.ColumnField columnField = this.entityClassWrapper.getColumnField(field);
            sql.append(columnField.getColumnName()).append(" = ?,");
            parameters.add(columnField.getJdbcValue(entity));
        }
        sql.setLength(sql.length() - 1);
        sql.append(" where ").append(this.buildIdCondition());
        Object id = this.entityClassWrapper.getIdColumnField().get(entity);
        parameters.add(id);
        return this.jdbcTemplate.update(sql.toString(), parameters.toArray());
    }

    public int delete(T entity) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(this.getTableName());
        sql.append(" where ").append(this.buildIdCondition());
        Object id = this.entityClassWrapper.getIdColumnField().get(entity);
        return this.jdbcTemplate.update(sql.toString(), new Object[]{id});
    }
}

