/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.db;

import cn.enilu.flash.core.db.DB;
import cn.enilu.flash.core.db.EntityClassWrapper;
import cn.enilu.flash.core.db.ISQLBuilder;
import cn.enilu.flash.core.db.Pagination;
import cn.enilu.flash.core.db.RecordHandler;
import cn.enilu.flash.core.db.RecordNotFoundException;
import cn.enilu.flash.core.db.Util;
import cn.enilu.flash.core.lang.Lists;
import com.google.common.collect.AbstractIterator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class Query
implements Cloneable {
    private final DB db;
    private final JdbcTemplate jdbcTemplate;
    private final ISQLBuilder sqlBuilder;
    private String table;
    private boolean eager = false;

    Query(DB db, JdbcTemplate jdbcTemplate, ISQLBuilder sqlBuilder) {
        this.db = db;
        this.jdbcTemplate = jdbcTemplate;
        this.sqlBuilder = sqlBuilder;
    }

    public Query eager(boolean eagerLoad) {
        this.eager = eagerLoad;
        return this;
    }

    public Query clone() {
        return new Query(this.db, this.jdbcTemplate, this.sqlBuilder.clone());
    }

    public Query from(String table) {
        this.table = table;
        this.sqlBuilder.setTable(table);
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public Query groupBy(String groupBy) {
        this.sqlBuilder.groupBy(groupBy);
        return this;
    }

    public Query having(String having) {
        this.sqlBuilder.having(having);
        return this;
    }

    public Query limit(Integer rowCount) {
        return this.limit(0, rowCount);
    }

    public Query limit(Integer offset, Integer rowCount) {
        this.sqlBuilder.limit(offset, rowCount);
        return this;
    }

    public Query orderBy(String orderBy) {
        if (orderBy == null) {
            return this;
        }
        if (orderBy.endsWith("!")) {
            orderBy = orderBy.substring(0, orderBy.length() - 1) + " desc";
        }
        this.sqlBuilder.orderBy(orderBy);
        return this;
    }

    public Query select(String ... columns) {
        this.sqlBuilder.select(columns);
        return this;
    }

    public Query join(String join) {
        this.sqlBuilder.join(join);
        return this;
    }

    public Query tag(String tag) {
        this.sqlBuilder.tag(tag);
        return this;
    }

    private Query where(Condition c) {
        this.sqlBuilder.where(c.toSQL(this.sqlBuilder), c.params);
        return this;
    }

    public Query segment(String sql, Object ... params) {
        return this.where(new Condition(ConditionType.SEGMENT, sql, params));
    }

    public Query eq(String name, Object value) {
        return this.where(new Condition(ConditionType.EQ, name, value));
    }

    public Query where(String name, Object value) {
        return this.eq(name, value);
    }

    public Query where(String name, Object value, boolean ignoreNullValue) {
        if (ignoreNullValue && value == null) {
            return this;
        }
        return this.where(name, value);
    }

    public Query where(String name, Object value, Object ... nameValues) {
        return this.eq(name, value, nameValues);
    }

    public Query eq(String name, Object value, Object ... nameValues) {
        if (nameValues.length % 2 != 0) {
            throw new IllegalArgumentException("nameValues.length % 2 must be 0");
        }
        this.where(new Condition(ConditionType.EQ, name, value));
        for (int i = 0; i < nameValues.length; i += 2) {
            this.where(new Condition(ConditionType.EQ, (String)nameValues[i], nameValues[i + 1]));
        }
        return this;
    }

    public Query where(Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            this.where(new Condition(ConditionType.EQ, entry.getKey(), entry.getValue()));
        }
        return this;
    }

    public Query not(String name, Object value) {
        return this.where(new Condition(ConditionType.NOT_EQ, name, value));
    }

    public Query in(String name, List<?> values) {
        return this.in(name, values.toArray());
    }

    public Query in(String name, Object ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values can't be empty");
        }
        return this.where(new Condition(ConditionType.IN, name, values));
    }

    public Query notIn(String name, Object ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values can't be empty");
        }
        return this.where(new Condition(ConditionType.NOT_IN, name, values));
    }

    public Query like(String name, Object value) {
        return this.where(new Condition(ConditionType.LIKE, name, value));
    }

    public Query notLike(String name, Object value) {
        return this.where(new Condition(ConditionType.NOT_LIKE, name, value));
    }

    public Query between(String name, Object from, Object to) {
        return this.where(new Condition(ConditionType.BETWEEN, name, new Object[]{from, to}));
    }

    public Query notBetween(String name, Object from, Object to) {
        return this.where(new Condition(ConditionType.NOT_BETWEEN, name, new Object[]{from, to}));
    }

    public Query less(String name, Object value, boolean ignoreNullValue) {
        if (ignoreNullValue && value == null) {
            return this;
        }
        return this.less(name, value);
    }

    public Query less(String name, Object value) {
        return this.where(new Condition(ConditionType.LESS, name, value));
    }

    public Query lessOrEquals(String name, Object value, boolean ignoreNullValue) {
        if (ignoreNullValue && value == null) {
            return this;
        }
        return this.lessOrEquals(name, value);
    }

    public Query lessOrEquals(String name, Object value) {
        return this.where(new Condition(ConditionType.LE, name, value));
    }

    public Query great(String name, Object value, boolean ignoreNullValue) {
        if (ignoreNullValue && value == null) {
            return this;
        }
        return this.great(name, value);
    }

    public Query great(String name, Object value) {
        return this.where(new Condition(ConditionType.GREAT, name, value));
    }

    public Query greatOrEquals(String name, Object value, boolean ignoreNullValue) {
        if (ignoreNullValue && value == null) {
            return this;
        }
        return this.greatOrEquals(name, value);
    }

    public Query greatOrEquals(String name, Object value) {
        return this.where(new Condition(ConditionType.GE, name, value));
    }

    public Query isNull(String name) {
        return this.where(new Condition(ConditionType.NULL, name, null));
    }

    public Query isNotNull(String name) {
        return this.where(new Condition(ConditionType.NOT_NULL, name, null));
    }

    public Pagination<Map<String, Object>> paginate(int page, int pageSize) {
        this.limit((page - 1) * pageSize, pageSize);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(this.sqlBuilder.toCountSQL(), Integer.class, this.sqlBuilder.getParameters());
        List<Object> data = Lists.newArrayList();
        if (count > (page - 1) * pageSize) {
            data = this.jdbcTemplate.queryForList(this.sqlBuilder.toSQL(), this.sqlBuilder.getParameters());
        }
        Pagination<Map<String, Object>> pagination = new Pagination<Map<String, Object>>(page, pageSize, count);
        pagination.setData(data);
        return pagination;
    }

    public <T> Pagination<T> paginate(Class<T> klass, int page) {
        return this.paginate(klass, page, 10);
    }

    public <T> Pagination<T> paginate(Class<T> klass, int page, int pageSize) {
        return this.paginate(klass, null, page, pageSize);
    }

    public <T> Pagination<T> paginate(Class<T> klass, RowMapper<T> rowMapper, int page, int pageSize) {
        this.limit((page - 1) * pageSize, pageSize);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(this.sqlBuilder.toCountSQL(), Integer.class, this.sqlBuilder.getParameters());
        List data = Lists.newArrayList();
        if (count > (page - 1) * pageSize) {
            data = this.doQuery(klass, rowMapper);
        }
        Pagination pagination = new Pagination(page, pageSize, count);
        pagination.setData(data);
        return pagination;
    }

    public <T> Pagination<T> nextOnlyPaginate(Class<T> klass, int page, int pageSize) {
        return this.nextOnlyPaginate(klass, null, page, pageSize);
    }

    public <T> Pagination<T> nextOnlyPaginate(Class<T> klass, RowMapper<T> rowMapper, int page, int pageSize) {
        this.limit((page - 1) * pageSize, pageSize + 1);
        List<T> data = this.doQuery(klass, rowMapper);
        Pagination<T> pagination = null;
        if (data.size() > pageSize) {
            pagination = new Pagination<T>(page, true);
            data.remove(pageSize);
        } else {
            pagination = new Pagination(page, false);
        }
        pagination.setData(data);
        return pagination;
    }

    public <T> int each(Class<T> klass, final RecordHandler<T> handler) {
        final RowMapper<T> mapper = this.db.buildRowMapper(klass);
        class EachHandler
        implements RowCallbackHandler {
            private int rowNumber = 0;

            EachHandler() {
            }

            public int getRowNumber() {
                return this.rowNumber;
            }

            public void processRow(ResultSet rs) throws SQLException {
                Object record = mapper.mapRow(rs, this.rowNumber++);
                handler.process(record);
            }
        }
        EachHandler eachHandler = new EachHandler();
        this.jdbcTemplate.query(this.sqlBuilder.toSQL(), this.sqlBuilder.getParameters(), (RowCallbackHandler)eachHandler);
        return eachHandler.getRowNumber();
    }

    public <T> int forEach(Class<T> klass, RecordHandler<T> handler) {
        return this.forEach(klass, handler, 1000);
    }

    public <T> int forEach(Class<T> klass, RecordHandler<T> handler, int batchSize) {
        int rows = 0;
        Iterator<T> ite = this.iterator(klass, batchSize);
        while (ite.hasNext()) {
            T record = ite.next();
            handler.process(record);
            ++rows;
        }
        return rows;
    }

    public <T> Iterator<T> iterator(Class<T> klass) {
        return this.iterator(klass, 1000, null);
    }

    public <T> Iterator<T> iterator(Class<T> klass, int batchSize) {
        return this.iterator(klass, batchSize, null);
    }

    public <T> Iterator<T> iterator(final Class<T> klass, final int batchSize, String idAlias) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must > 0");
        }
        EntityClassWrapper wrapper = EntityClassWrapper.wrap(klass);
        final EntityClassWrapper.ColumnField idField = wrapper.getIdColumnField();
        if (idField == null) {
            throw new IllegalArgumentException("id field is required");
        }
        final String idColumnName = idAlias == null ? idField.getColumnName() : idAlias;
        final Query clone = this.clone();
        clone.orderBy(idColumnName + " asc").limit(0, batchSize);
        return new AbstractIterator<T>(){
            private List<T> batchData = new ArrayList();
            private Iterator<T> batchIterator;
            private boolean allBatchEnd;
            private Query query = clone;
            private Object maxId;

            protected T computeNext() {
                if (this.batchIterator == null || !this.batchIterator.hasNext()) {
                    if (this.allBatchEnd && !this.batchIterator.hasNext()) {
                        return this.endOfData();
                    }
                    if (this.maxId != null) {
                        this.query = clone.clone();
                        this.query.great(idColumnName, this.maxId);
                    }
                    this.batchData.clear();
                    int rows = this.query.each(klass, new RecordHandler<T>(){

                        @Override
                        public void process(T record) {
                            batchData.add(record);
                            maxId = idField.get(record);
                        }
                    });
                    if (rows < batchSize) {
                        this.allBatchEnd = true;
                    }
                    this.batchIterator = this.batchData.iterator();
                }
                if (!this.batchIterator.hasNext()) {
                    return this.endOfData();
                }
                return this.batchIterator.next();
            }
        };
    }

    public boolean isExists() {
        this.limit(1);
        return this.all().size() > 0;
    }

    public <T> T first(Class<T> klass) {
        return this.first(klass, false);
    }

    public <T> T first(Class<T> klass, boolean throwIfNotFound) {
        return this.first(klass, null, throwIfNotFound);
    }

    public <T> T first(Class<T> klass, RowMapper<T> rowMapper, boolean throwIfNotFound) {
        List<T> data;
        if (!this.sqlBuilder.hasLimit()) {
            this.sqlBuilder.limit(0, 1);
        }
        if ((data = this.doQuery(klass, rowMapper)).size() == 0) {
            if (throwIfNotFound) {
                throw new RecordNotFoundException("no record found for " + klass.getSimpleName());
            }
            return null;
        }
        return data.get(0);
    }

    public <T> List<T> all(Class<T> klass) {
        return this.doQuery(klass, null);
    }

    public <T> List<T> all(Class<T> klass, RowMapper<T> rowMapper) {
        return this.doQuery(klass, rowMapper);
    }

    public List<Map<String, Object>> all() {
        return this.jdbcTemplate.queryForList(this.sqlBuilder.toSQL(), this.sqlBuilder.getParameters());
    }

    public int count() {
        this.sqlBuilder.clearSelect();
        this.select("count(*)");
        return this.first(Integer.class);
    }

    public Query lock() {
        this.sqlBuilder.lock();
        return this;
    }

    private <T> List<T> doQuery(Class<T> klass, RowMapper<T> rowMapper) {
        List data = null;
        if (Util.isPrimitive(klass)) {
            data = this.jdbcTemplate.queryForList(this.sqlBuilder.toSQL(), this.sqlBuilder.getParameters(), klass);
        } else {
            if (rowMapper == null) {
                rowMapper = this.db.buildRowMapper(klass);
            }
            data = this.jdbcTemplate.query(this.sqlBuilder.toSQL(), this.sqlBuilder.getParameters(), rowMapper);
        }
        if (this.eager) {
            this.db.load(data);
        }
        return data;
    }

    public String toSQL() {
        return this.sqlBuilder.toSQL();
    }

    private static class Condition {
        final ConditionType type;
        final String column;
        final Object[] params;

        public Condition(ConditionType type, String column, Object value) {
            this.type = type;
            this.column = column;
            this.params = this.toParams(value);
        }

        private Object[] toParams(Object value) {
            if (value == null) {
                return new Object[0];
            }
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                Object[] params = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    params[i] = this.rewrite(values[i]);
                }
                return params;
            }
            return new Object[]{this.rewrite(value)};
        }

        private Object rewrite(Object value) {
            if (value instanceof Enum) {
                value = value.toString();
            } else if (value instanceof DateTime) {
                value = ((DateTime)value).toDate();
            }
            return value;
        }

        public String toSQL(ISQLBuilder g) {
            if (this.type.op != null) {
                return g.escapeColumn(this.column) + " " + this.type.op + " ?";
            }
            switch (this.type) {
                case SEGMENT: {
                    return "(" + this.column + ")";
                }
                case IN: 
                case NOT_IN: {
                    StringBuilder c = new StringBuilder();
                    c.append(g.escapeColumn(this.column));
                    if (this.type == ConditionType.NOT_IN) {
                        c.append(" not");
                    }
                    c.append(" in (");
                    for (int i = 0; i < this.params.length; ++i) {
                        if (i > 0) {
                            c.append(", ");
                        }
                        c.append("?");
                    }
                    c.append(")");
                    return c.toString();
                }
                case BETWEEN: 
                case NOT_BETWEEN: {
                    StringBuilder between = new StringBuilder();
                    between.append(g.escapeColumn(this.column));
                    if (this.type == ConditionType.NOT_BETWEEN) {
                        between.append(" not");
                    }
                    between.append(" between ? and ?");
                    return between.toString();
                }
                case NULL: {
                    return g.escapeColumn(this.column) + " is null";
                }
                case NOT_NULL: {
                    return g.escapeColumn(this.column) + " is not null";
                }
            }
            throw new IllegalStateException();
        }
    }

    private static enum ConditionType {
        SEGMENT(null),
        EQ("="),
        NOT_EQ("!="),
        IN(null),
        NOT_IN(null),
        LIKE("like"),
        NOT_LIKE("not like"),
        BETWEEN(null),
        NOT_BETWEEN(null),
        LESS("<"),
        LE("<="),
        GREAT(">"),
        GE(">="),
        NULL(null),
        NOT_NULL(null);

        public final String op;

        private ConditionType(String op) {
            this.op = op;
        }
    }
}

