/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.db;

import cn.enilu.flash.core.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Pagination<T> {
    public static final int DEFAULT_PER_PAGE = 10;
    @JsonProperty
    private int page;
    @JsonProperty
    private int perPage;
    @JsonProperty
    private int total;
    @JsonProperty
    private boolean hasNext;
    @JsonProperty
    private Mode mode;
    @JsonProperty
    private List<T> data = new ArrayList<T>();

    public Pagination(int page, int perPage, int total) {
        this.page = page < 1 ? 1 : page;
        this.perPage = perPage;
        this.total = total;
        this.mode = Mode.FULL;
        this.hasNext = false;
    }

    public Pagination(int page, boolean hasNext) {
        this.page = page;
        this.hasNext = hasNext;
        this.mode = Mode.NEXT_ONLY;
        this.perPage = -1;
        this.total = -1;
    }

    public Pagination() {
    }

    public void setData(List<T> data) {
        this.data.clear();
        this.data.addAll(data);
    }

    public List<T> getData() {
        return this.data;
    }

    public int getTotalPages() {
        return (this.total + this.perPage - 1) / this.perPage;
    }

    public int offset() {
        return (this.page - 1) * this.perPage + 1;
    }

    public int nextPage() {
        if (this.page < this.getTotalPages()) {
            return this.page + 1;
        }
        return -1;
    }

    public int previousPage() {
        return this.page <= 1 ? -1 : this.page - 1;
    }

    public <V> Pagination<V> replace(List<V> data) {
        Pagination<V> result = new Pagination<V>(this.page, this.perPage, this.total);
        if (this.mode == Mode.NEXT_ONLY) {
            result = new Pagination<T>(this.page, this.hasNext);
        }
        result.setData(data);
        return result;
    }

    public List<Integer> pageNavigation() {
        boolean rightGap;
        ArrayList<Integer> pages = new ArrayList<Integer>();
        int min = 1;
        int max = this.getTotalPages();
        int innerWindow = 2;
        int from = Math.max(min, this.page - innerWindow);
        int to = Math.min(max, this.page + innerWindow);
        boolean leftGap = min + 2 < from;
        boolean bl = rightGap = to + 2 < max;
        if (!leftGap) {
            from = min;
        }
        if (!rightGap) {
            to = max;
        }
        if (min != from) {
            pages.add(min);
        }
        if (leftGap) {
            pages.add(-1);
        }
        for (int i = from; i <= to; ++i) {
            pages.add(i);
        }
        if (rightGap) {
            pages.add(-1);
        }
        if (max != to) {
            pages.add(max);
        }
        return pages;
    }

    public int getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getTotal() {
        return this.total;
    }

    public boolean isHasNext() {
        return this.hasNext;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String toString() {
        return "Pagination [page=" + this.page + ", perPage=" + this.perPage + ", total=" + this.total + ", data=" + this.data + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination that = (Pagination)o;
        if (this.hasNext != that.hasNext) {
            return false;
        }
        if (this.page != that.page) {
            return false;
        }
        if (this.perPage != that.perPage) {
            return false;
        }
        if (this.total != that.total) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        return this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.page;
        result = 31 * result + this.perPage;
        result = 31 * result + this.total;
        result = 31 * result + (this.hasNext ? 1 : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public String toJson() {
        return JsonUtil.dump(this);
    }

    public static <T> Pagination<T> fromJson(String json, Class<T> klass) {
        try {
            ObjectMapper mapper = JsonUtil.getMapper();
            JavaType javaType = mapper.getTypeFactory().constructParametricType(Pagination.class, new Class[]{klass});
            return (Pagination)mapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new JsonUtil.CodecException(e);
        }
    }

    public static enum Mode {
        FULL,
        NEXT_ONLY;

    }
}

