/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.db;

import cn.enilu.flash.core.db.ISQLBuilder;
import cn.enilu.flash.core.lang.Strings;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenericSQLBuilder
implements ISQLBuilder {
    protected String table;
    protected String tag;
    protected List<String> columns = new ArrayList<String>();
    protected List<String> joins = new ArrayList<String>();
    protected List<String> conditions = new ArrayList<String>();
    protected List<String> groupBys = new ArrayList<String>();
    protected List<String> havings = new ArrayList<String>();
    protected List<String> orderBys = new ArrayList<String>();
    protected boolean lockForUpdate;
    protected Integer offset;
    protected Integer rowCount;
    protected List<Object> parameters = new ArrayList<Object>();

    @Override
    public ISQLBuilder clone() {
        try {
            GenericSQLBuilder clone = (GenericSQLBuilder)super.clone();
            clone.columns = new ArrayList<String>(this.columns);
            clone.joins = new ArrayList<String>(this.joins);
            clone.conditions = new ArrayList<String>(this.conditions);
            clone.groupBys = new ArrayList<String>(this.groupBys);
            clone.havings = new ArrayList<String>(this.havings);
            clone.orderBys = new ArrayList<String>(this.orderBys);
            clone.parameters = new ArrayList<Object>(this.parameters);
            clone.lockForUpdate = this.lockForUpdate;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters.toArray();
    }

    @Override
    public String toCountSQL() {
        if (this.groupBys.isEmpty()) {
            StringBuilder sql = new StringBuilder("select ");
            this.fillTag(sql);
            sql.append(" count(*) from ");
            sql.append(this.table).append(this.toJoinSQL());
            if (!this.conditions.isEmpty()) {
                sql.append(" where ");
                for (int i = 0; i < this.conditions.size(); ++i) {
                    if (i > 0) {
                        sql.append(" and ");
                    }
                    sql.append(this.conditions.get(i));
                }
            }
            return sql.toString();
        }
        return "select count(*) from (" + this.toSQL0(true, false, false) + ") a";
    }

    @Override
    public String toSQL() {
        return this.toSQL0(true, true, true);
    }

    protected String toSQL0(boolean withGroup, boolean withOrderBy, boolean withLimit) {
        StringBuilder sql = new StringBuilder("select ");
        this.fillTag(sql);
        sql.append(this.toSelectColumns()).append(" from ").append(this.table).append(this.toJoinSQL());
        if (!this.conditions.isEmpty()) {
            sql.append(" where ");
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(this.conditions.get(i));
            }
        }
        if (withGroup) {
            sql.append(this.toGroupBySQL()).append(this.toHavingSQL());
        }
        if (withOrderBy) {
            sql.append(this.toOrderBySQL());
        }
        if (withLimit) {
            sql.append(this.toLimitSQL());
        }
        if (this.lockForUpdate) {
            sql.append(" for update");
        }
        return sql.toString();
    }

    private void fillTag(StringBuilder sql) {
        if (!Strings.isBlank(this.tag)) {
            sql.append("/* tag: ").append(this.tag).append(" */ ");
        }
    }

    protected String toSelectColumns() {
        if (this.columns.isEmpty()) {
            return "*";
        }
        return Joiner.on((String)", ").join(this.columns);
    }

    protected String toJoinSQL() {
        if (this.joins.isEmpty()) {
            return "";
        }
        return "\n" + Joiner.on((String)"\n").join(this.joins);
    }

    protected String toGroupBySQL() {
        if (this.groupBys.isEmpty()) {
            return "";
        }
        return " group by " + Joiner.on((String)", ").join(this.groupBys);
    }

    protected String toHavingSQL() {
        if (this.havings.isEmpty()) {
            return "";
        }
        return " having " + Joiner.on((String)" and ").join(this.havings);
    }

    protected String toOrderBySQL() {
        if (this.orderBys.isEmpty()) {
            return "";
        }
        return " order by " + Joiner.on((String)", ").join(this.orderBys);
    }

    protected String toLimitSQL() {
        if (this.offset == null) {
            return "";
        }
        return " limit " + this.offset + ", " + this.rowCount;
    }

    @Override
    public String escapeColumn(String column) {
        return column;
    }

    @Override
    public void tag(String tag) {
        this.tag = tag;
    }

    @Override
    public void where(String condition, Object ... params) {
        this.conditions.add(condition);
        for (Object param : params) {
            this.parameters.add(param);
        }
    }

    @Override
    public void select(String ... columns) {
        this.columns.addAll(Arrays.asList(columns));
    }

    @Override
    public void clearSelect() {
        this.columns.clear();
    }

    @Override
    public void join(String joinSql) {
        this.joins.add(joinSql);
    }

    @Override
    public void groupBy(String groupBy) {
        this.groupBys.add(groupBy);
    }

    @Override
    public void having(String having) {
        this.havings.add(having);
    }

    @Override
    public void orderBy(String orderBy) {
        this.orderBys.add(orderBy);
    }

    @Override
    public void limit(Integer offset, Integer rowCount) {
        this.offset = offset;
        this.rowCount = rowCount;
    }

    @Override
    public boolean hasLimit() {
        return this.offset != null;
    }

    @Override
    public void lock() {
        this.lockForUpdate = true;
    }

    @Override
    public String getLastInsertIdSQL() {
        return null;
    }
}

