/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.db;

import cn.enilu.flash.core.db.annotation.EntityReference;
import cn.enilu.flash.core.db.annotation.EntityReferences;
import cn.enilu.flash.core.lang.Reflects;
import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import org.joda.time.DateTime;
import org.springframework.dao.DataAccessException;

public class EntityClassWrapper {
    private static ConcurrentHashMap<Class<?>, EntityClassWrapper> cache = new ConcurrentHashMap();
    private final Class<?> klass;
    private final List<Field> fields;
    private final Table table;
    private final String tableName;
    private final LinkedHashMap<String, ColumnField> columnFields;
    private final ColumnField idColumnField;
    private final LinkedHashMap<String, ReferenceField> referenceFields;
    private final LinkedHashMap<String, ReferencesField> referencesFields;
    private final List<EntityField> entityFields;

    public EntityClassWrapper(Class<?> klass) {
        if (!Reflects.isAnnotationPresent(klass, Table.class)) {
            throw new IllegalArgumentException("no Table annotation");
        }
        this.klass = klass;
        Reflects.ClassAnnotation<Table> ca = Reflects.getAnnotation(klass, Table.class);
        this.table = ca.getAnnotation();
        String name = this.table.name();
        if (Strings.isNullOrEmpty((String)name)) {
            name = ca.getKlass().getSimpleName();
            this.tableName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        } else {
            this.tableName = name;
        }
        this.fields = Reflects.getFields(klass, true);
        this.columnFields = new LinkedHashMap();
        this.scanColumnFields();
        this.idColumnField = this.scanIdField();
        this.referenceFields = new LinkedHashMap();
        this.scanReferenceFields();
        this.referencesFields = new LinkedHashMap();
        this.scanReferencesFields();
        this.entityFields = Lists.newArrayList();
        this.scanEntityFields();
    }

    private void scanEntityFields() {
        for (Field field : this.fields) {
            Class<?> type = field.getType();
            if (!Reflects.isAnnotationPresent(type, Table.class) && field.getAnnotation(EntityReference.class) == null && field.getAnnotation(EntityReferences.class) == null) continue;
            this.entityFields.add(new EntityField(field));
        }
    }

    private void scanColumnFields() {
        for (Field field : this.fields) {
            Id id = field.getAnnotation(Id.class);
            Column column = field.getAnnotation(Column.class);
            if (id == null && column == null) continue;
            ColumnField columnField = new ColumnField(field);
            this.columnFields.put(columnField.getName(), columnField);
        }
    }

    private ColumnField scanTimestampField(String name) {
        for (Field field : this.fields) {
            Column column = field.getAnnotation(Column.class);
            if (column == null || !name.equals(field.getName())) continue;
            return new ColumnField(field);
        }
        return null;
    }

    private ColumnField scanIdField() {
        for (Field field : this.fields) {
            Id id = field.getAnnotation(Id.class);
            if (id == null) continue;
            return new ColumnField(field);
        }
        return null;
    }

    private void scanReferenceFields() {
        for (Field field : this.fields) {
            EntityReference reference = field.getAnnotation(EntityReference.class);
            if (reference == null) continue;
            ReferenceField referenceField = new ReferenceField(field);
            this.referenceFields.put(referenceField.getName(), referenceField);
        }
    }

    private void scanReferencesFields() {
        for (Field field : this.fields) {
            EntityReferences references = field.getAnnotation(EntityReferences.class);
            if (references == null) continue;
            ReferencesField referencesField = new ReferencesField(field);
            this.referencesFields.put(referencesField.getName(), referencesField);
        }
    }

    public Class<?> getWrappedClass() {
        return this.klass;
    }

    public Collection<ColumnField> getColumnFields() {
        return this.columnFields.values();
    }

    public boolean isIdPresent(Object entity) {
        if (!this.isIdFieldPresent()) {
            return false;
        }
        Object value = this.idColumnField.get(entity);
        return value != null;
    }

    public boolean isIdFieldPresent() {
        return this.idColumnField != null;
    }

    public ColumnField getIdColumnField() {
        return this.idColumnField;
    }

    public ColumnField getColumnField(String fieldName) {
        return this.columnFields.get(fieldName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Collection<ReferenceField> getReferenceFields() {
        return this.referenceFields.values();
    }

    public Collection<ReferencesField> getReferencesFields() {
        return this.referencesFields.values();
    }

    public List<EntityField> getEntityFields() {
        return this.entityFields;
    }

    public static EntityClassWrapper wrap(Object entity) {
        return EntityClassWrapper.wrap(entity.getClass());
    }

    public static EntityClassWrapper wrap(Class<?> klass) {
        EntityClassWrapper wrapper = null;
        wrapper = cache.get(klass);
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = new EntityClassWrapper(klass);
        EntityClassWrapper oldWrapper = cache.putIfAbsent(klass, wrapper);
        if (oldWrapper != null) {
            return oldWrapper;
        }
        return wrapper;
    }

    public static class EntityField
    extends BaseField {
        public EntityField(Field field) {
            super(field);
        }
    }

    public static class ReferencesField
    extends BaseField {
        private final EntityReferences references;

        public ReferencesField(Field field) {
            super(field);
            this.references = field.getAnnotation(EntityReferences.class);
        }

        public EntityReferences getReferences() {
            return this.references;
        }

        public Class<?> getReferenceEntityClasss() {
            return this.references.referenceClass();
        }

        public String getProperty() {
            return this.references.property();
        }

        public String getOrderBy() {
            return this.references.orderBy();
        }
    }

    public static class ReferenceField
    extends BaseField {
        private final EntityReference reference;

        public ReferenceField(Field field) {
            super(field);
            this.reference = field.getAnnotation(EntityReference.class);
        }

        public EntityReference getReference() {
            return this.reference;
        }

        public String getReferenceProperty() {
            String referenceProperty = this.reference.referenceProperty();
            if (Strings.isNullOrEmpty((String)referenceProperty)) {
                referenceProperty = this.field.getName() + "Id";
            }
            return referenceProperty;
        }

        public boolean isInverse() {
            return this.reference.inverse();
        }

        public Class<?> getReferenceEntityClasss() {
            return this.field.getType();
        }
    }

    public static class ColumnField
    extends BaseField {
        private Id id;
        private Column column;
        private String columnName;
        private boolean isUpdatedAt;
        private boolean isCreatedAt;

        public ColumnField(Field field) {
            super(field);
            this.id = field.getAnnotation(Id.class);
            this.column = field.getAnnotation(Column.class);
            this.columnName = this.column != null && !Strings.isNullOrEmpty((String)this.column.name()) ? this.column.name() : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
            this.isUpdatedAt = "updated_at".equalsIgnoreCase(this.columnName);
            this.isCreatedAt = "created_at".equalsIgnoreCase(this.columnName);
        }

        public boolean isId() {
            return this.id != null;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean isUpdatedAt() {
            return this.isUpdatedAt;
        }

        public boolean isCreatedAt() {
            return this.isCreatedAt;
        }

        public boolean isTimestamp() {
            return this.isUpdatedAt || this.isCreatedAt;
        }
    }

    public static abstract class BaseField {
        protected final Field field;

        public BaseField(Field field) {
            field.setAccessible(true);
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        public String getName() {
            return this.field.getName();
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public Object get(Object entity) {
            try {
                return this.field.get(entity);
            }
            catch (Exception e) {
                throw new BadFieldException(e.getMessage(), e);
            }
        }

        public Object getJdbcValue(Object entity) {
            Object value = this.get(entity);
            if (value instanceof Enum) {
                value = value.toString();
            } else if (value instanceof DateTime) {
                value = ((DateTime)value).toDate();
            }
            return value;
        }

        public void set(Object entity, Object value) {
            try {
                this.field.set(entity, value);
            }
            catch (Exception e) {
                throw new BadFieldException(e.getMessage(), e);
            }
        }
    }

    static class BadFieldException
    extends DataAccessException {
        public BadFieldException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

