/*
 * Decompiled with CFR 0.152.
 */
package cn.enilu.flash.core.db;

import cn.enilu.flash.core.db.DBBeanPropertyRowMapper;
import cn.enilu.flash.core.db.EntityClassWrapper;
import cn.enilu.flash.core.db.EntityWrapper;
import cn.enilu.flash.core.db.ISQLBuilder;
import cn.enilu.flash.core.db.Pagination;
import cn.enilu.flash.core.db.Query;
import cn.enilu.flash.core.db.RecordNotFoundException;
import cn.enilu.flash.core.db.SQLExecutor;
import cn.enilu.flash.core.db.Util;
import cn.enilu.flash.core.db.mysql.MySQLSQLBuilder;
import cn.enilu.flash.core.db.sqlite.SQLiteSQLBuilder;
import cn.enilu.flash.core.lang.Lists;
import cn.enilu.flash.core.lang.Maps;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.joda.time.DateTime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public final class DB {
    private final DataSource dataSource;
    private final Type type;
    private final JdbcTemplate jdbcTemplate;
    private final DataSourceTransactionManager transactionManager;

    public DB(DataSource dataSource) {
        this(dataSource, Type.MySQL);
    }

    public DB(DataSource dataSource, Type dbType) {
        this.dataSource = dataSource;
        this.type = dbType;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
    }

    public Query from(String table) {
        return new Query(this, this.jdbcTemplate, this.type.newSQLBuilder()).from(table);
    }

    public Query from(Class<?> klass) {
        EntityClassWrapper wrapper = EntityClassWrapper.wrap(klass);
        return this.from(wrapper.getTableName());
    }

    <T> RowMapper<T> buildRowMapper(Class<T> klass) {
        return DBBeanPropertyRowMapper.newInstance(klass);
    }

    public <T> List<T> all(Class<T> klass) {
        return this.from(klass).all(klass);
    }

    public <T> List<T> all(Class<T> klass, String column, Object value) {
        return this.from(klass).where(column, value).all(klass);
    }

    public <T> List<T> all(Class<T> klass, String column, List<?> values) {
        return this.all(klass, column, values.toArray());
    }

    public <T> List<T> all(Class<T> klass, String column, Object ... values) {
        if (values.length == 0) {
            return new ArrayList();
        }
        return this.from(klass).in(column, values).all(klass);
    }

    public <T, P> T find(Class<T> klass, P id) {
        EntityClassWrapper wrapper = EntityClassWrapper.wrap(klass);
        return this.find(klass, wrapper.getIdColumnField().getColumnName(), id);
    }

    public <T, P> T find(Class<T> klass, String primaryKey, P id) {
        return this.find(klass, null, primaryKey, id);
    }

    public <T, P> T find(Class<T> klass, String table, String primaryKey, P id) {
        T t;
        if (table == null) {
            EntityClassWrapper wrapper = EntityClassWrapper.wrap(klass);
            table = wrapper.getTableName();
        }
        if ((t = this.from(table).where(primaryKey, id).first(klass)) == null) {
            throw new RecordNotFoundException("no record found for " + klass.getSimpleName() + "(" + id + ")");
        }
        return t;
    }

    private Object[] rewriteParams(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            Object value = params[i];
            if (!(value instanceof Enum)) continue;
            params[i] = value.toString();
        }
        return params;
    }

    private <T> SQLExecutor<T> getSQLExecutor(T entity) {
        return new SQLExecutor(this.jdbcTemplate, entity.getClass());
    }

    private <T> SQLExecutor<T> getSQLExecutor(String tableName, T entity) {
        return new SQLExecutor(this.jdbcTemplate, entity.getClass(), tableName);
    }

    public <T> int insert(T entity) {
        return this.getSQLExecutor(entity).insert(entity, false);
    }

    public <T> int insert(String tableName, T entity) {
        return this.getSQLExecutor(tableName, entity).insert(entity, false);
    }

    public <T> int replace(T entity) {
        return this.getSQLExecutor(entity).insert(entity, true);
    }

    public <T> int batchInsert(List<T> entities) {
        if (entities.isEmpty()) {
            throw new IllegalArgumentException("entities can't be empty");
        }
        T entity = entities.get(0);
        return this.getSQLExecutor(entity).batchInsert(entities, false);
    }

    public <T> int batchReplace(List<T> entities) {
        if (entities.isEmpty()) {
            throw new IllegalArgumentException("entities can't be empty");
        }
        T entity = entities.get(0);
        return this.getSQLExecutor(entity).batchInsert(entities, true);
    }

    public int insert(String table, Object ... kv) {
        if (kv.length == 0 || kv.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<String, Object> data = Maps.newHashMap();
        for (int i = 0; i < kv.length; i += 2) {
            String key = (String)kv[i];
            Object value = kv[i + 1];
            data.put(key, value);
        }
        return this.insert(table, (Map<String, Object>)data);
    }

    public int insert(String table, Map<String, Object> data) {
        if (data.size() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(table).append("(");
        ArrayList keys = Lists.newArrayList();
        ArrayList params = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            keys.add(key);
            params.add(entry.getValue());
        }
        sql.append(Joiner.on((char)',').join(keys));
        sql.append(") values(");
        for (int i = 0; i < keys.size(); ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append('?');
        }
        sql.append(")");
        return this.jdbcTemplate.update(sql.toString(), params.toArray());
    }

    public <T> int update(T entity) {
        return this.getSQLExecutor(entity).update(entity);
    }

    public <T> int update(String tableName, T entity) {
        return this.getSQLExecutor(tableName, entity).update(entity);
    }

    public <T> int update(T entity, String ... properties) {
        if (properties == null || properties.length == 0) {
            throw new IllegalArgumentException("properties can't be empty");
        }
        return this.getSQLExecutor(entity).update(entity, properties);
    }

    public <T> int update(String tableName, T entity, String ... properties) {
        if (properties == null || properties.length == 0) {
            throw new IllegalArgumentException("properties can't be empty");
        }
        return this.getSQLExecutor(tableName, entity).update(entity, properties);
    }

    public int update(String table, String column, Object value, String condition, Object ... conditionParams) {
        if (Strings.isNullOrEmpty((String)condition)) {
            throw new IllegalArgumentException("condition can't be blank");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(table);
        sql.append(" set ").append(column).append(" = ?");
        sql.append(" where ").append(condition);
        ArrayList params = Lists.newArrayList();
        params.add(value);
        params.addAll(Arrays.asList(conditionParams));
        return this.jdbcTemplate.update(sql.toString(), this.rewriteParams(params.toArray()));
    }

    public <T> int update(Class<T> klass, String column, Object value, String condition, Object ... conditionParams) {
        String tableName = EntityClassWrapper.wrap(klass).getTableName();
        return this.update(tableName, column, value, condition, conditionParams);
    }

    public <T> int touch(T entity) {
        this.setupUpdatedAt(entity);
        return this.update(entity, "updatedAt");
    }

    public <T> int touch(String tableName, T entity) {
        this.setupUpdatedAt(entity);
        return this.update(tableName, entity, "updatedAt");
    }

    private <T> void setupUpdatedAt(T entity) {
        EntityClassWrapper wrapper = EntityClassWrapper.wrap(entity);
        EntityClassWrapper.ColumnField columnField = wrapper.getColumnField("updatedAt");
        if (columnField == null) {
            throw new IllegalArgumentException("entity\u7f3a\u5c11updatedAt\u5c5e\u6027");
        }
        Class<?> type = columnField.getType();
        Object value = null;
        if (type == DateTime.class) {
            value = DateTime.now();
        } else if (type == Date.class) {
            value = new Date();
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684updatedAt\u7c7b\u578b\uff0c\u76ee\u524d\u53ea\u652f\u6301org.joda.time.DateTime, java.util.Date");
        }
        columnField.set(entity, value);
    }

    public <T> T lock(T entity) {
        Class<?> klass = entity.getClass();
        EntityClassWrapper wrapper = EntityClassWrapper.wrap(klass);
        EntityClassWrapper.ColumnField idColumnField = wrapper.getIdColumnField();
        Object id = idColumnField.get(entity);
        return (T)this.lock(klass, id);
    }

    public <T> T lock(Class<T> klass, Object id) {
        EntityClassWrapper wrapper = EntityClassWrapper.wrap(klass);
        EntityClassWrapper.ColumnField idColumnField = wrapper.getIdColumnField();
        return this.from(klass).where(idColumnField.getColumnName(), id).lock().first(klass);
    }

    public <T> int delete(T entity) {
        return this.getSQLExecutor(entity).delete(entity);
    }

    public <T> int delete(String table, T id) {
        return this.delete(table, "id", id);
    }

    public <T> int delete(Class<T> klass, T id) {
        EntityClassWrapper wrapper = EntityClassWrapper.wrap(klass);
        return this.delete(wrapper.getTableName(), "id", id);
    }

    public <T> int delete(String table, String column, T value) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(table);
        sql.append(" where ").append(column).append(" = ?");
        return this.jdbcTemplate.update(sql.toString(), new Object[]{value});
    }

    public void execute(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    public int execute(String sql, Object ... objects) {
        return this.jdbcTemplate.update(sql, objects);
    }

    public <E> E load(E e) {
        return this.load(e, true);
    }

    public <E> E load(E e, boolean recursive) {
        if (e == null) {
            return null;
        }
        if (e instanceof List) {
            return (E)this.load((List)e, recursive);
        }
        EntityClassWrapper classWrapper = EntityClassWrapper.wrap(e);
        EntityWrapper entityWrapper = new EntityWrapper(e);
        this.loadReference(e, classWrapper, entityWrapper);
        this.loadReferences(e, classWrapper, entityWrapper);
        if (recursive) {
            for (EntityClassWrapper.EntityField f : classWrapper.getEntityFields()) {
                Object child = f.get(e);
                this.load(child, true);
            }
        }
        return e;
    }

    private <E> void loadReferences(E e, EntityClassWrapper classWrapper, EntityWrapper entityWrapper) {
        for (EntityClassWrapper.ReferencesField f : classWrapper.getReferencesFields()) {
            Class<?> referenceEntityClass = f.getReferenceEntityClasss();
            String orderBy = f.getOrderBy();
            EntityClassWrapper referenceClassWrapper = EntityClassWrapper.wrap(referenceEntityClass);
            EntityClassWrapper.ColumnField columnField = referenceClassWrapper.getColumnField(f.getProperty());
            Query query = this.from(referenceEntityClass).where(columnField.getColumnName(), entityWrapper.getId());
            if (!Strings.isNullOrEmpty((String)orderBy)) {
                query.orderBy(orderBy);
            }
            List<?> references = query.all(referenceEntityClass);
            f.set(e, references);
        }
    }

    private <E> void loadReference(E e, EntityClassWrapper classWrapper, EntityWrapper entityWrapper) {
        for (EntityClassWrapper.ReferenceField f : classWrapper.getReferenceFields()) {
            String referenceProperty = f.getReferenceProperty();
            Class<?> referenceEntityClass = f.getReferenceEntityClasss();
            if (f.isInverse()) {
                EntityClassWrapper referenceClassWrapper = EntityClassWrapper.wrap(referenceEntityClass);
                Object id = entityWrapper.getId();
                EntityClassWrapper.ColumnField referenceEntityField = referenceClassWrapper.getColumnField(referenceProperty);
                Object reference = this.from(referenceEntityClass).where(referenceEntityField.getColumnName(), id).first(referenceEntityClass);
                f.set(e, reference);
                continue;
            }
            Object referenceId = entityWrapper.getPropertyValue(referenceProperty);
            if (referenceId == null) continue;
            Object reference = this.find(referenceEntityClass, referenceId);
            f.set(e, reference);
        }
    }

    public <E> List<E> load(List<E> input) {
        return this.load(input, true);
    }

    public <E> List<E> load(List<E> input, boolean recursive) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        Class<?> klass = input.get(0).getClass();
        EntityClassWrapper classWrapper = EntityClassWrapper.wrap(klass);
        this.loadReference(input, classWrapper);
        this.loadReferences(input, classWrapper);
        if (recursive) {
            for (EntityClassWrapper.EntityField f : classWrapper.getEntityFields()) {
                List<Object> entities = Lists.map(input, f.getName());
                entities = Lists.flatten(entities);
                entities = Lists.compact(entities);
                this.load(entities, true);
            }
        }
        return input;
    }

    private <E> void loadReferences(List<E> input, EntityClassWrapper classWrapper) {
        for (EntityClassWrapper.ReferencesField f : classWrapper.getReferencesFields()) {
            EntityClassWrapper.ColumnField idField = classWrapper.getIdColumnField();
            List ids = Lists.map(input, idField.getName());
            Class<?> referenceEntityClass = f.getReferenceEntityClasss();
            String orderBy = f.getOrderBy();
            EntityClassWrapper referenceClassWrapper = EntityClassWrapper.wrap(referenceEntityClass);
            EntityClassWrapper.ColumnField columnField = referenceClassWrapper.getColumnField(f.getProperty());
            Query query = this.from(referenceEntityClass).in(columnField.getColumnName(), ids.toArray());
            if (!Strings.isNullOrEmpty((String)orderBy)) {
                query.orderBy(orderBy);
            }
            List<?> references = query.all(referenceEntityClass);
            for (E e : input) {
                Object id = idField.get(e);
                List<?> values = Lists.filter(references, f.getProperty(), id);
                f.set(e, values);
            }
        }
    }

    private <E> void loadReference(List<E> input, EntityClassWrapper classWrapper) {
        for (EntityClassWrapper.ReferenceField f : classWrapper.getReferenceFields()) {
            Object value;
            Object referenceValue;
            Map valueMap;
            List<?> referenceValues;
            String referenceProperty = f.getReferenceProperty();
            Class<?> referenceEntityClass = f.getReferenceEntityClasss();
            EntityClassWrapper referenceClassWrapper = EntityClassWrapper.wrap(referenceEntityClass);
            if (f.isInverse()) {
                EntityClassWrapper.ColumnField idField = classWrapper.getIdColumnField();
                List idValues = Lists.map(input, idField.getName());
                EntityClassWrapper.ColumnField referenceField = referenceClassWrapper.getColumnField(referenceProperty);
                referenceValues = this.from(referenceEntityClass).in(referenceField.getColumnName(), idValues.toArray()).all(referenceEntityClass);
                valueMap = Lists.toMap(referenceValues, referenceField.getName());
                for (E e : input) {
                    referenceValue = idField.get(e);
                    value = valueMap.get(referenceValue);
                    if (value == null) continue;
                    f.set(e, value);
                }
                continue;
            }
            List referenceIdValues = Lists.map(input, referenceProperty);
            EntityClassWrapper.ColumnField referenceIdField = referenceClassWrapper.getIdColumnField();
            String idColumnName = referenceIdField.getColumnName();
            referenceValues = this.from(referenceEntityClass).in(idColumnName, referenceIdValues.toArray()).all(referenceEntityClass);
            valueMap = Lists.toMap(referenceValues, referenceIdField.getName());
            for (E e : input) {
                referenceValue = classWrapper.getColumnField(referenceProperty).get(e);
                value = valueMap.get(referenceValue);
                if (value == null) continue;
                f.set(e, value);
            }
        }
    }

    public <E> Pagination<E> load(Pagination<E> pagination) {
        this.load(pagination.getData());
        return pagination;
    }

    public void withTransaction(Runnable runnable) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        this.withTransaction((TransactionDefinition)transactionDefinition, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withTransaction(TransactionDefinition transactionDefinition, Runnable runnable) {
        TransactionStatus status = this.transactionManager.getTransaction(transactionDefinition);
        boolean success = false;
        try {
            runnable.run();
            this.transactionManager.commit(status);
            success = true;
        }
        finally {
            if (!success) {
                this.transactionManager.rollback(status);
            }
        }
    }

    public <T> List<T> selectValues(Class<T> klass, String sql, Object ... params) {
        if (Util.isPrimitive(klass)) {
            return this.jdbcTemplate.queryForList(sql, params, klass);
        }
        return this.jdbcTemplate.query(sql, params, this.buildRowMapper(klass));
    }

    public <T> T selectValue(Class<T> klass, String sql, Object ... params) {
        List<T> values = this.selectValues(klass, sql, params);
        if (values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public static enum Type {
        MySQL(MySQLSQLBuilder.class),
        SQLITE(SQLiteSQLBuilder.class);

        private final Class<? extends ISQLBuilder> klass;

        private Type(Class<? extends ISQLBuilder> klass) {
            this.klass = klass;
        }

        public ISQLBuilder newSQLBuilder() {
            try {
                return this.klass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

