/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.zafu.corepage.core;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import cn.edu.zafu.corepage.R;
import cn.edu.zafu.corepage.core.CoreAnim;
import java.util.Arrays;

public class CoreSwitchBean
implements Parcelable {
    public static final Parcelable.Creator<CoreSwitchBean> CREATOR = new Parcelable.Creator<CoreSwitchBean>(){

        public CoreSwitchBean createFromParcel(Parcel in) {
            return new CoreSwitchBean(in);
        }

        public CoreSwitchBean[] newArray(int size) {
            return new CoreSwitchBean[size];
        }
    };
    private String mPageName;
    private Bundle mBundle;
    private int[] mAnim = null;
    private boolean mAddToBackStack = true;
    private boolean mNewActivity = false;
    private int requestCode = -1;

    public CoreSwitchBean(String pageName) {
        this.mPageName = pageName;
    }

    public CoreSwitchBean(String pageName, Bundle bundle) {
        this.mPageName = pageName;
        this.mBundle = bundle;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, CoreAnim coreAnim) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(coreAnim);
    }

    public void setAnim(CoreAnim anim2) {
        this.mAnim = CoreSwitchBean.convertAnimations(anim2);
    }

    public static int[] convertAnimations(CoreAnim coreAnim) {
        if (coreAnim == CoreAnim.present) {
            int[] animations = new int[]{R.anim.push_in_down, R.anim.push_no_ani, R.anim.push_no_ani, R.anim.push_out_down};
            return animations;
        }
        if (coreAnim == CoreAnim.fade) {
            int[] animations = new int[]{R.anim.alpha_in, R.anim.alpha_out, R.anim.alpha_in, R.anim.alpha_out};
            return animations;
        }
        if (coreAnim == CoreAnim.slide) {
            int[] animations = new int[]{R.anim.slide_in_right, R.anim.slide_out_left, R.anim.slide_in_left, R.anim.slide_out_right};
            return animations;
        }
        if (coreAnim == CoreAnim.zoom) {
            int[] animations = new int[]{R.anim.zoom_in, R.anim.zoom_out, R.anim.zoom_in, R.anim.zoom_out};
            return animations;
        }
        return null;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(coreAnim);
        this.mAddToBackStack = addToBackStack;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
        this.mAddToBackStack = addToBackStack;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack, boolean newActivity) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.setAnim(coreAnim);
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
    }

    public CoreSwitchBean(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity, int requestCode) {
        this.mPageName = pageName;
        this.mBundle = bundle;
        this.mAnim = anim2;
        this.mAddToBackStack = addToBackStack;
        this.mNewActivity = newActivity;
        this.requestCode = requestCode;
    }

    protected CoreSwitchBean(Parcel in) {
        this.mPageName = in.readString();
        this.mBundle = in.readBundle();
        int[] a = new int[]{in.readInt(), in.readInt(), in.readInt(), in.readInt()};
        this.mAnim = a;
        this.mAddToBackStack = in.readInt() == 1;
        this.mNewActivity = in.readInt() == 1;
        this.requestCode = in.readInt();
    }

    public String getPageName() {
        return this.mPageName;
    }

    public void setPageName(String pageName) {
        this.mPageName = pageName;
    }

    public boolean isNewActivity() {
        return this.mNewActivity;
    }

    public void setNewActivity(boolean newActivity) {
        this.mNewActivity = newActivity;
    }

    public boolean isAddToBackStack() {
        return this.mAddToBackStack;
    }

    public void setAddToBackStack(boolean addToBackStack) {
        this.mAddToBackStack = addToBackStack;
    }

    public int[] getAnim() {
        return this.mAnim;
    }

    public void setAnim(int[] anim2) {
        this.mAnim = anim2;
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public void setBundle(Bundle bundle) {
        this.mBundle = bundle;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }

    public String toString() {
        return "SwitchBean{mPageName='" + this.mPageName + '\'' + ", mBundle=" + this.mBundle + ", mAnim=" + Arrays.toString(this.mAnim) + ", mAddToBackStack=" + this.mAddToBackStack + ", mNewActivity=" + this.mNewActivity + ", requestCode=" + this.requestCode + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (this.mPageName == null) {
            this.mPageName = "";
        }
        if (this.mBundle == null) {
            this.mBundle = new Bundle();
        }
        if (this.mAnim == null) {
            int[] a = new int[]{-1, -1, -1, -1};
            this.mAnim = a;
        }
        out.writeString(this.mPageName);
        this.mBundle.writeToParcel(out, flags);
        if (this.mAnim != null && this.mAnim.length == 4) {
            out.writeInt(this.mAnim[0]);
            out.writeInt(this.mAnim[1]);
            out.writeInt(this.mAnim[2]);
            out.writeInt(this.mAnim[3]);
        } else {
            out.writeInt(-1);
            out.writeInt(-1);
            out.writeInt(-1);
            out.writeInt(-1);
        }
        out.writeInt(this.mAddToBackStack ? 1 : 0);
        out.writeInt(this.mNewActivity ? 1 : 0);
        out.writeInt(this.requestCode);
    }
}

