/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.zafu.corepage.base;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.KeyEvent;
import cn.edu.zafu.corepage.base.BaseActivity;
import cn.edu.zafu.corepage.core.CoreAnim;
import cn.edu.zafu.corepage.core.CoreSwitchBean;
import cn.edu.zafu.corepage.core.CoreSwitcher;

public class BaseFragment
extends Fragment {
    private static final String TAG = BaseFragment.class.getSimpleName();
    protected Activity mActivity;
    private String mPageName;
    private int mRequestCode;
    private CoreSwitcher mPageCoreSwitcher;
    private OnFragmentFinishListener mFragmentFinishListener;

    public void setFragmentFinishListener(OnFragmentFinishListener listener) {
        this.mFragmentFinishListener = listener;
    }

    public void setFragmentResult(int resultCode, Intent intent) {
        if (this.mFragmentFinishListener != null) {
            this.mFragmentFinishListener.onFragmentResult(this.mRequestCode, resultCode, intent);
        }
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    public void setRequestCode(int code) {
        this.mRequestCode = code;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    public void onFragmentDataReset(Bundle bundle) {
    }

    public void popToBack() {
        this.popToBack(null, null);
    }

    public final void popToBack(String pageName, Bundle bundle) {
        CoreSwitcher coreSwitcher = this.getSwitcher();
        if (coreSwitcher != null) {
            if (pageName == null) {
                coreSwitcher.popPage();
            } else if (this.findPage(pageName)) {
                CoreSwitchBean page = new CoreSwitchBean(pageName, bundle);
                coreSwitcher.gotoPage(page);
            } else {
                coreSwitcher.popPage();
            }
        } else {
            Log.d((String)TAG, (String)"pageSwitcher null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreSwitcher getSwitcher() {
        BaseFragment baseFragment = this;
        synchronized (baseFragment) {
            if (this.mPageCoreSwitcher == null) {
                BaseActivity topActivity;
                if (this.mActivity != null && this.mActivity instanceof CoreSwitcher) {
                    this.mPageCoreSwitcher = (CoreSwitcher)this.mActivity;
                }
                if (this.mPageCoreSwitcher == null && (topActivity = BaseActivity.getTopActivity()) != null && topActivity instanceof CoreSwitcher) {
                    this.mPageCoreSwitcher = topActivity;
                }
            }
        }
        return this.mPageCoreSwitcher;
    }

    public void setSwitcher(CoreSwitcher pageCoreSwitcher) {
        this.mPageCoreSwitcher = pageCoreSwitcher;
    }

    public boolean findPage(String pageName) {
        if (pageName == null) {
            Log.d((String)TAG, (String)"pageName is null");
            return false;
        }
        CoreSwitcher coreSwitcher = this.getSwitcher();
        if (coreSwitcher != null) {
            return coreSwitcher.findPage(pageName);
        }
        Log.d((String)TAG, (String)"pageSwitch is null");
        return false;
    }

    public boolean isFragmentTop(String fragmentTag) {
        CoreSwitcher pageCoreSwitcher = this.getSwitcher();
        if (pageCoreSwitcher != null) {
            return pageCoreSwitcher.isFragmentTop(fragmentTag);
        }
        Log.d((String)TAG, (String)"pageSwitcher is null");
        return false;
    }

    public void onFragmentResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)TAG, (String)("onFragmentResult from baseFragment\uff1arequestCode-" + requestCode + "  resultCode-" + resultCode));
    }

    public final Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim) {
        return this.openPage(pageName, bundle, CoreSwitchBean.convertAnimations(coreAnim), true);
    }

    public final Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack) {
        return this.openPage(pageName, bundle, anim2, addToBackStack, false);
    }

    public final Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity) {
        if (pageName == null) {
            Log.d((String)TAG, (String)"pageName is null");
            return null;
        }
        CoreSwitcher coreSwitcher = this.getSwitcher();
        if (coreSwitcher != null) {
            CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2, addToBackStack, newActivity);
            return coreSwitcher.openPage(page);
        }
        Log.d((String)TAG, (String)"pageSwitcher is null");
        return null;
    }

    public final Fragment openPage(String pageName, Bundle bundle, int[] anim2) {
        return this.openPage(pageName, bundle, anim2, true);
    }

    public final Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack) {
        return this.openPage(pageName, bundle, CoreSwitchBean.convertAnimations(coreAnim), addToBackStack, false);
    }

    public final Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack, boolean newActivity) {
        return this.openPage(pageName, bundle, CoreSwitchBean.convertAnimations(coreAnim), addToBackStack, newActivity);
    }

    public Fragment gotoPage(String pageName, Bundle bundle, CoreAnim coreAnim) {
        return this.gotoPage(pageName, bundle, coreAnim, false);
    }

    public Fragment gotoPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean newActivity) {
        CoreSwitcher pageCoreSwitcher = this.getSwitcher();
        if (pageCoreSwitcher != null) {
            CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, true, newActivity);
            return pageCoreSwitcher.gotoPage(page);
        }
        Log.d((String)TAG, (String)"pageSwitcher is null");
        return null;
    }

    public final Fragment openPageForResult(String pageName, Bundle bundle, CoreAnim coreAnim, int requestCode) {
        return this.openPageForResult(false, pageName, bundle, coreAnim, requestCode);
    }

    public final Fragment openPageForResult(boolean newActivity, String pageName, Bundle bundle, CoreAnim coreAnim, int requestCode) {
        CoreSwitcher pageCoreSwitcher = this.getSwitcher();
        if (pageCoreSwitcher != null) {
            CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, true, newActivity);
            page.setRequestCode(requestCode);
            return pageCoreSwitcher.openPageForResult(page, this);
        }
        Log.d((String)TAG, (String)"pageSwitcher is null");
        return null;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getPageName() != null) {
            Log.d((String)TAG, (String)("====Fragment.onCreate====" + this.getPageName()));
        }
    }

    public String getPageName() {
        return this.mPageName;
    }

    public void setPageName(String pageName) {
        this.mPageName = pageName;
    }

    public void onDetach() {
        super.onDetach();
        this.mActivity = null;
    }

    public static interface OnFragmentFinishListener {
        public void onFragmentResult(int var1, int var2, Intent var3);
    }
}

