/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.zafu.corepage.base;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.KeyEvent;
import cn.edu.zafu.corepage.R;
import cn.edu.zafu.corepage.base.BaseFragment;
import cn.edu.zafu.corepage.core.CoreAnim;
import cn.edu.zafu.corepage.core.CoreConfig;
import cn.edu.zafu.corepage.core.CorePageManager;
import cn.edu.zafu.corepage.core.CoreSwitchBean;
import cn.edu.zafu.corepage.core.CoreSwitcher;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class BaseActivity
extends FragmentActivity
implements CoreSwitcher {
    private static final String TAG = BaseActivity.class.getSimpleName();
    private static List<WeakReference<BaseActivity>> mActivities = new ArrayList<WeakReference<BaseActivity>>();
    protected CoreSwitchBean mFirstCoreSwitchBean;
    private Handler mHandler = null;
    private WeakReference<BaseActivity> mCurrentInstance = null;
    private BaseFragment mFragmentForResult = null;
    private int mFragmentRequestCode = -1;
    private BroadcastReceiver mExitReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("cn.edu.zafu.library.exit")) {
                Log.d((String)TAG, (String)"exit from broadcast");
                BaseActivity.this.finish();
            }
        }
    };

    public static BaseActivity getTopActivity() {
        WeakReference<BaseActivity> ref;
        int size;
        if (mActivities != null && (size = mActivities.size()) >= 1 && (ref = mActivities.get(size - 1)) != null) {
            return (BaseActivity)ref.get();
        }
        return null;
    }

    public static void unInit() {
        if (mActivities != null) {
            mActivities.clear();
        }
    }

    protected String getPageName() {
        BaseFragment frg = this.getActiveFragment();
        if (frg != null) {
            return frg.getPageName();
        }
        return "";
    }

    @Override
    public void popPage() {
        this.popOrFinishActivity();
    }

    private void popOrFinishActivity() {
        if (this.isFinishing()) {
            return;
        }
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 1) {
            if (this.isMainThread()) {
                this.getSupportFragmentManager().popBackStackImmediate();
            } else {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BaseActivity.this.getSupportFragmentManager().popBackStackImmediate();
                    }
                });
            }
        } else {
            this.finishActivity(this, true);
        }
    }

    private boolean isMainThread() {
        return Thread.currentThread() == this.getMainLooper().getThread();
    }

    @Override
    public boolean isFragmentTop(String fragmentTag) {
        FragmentManager.BackStackEntry entry;
        int count;
        BaseActivity activity;
        FragmentManager manager;
        WeakReference<BaseActivity> ref;
        BaseActivity item;
        int size = mActivities.size();
        return size > 0 && (item = (BaseActivity)(ref = mActivities.get(size - 1)).get()) != null && item == this && (manager = (activity = item).getSupportFragmentManager()) != null && (count = manager.getBackStackEntryCount()) >= 1 && (entry = manager.getBackStackEntryAt(count - 1)).getName().equalsIgnoreCase(fragmentTag);
    }

    @Override
    public boolean findPage(String pageName) {
        int size = mActivities.size();
        boolean hasFind = false;
        for (int j = size - 1; j >= 0; --j) {
            WeakReference<BaseActivity> ref = mActivities.get(j);
            if (ref == null) continue;
            BaseActivity item = (BaseActivity)ref.get();
            if (item == null) {
                Log.d((String)TAG, (String)"item is null");
                continue;
            }
            FragmentManager manager = item.getSupportFragmentManager();
            int count = manager.getBackStackEntryCount();
            for (int i = count - 1; i >= 0; --i) {
                String name = manager.getBackStackEntryAt(i).getName();
                if (!name.equalsIgnoreCase(pageName)) continue;
                hasFind = true;
                break;
            }
            if (hasFind) break;
        }
        return hasFind;
    }

    @Override
    public Fragment gotoPage(CoreSwitchBean page) {
        if (page == null) {
            Log.e((String)TAG, (String)"page name empty");
            return null;
        }
        String pageName = page.getPageName();
        if (!this.findPage(pageName)) {
            Log.d((String)TAG, (String)("Be sure you have the right pageName" + pageName));
            return this.openPage(page);
        }
        int size = mActivities.size();
        for (int i = size - 1; i >= 0; --i) {
            WeakReference<BaseActivity> ref = mActivities.get(i);
            if (ref == null) continue;
            BaseActivity item = (BaseActivity)ref.get();
            if (item == null) {
                Log.d((String)TAG, (String)"item null");
                continue;
            }
            boolean findInActivity = this.popFragmentInActivity(pageName, page.getBundle(), item);
            if (findInActivity) break;
            item.finish();
        }
        return null;
    }

    protected boolean popFragmentInActivity(final String pageName, Bundle bundle, BaseActivity findAcitivity) {
        Fragment frg;
        if (pageName == null || findAcitivity == null || findAcitivity.isFinishing()) {
            return false;
        }
        final FragmentManager fragmentManager = findAcitivity.getSupportFragmentManager();
        if (fragmentManager != null && (frg = fragmentManager.findFragmentByTag(pageName)) != null && frg instanceof BaseFragment) {
            if (fragmentManager.getBackStackEntryCount() > 1 && this.mHandler != null) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        fragmentManager.popBackStack(pageName, 0);
                    }
                }, 100L);
            }
            ((BaseFragment)frg).onFragmentDataReset(bundle);
            return true;
        }
        return false;
    }

    public void startActivity(CoreSwitchBean page) {
        try {
            Intent intent = new Intent((Context)this, BaseActivity.class);
            intent.putExtra("SwitchBean", (Parcelable)page);
            this.startActivity(intent);
            int[] animations = page.getAnim();
            if (animations != null && animations.length >= 2) {
                this.overridePendingTransition(animations[0], animations[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void startActivity(Intent intent) {
        try {
            super.startActivity(intent);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("startActivity" + e.getMessage()));
        }
    }

    @Override
    public Fragment openPage(CoreSwitchBean page) {
        boolean addToBackStack = page.isAddToBackStack();
        boolean newActivity = page.isNewActivity();
        Bundle bundle = page.getBundle();
        int[] animations = page.getAnim();
        if (newActivity) {
            this.startActivity(page);
            return null;
        }
        String pageName = page.getPageName();
        return CorePageManager.getInstance().openPageWithNewFragmentManager(this.getSupportFragmentManager(), pageName, bundle, animations, addToBackStack);
    }

    @Override
    public void removeUnlessFragment(List<String> fragmentLists) {
        if (this.isFinishing()) {
            return;
        }
        FragmentManager manager = this.getSupportFragmentManager();
        if (manager != null) {
            FragmentTransaction transaction = manager.beginTransaction();
            for (String tag : fragmentLists) {
                Fragment fragment = manager.findFragmentByTag(tag);
                if (fragment == null) continue;
                transaction.remove(fragment);
            }
            transaction.commitAllowingStateLoss();
            int count = manager.getBackStackEntryCount();
            if (count == 0) {
                this.finish();
            }
        }
    }

    @Override
    public Fragment openPageForResult(CoreSwitchBean page, BaseFragment fragment) {
        if (page != null) {
            if (page.isNewActivity()) {
                Log.d((String)TAG, (String)("openPageForResult start new activity-----" + fragment.getPageName()));
                this.mFragmentForResult = fragment;
                this.mFragmentRequestCode = page.getRequestCode();
                this.startActivityForResult(page);
                return null;
            }
            String pageName = page.getPageName();
            Bundle bundle = page.getBundle();
            int[] animations = page.getAnim();
            boolean addToBackStack = page.isAddToBackStack();
            BaseFragment frg = (BaseFragment)CorePageManager.getInstance().openPageWithNewFragmentManager(this.getSupportFragmentManager(), pageName, bundle, animations, addToBackStack);
            if (frg == null) {
                return null;
            }
            final BaseFragment opener = fragment;
            frg.setRequestCode(page.getRequestCode());
            frg.setFragmentFinishListener(new BaseFragment.OnFragmentFinishListener(){

                @Override
                public void onFragmentResult(int requestCode, int resultCode, Intent intent) {
                    opener.onFragmentResult(requestCode, resultCode, intent);
                }
            });
            return frg;
        }
        Log.d((String)TAG, (String)"openPageForResult.SwitchBean is null");
        return null;
    }

    public void startActivityForResult(CoreSwitchBean page) {
        try {
            Intent intent = new Intent((Context)this, BaseActivity.class);
            intent.putExtra("SwitchBean", (Parcelable)page);
            intent.putExtra("startActivityForResult", "true");
            this.startActivityForResult(intent, page.getRequestCode());
            int[] animations = page.getAnim();
            if (animations != null && animations.length >= 2) {
                this.overridePendingTransition(animations[0], animations[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack, boolean newActivity) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, addToBackStack, newActivity);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack, boolean newActivity) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2, addToBackStack, newActivity);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim, boolean addToBackStack) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim, addToBackStack);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, int[] anim2, boolean addToBackStack) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2, addToBackStack);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, CoreAnim coreAnim) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, coreAnim);
        return this.openPage(page);
    }

    public Fragment openPage(String pageName, Bundle bundle, int[] anim2) {
        CoreSwitchBean page = new CoreSwitchBean(pageName, bundle, anim2);
        return this.openPage(page);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)TAG, (String)("onActivityResult from baseActivity" + requestCode + " " + resultCode));
        if (this.mFragmentRequestCode == requestCode && this.mFragmentForResult != null) {
            this.mFragmentForResult.onFragmentResult(this.mFragmentRequestCode, resultCode, data);
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finishActivity(this, true);
        } else {
            super.onBackPressed();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_base);
        Intent mNewIntent = this.getIntent();
        if (null != savedInstanceState) {
            this.loadActivitySavedData(savedInstanceState);
        }
        this.mHandler = new Handler(this.getMainLooper());
        this.mCurrentInstance = new WeakReference<BaseActivity>(this);
        mActivities.add(this.mCurrentInstance);
        this.printAllActivities();
        this.init(mNewIntent);
        IntentFilter filter = new IntentFilter();
        filter.addAction("cn.edu.zafu.library.exit");
        filter.addCategory("android.intent.category.DEFAULT");
        CoreConfig.getLocalBroadcastManager().registerReceiver(this.mExitReceiver, filter);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        BaseFragment activeFragment = this.getActiveFragment();
        boolean isHanlde = false;
        if (activeFragment != null) {
            isHanlde = activeFragment.onKeyDown(keyCode, event);
        }
        if (!isHanlde) {
            return super.onKeyDown(keyCode, event);
        }
        return isHanlde;
    }

    public BaseFragment getActiveFragment() {
        int count;
        if (this.isFinishing()) {
            return null;
        }
        FragmentManager manager = this.getSupportFragmentManager();
        if (manager != null && (count = manager.getBackStackEntryCount()) > 0) {
            String tag = manager.getBackStackEntryAt(count - 1).getName();
            return (BaseFragment)manager.findFragmentByTag(tag);
        }
        return null;
    }

    protected void onSaveInstanceState(Bundle outState) {
        AccessibleObject[] fields = this.getClass().getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            Annotation[] ans;
            for (Annotation an : ans = ((Field)f).getDeclaredAnnotations()) {
                if (!(an instanceof SaveWithActivity)) continue;
                try {
                    Object o = ((Field)f).get(this);
                    if (o == null) continue;
                    String fieldName = ((Field)f).getName();
                    if (o instanceof Integer) {
                        outState.putInt(fieldName, ((Field)f).getInt(this));
                        continue;
                    }
                    if (o instanceof String) {
                        outState.putString(fieldName, (String)((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Long) {
                        outState.putLong(fieldName, ((Field)f).getLong(this));
                        continue;
                    }
                    if (o instanceof Short) {
                        outState.putShort(fieldName, ((Field)f).getShort(this));
                        continue;
                    }
                    if (o instanceof Boolean) {
                        outState.putBoolean(fieldName, ((Field)f).getBoolean(this));
                        continue;
                    }
                    if (o instanceof Byte) {
                        outState.putByte(fieldName, ((Field)f).getByte(this));
                        continue;
                    }
                    if (o instanceof Character) {
                        outState.putChar(fieldName, ((Field)f).getChar(this));
                        continue;
                    }
                    if (o instanceof CharSequence) {
                        outState.putCharSequence(fieldName, (CharSequence)((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Float) {
                        outState.putFloat(fieldName, ((Field)f).getFloat(this));
                        continue;
                    }
                    if (o instanceof Double) {
                        outState.putDouble(fieldName, ((Field)f).getDouble(this));
                        continue;
                    }
                    if (o instanceof String[]) {
                        outState.putStringArray(fieldName, (String[])((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Parcelable) {
                        outState.putParcelable(fieldName, (Parcelable)((Field)f).get(this));
                        continue;
                    }
                    if (o instanceof Serializable) {
                        outState.putSerializable(fieldName, (Serializable)((Field)f).get(this));
                        continue;
                    }
                    if (!(o instanceof Bundle)) continue;
                    outState.putBundle(fieldName, (Bundle)((Field)f).get(this));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        super.onSaveInstanceState(outState);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        try {
            super.startActivityForResult(intent, requestCode);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("startActivityForResult" + e.getMessage()));
        }
    }

    private void loadActivitySavedData(Bundle savedInstanceState) {
        AccessibleObject[] fields = this.getClass().getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            Annotation[] ans;
            for (Annotation an : ans = ((Field)f).getDeclaredAnnotations()) {
                if (!(an instanceof SaveWithActivity)) continue;
                try {
                    String fieldName = ((Field)f).getName();
                    Class<?> cls = ((Field)f).getType();
                    if (cls == Integer.TYPE || cls == Integer.class) {
                        ((Field)f).setInt(this, savedInstanceState.getInt(fieldName));
                        continue;
                    }
                    if (String.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getString(fieldName));
                        continue;
                    }
                    if (Serializable.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getSerializable(fieldName));
                        continue;
                    }
                    if (cls == Long.TYPE || cls == Long.class) {
                        ((Field)f).setLong(this, savedInstanceState.getLong(fieldName));
                        continue;
                    }
                    if (cls == Short.TYPE || cls == Short.class) {
                        ((Field)f).setShort(this, savedInstanceState.getShort(fieldName));
                        continue;
                    }
                    if (cls == Boolean.TYPE || cls == Boolean.class) {
                        ((Field)f).setBoolean(this, savedInstanceState.getBoolean(fieldName));
                        continue;
                    }
                    if (cls == Byte.TYPE || cls == Byte.class) {
                        ((Field)f).setByte(this, savedInstanceState.getByte(fieldName));
                        continue;
                    }
                    if (cls == Character.TYPE || cls == Character.class) {
                        ((Field)f).setChar(this, savedInstanceState.getChar(fieldName));
                        continue;
                    }
                    if (CharSequence.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getCharSequence(fieldName));
                        continue;
                    }
                    if (cls == Float.TYPE || cls == Float.class) {
                        ((Field)f).setFloat(this, savedInstanceState.getFloat(fieldName));
                        continue;
                    }
                    if (cls == Double.TYPE || cls == Double.class) {
                        ((Field)f).setDouble(this, savedInstanceState.getDouble(fieldName));
                        continue;
                    }
                    if (String[].class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getStringArray(fieldName));
                        continue;
                    }
                    if (Parcelable.class.isAssignableFrom(cls)) {
                        ((Field)f).set(this, savedInstanceState.getParcelable(fieldName));
                        continue;
                    }
                    if (!Bundle.class.isAssignableFrom(cls)) continue;
                    ((Field)f).set(this, savedInstanceState.getBundle(fieldName));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printAllActivities() {
        Log.d((String)TAG, (String)("------------BaseActivity print all------------activities size:" + mActivities.size()));
        for (WeakReference<BaseActivity> ref : mActivities) {
            BaseActivity item;
            if (ref == null || (item = (BaseActivity)ref.get()) == null) continue;
            Log.d((String)TAG, (String)item.toString());
        }
    }

    private void init(Intent mNewIntent) {
        try {
            CoreSwitchBean page = (CoreSwitchBean)mNewIntent.getParcelableExtra("SwitchBean");
            String startActivityForResult = mNewIntent.getStringExtra("startActivityForResult");
            this.mFirstCoreSwitchBean = page;
            if (page != null) {
                BaseFragment fragment = null;
                boolean addToBackStack = page.isAddToBackStack();
                String pageName = page.getPageName();
                Bundle bundle = page.getBundle();
                fragment = (BaseFragment)CorePageManager.getInstance().openPageWithNewFragmentManager(this.getSupportFragmentManager(), pageName, bundle, null, addToBackStack);
                if (fragment != null) {
                    if ("true".equalsIgnoreCase(startActivityForResult)) {
                        fragment.setRequestCode(page.getRequestCode());
                        fragment.setFragmentFinishListener(new BaseFragment.OnFragmentFinishListener(){

                            @Override
                            public void onFragmentResult(int requestCode, int resultCode, Intent intent) {
                                BaseActivity.this.setResult(resultCode, intent);
                            }
                        });
                    }
                } else {
                    this.finish();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)e.getMessage());
            this.finish();
        }
    }

    private void finishActivity(BaseActivity activity, boolean showAnimation) {
        if (activity != null) {
            activity.finish();
            mActivities.remove(this.mCurrentInstance);
        }
        if (showAnimation) {
            int[] animations = null;
            if (activity.mFirstCoreSwitchBean != null && activity.mFirstCoreSwitchBean.getAnim() != null) {
                animations = activity.mFirstCoreSwitchBean.getAnim();
            }
            if (animations != null && animations.length >= 4) {
                this.overridePendingTransition(animations[2], animations[3]);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SaveWithActivity {
    }
}

