/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.zafu.corepage.core;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.util.Log;
import cn.edu.zafu.corepage.R;
import cn.edu.zafu.corepage.base.BaseFragment;
import cn.edu.zafu.corepage.core.CoreConfig;
import cn.edu.zafu.corepage.core.CorePage;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CorePageManager {
    private static final String TAG = CorePageManager.class.getSimpleName();
    private static volatile CorePageManager mInstance = null;
    private Context mContext;
    private Map<String, CorePage> mPageMap = new HashMap<String, CorePage>();

    private CorePageManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CorePageManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<CorePageManager> clazz = CorePageManager.class;
        synchronized (CorePageManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new CorePageManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(Context context) {
        try {
            this.mContext = context.getApplicationContext();
            this.readConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readConfig() {
        Log.d((String)TAG, (String)"readConfig from json");
        String content = this.readFileFromAssets(this.mContext, "page.json");
        JSONArray jsonArray = JSON.parseArray((String)content);
        Iterator iterator = jsonArray.iterator();
        JSONObject jsonPage = null;
        String pageName = null;
        String pageClazz = null;
        String pageParams = null;
        while (iterator.hasNext()) {
            jsonPage = (JSONObject)iterator.next();
            pageName = jsonPage.getString("name");
            pageClazz = jsonPage.getString("class");
            pageParams = jsonPage.getString("params");
            if (TextUtils.isEmpty((CharSequence)pageName) || TextUtils.isEmpty((CharSequence)pageClazz)) {
                Log.d((String)TAG, (String)"page Name is null or pageClass is null");
                return;
            }
            this.mPageMap.put(pageName, new CorePage(pageName, pageClazz, pageParams));
            Log.d((String)TAG, (String)("put a page:" + pageName));
        }
        Log.d((String)TAG, (String)("finished read pages,page size\uff1a" + this.mPageMap.size()));
    }

    private String readFileFromAssets(Context context, String fileName) {
        String result = "";
        try {
            InputStreamReader inputReader = new InputStreamReader(context.getResources().getAssets().open(fileName));
            BufferedReader bufReader = new BufferedReader(inputReader);
            String line = "";
            while ((line = bufReader.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean putPage(String name, Class<? extends BaseFragment> clazz, Map<String, String> params) {
        if (TextUtils.isEmpty((CharSequence)name) || clazz == null) {
            Log.d((String)TAG, (String)"page Name is null or pageClass is null");
            return false;
        }
        if (this.mPageMap.containsKey(name)) {
            Log.d((String)TAG, (String)"page has already put!");
            return false;
        }
        CorePage corePage = new CorePage(name, clazz.getName(), this.buildParams(params));
        Log.d((String)TAG, (String)("put a page:" + name));
        return true;
    }

    private String buildParams(Map<String, String> params) {
        if (params == null) {
            return "";
        }
        String result = JSON.toJSONString(params);
        Log.d((String)TAG, (String)("params:" + result));
        return result;
    }

    public Fragment gotoPage(FragmentManager fragmentManager, String pageName, Bundle bundle, int[] animations) {
        Log.d((String)TAG, (String)("gotoPage:" + pageName));
        Fragment fragment = null;
        if (fragmentManager != null) {
            fragment = fragmentManager.findFragmentByTag(pageName);
        }
        if (fragment != null) {
            fragmentManager.popBackStackImmediate(pageName, 0);
        } else {
            fragment = this.openPageWithNewFragmentManager(fragmentManager, pageName, bundle, animations, true);
        }
        return fragment;
    }

    public Fragment openPageWithNewFragmentManager(FragmentManager fragmentManager, String pageName, Bundle bundle, int[] animations, boolean addToBackStack) {
        BaseFragment fragment = null;
        try {
            Fragment fragmentContainer;
            CorePage corePage = this.mPageMap.get(pageName);
            if (corePage == null) {
                Log.d((String)TAG, (String)("Page:" + pageName + " is null"));
                return null;
            }
            if (CoreConfig.isOpenAtlas()) {
                ClassLoader bundleClassLoader = CoreConfig.getBundleClassLoader();
                if (bundleClassLoader == null) {
                    Log.d((String)TAG, (String)"OpenAtlas bundle ClassLoader is null!");
                    return null;
                }
                fragment = (BaseFragment)((Object)CoreConfig.getBundleClassLoader().loadClass(corePage.getClazz()).newInstance());
            } else {
                fragment = (BaseFragment)((Object)Class.forName(corePage.getClazz()).newInstance());
            }
            Bundle pageBundle = this.buildBundle(corePage);
            if (bundle != null) {
                pageBundle.putAll(bundle);
            }
            fragment.setArguments(pageBundle);
            fragment.setPageName(pageName);
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
            if (animations != null && animations.length >= 4) {
                fragmentTransaction.setCustomAnimations(animations[0], animations[1], animations[2], animations[3]);
            }
            if ((fragmentContainer = fragmentManager.findFragmentById(R.id.fragment_container)) != null) {
                fragmentTransaction.hide(fragmentContainer);
            }
            fragmentTransaction.add(R.id.fragment_container, (Fragment)fragment, pageName);
            if (addToBackStack) {
                fragmentTransaction.addToBackStack(pageName);
            }
            fragmentTransaction.commitAllowingStateLoss();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)("Fragment.error:" + e.getMessage()));
            return null;
        }
        return fragment;
    }

    private Bundle buildBundle(CorePage corePage) {
        Set keySet;
        JSONObject j;
        Bundle bundle = new Bundle();
        String key2 = null;
        Object value = null;
        if (corePage != null && corePage.getParams() != null && (j = JSON.parseObject((String)corePage.getParams())) != null && (keySet = j.keySet()) != null) {
            for (String key2 : keySet) {
                value = j.get((Object)key2);
                bundle.putString(key2, value.toString());
            }
        }
        return bundle;
    }
}

