/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.platform.amap;

import cn.easyutil.util.javaUtil.HttpUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import java.util.List;
import java.util.Map;

public class AmapUtil {
    private String url_getAdByPoint = "http://restapi.amap.com/v3/geocode/regeo?output=json&location=#{lng},#{lat}&key=#{key}";
    private String url_getPointByAd = "http://restapi.amap.com/v3/geocode/geo?key=#{key}&address=#{address}";
    private String url_calc = "http://restapi.amap.com/v3/distance?key=#{key}&origins=#{start}&destination=#{end}";
    private String amap_key = "8e4d4e9ff0c902c3beb36c76f64ac5e9";

    public AmapUtil(String amap_key, String url) {
        this.amap_key = amap_key;
        this.url_getAdByPoint = url;
    }

    public AmapUtil(String amap_key) {
        this.amap_key = amap_key;
    }

    public AmapUtil() {
    }

    private AddressBean getAddressBeanByPoint(String lat, String lng) {
        String url = this.url_getAdByPoint.replace("#{lat}", lat).replace("#{lng}", lng).replace("#{key}", this.amap_key);
        String result = HttpUtil.doUrl(url, "GET");
        Map<String, Object> map = JsonUtil.jsonToMap(result);
        AddressBean addressBean = new AddressBean();
        if (map.get("info") != null && map.get("info").equals("OK") && map.get("regeocode") != null) {
            Map regeocode = (Map)map.get("regeocode");
            if (regeocode.get("formatted_address") != null) {
                String fullAddress = regeocode.get("formatted_address").toString();
                addressBean.setFullAddress(fullAddress);
            }
            if (regeocode.get("addressComponent") != null) {
                Map component = (Map)regeocode.get("addressComponent");
                addressBean.setAreaCode(component.get("citycode") == null ? "" : component.get("citycode").toString());
                addressBean.setCityName(component.get("city") == null ? "" : component.get("city").toString());
                addressBean.setCountryName(component.get("country") == null ? "" : component.get("country").toString());
                addressBean.setDistrictCode(component.get("adcode") == null ? "" : component.get("adcode").toString());
                addressBean.setDistrictName(component.get("district") == null ? "" : component.get("district").toString());
                addressBean.setLat(lat);
                addressBean.setLng(lng);
                addressBean.setProvinceName(component.get("province") == null ? "" : component.get("province").toString());
                addressBean.setTownCode(component.get("towncode") == null ? "" : component.get("towncode").toString());
                addressBean.setTownName(component.get("township") == null ? "" : component.get("township").toString());
            }
        }
        return addressBean;
    }

    public AddressBean getPointByAddress(String address) {
        List geocodes;
        String url = this.url_getPointByAd.replace("#{key}", this.amap_key).replace("#{address}", address);
        String result = HttpUtil.doUrl(url, "GET");
        Map<String, Object> map = JsonUtil.jsonToMap(result);
        AddressBean addressBean = new AddressBean();
        if (map.get("status") != null && map.get("status").equals("1") && map.get("geocodes") != null && (geocodes = (List)map.get("geocodes")) != null && geocodes.size() > 0) {
            String[] split;
            Map component = (Map)geocodes.get(0);
            addressBean.setAreaCode(component.get("citycode") == null ? "" : component.get("citycode").toString());
            addressBean.setCityName(component.get("city") == null ? "" : component.get("city").toString());
            addressBean.setCountryName(component.get("country") == null ? "" : component.get("country").toString());
            addressBean.setDistrictCode(component.get("adcode") == null ? "" : component.get("adcode").toString());
            addressBean.setDistrictName(component.get("district") == null ? "" : component.get("district").toString());
            addressBean.setProvinceName(component.get("province") == null ? "" : component.get("province").toString());
            addressBean.setTownCode(component.get("towncode") == null ? "" : component.get("towncode").toString());
            addressBean.setTownName(component.get("township") == null ? "" : component.get("township").toString());
            addressBean.setFullAddress(component.get("formatted_address") == null ? "" : component.get("formatted_address").toString());
            if (component.get("location") != null && (split = component.get("location").toString().split(",")).length >= 2) {
                addressBean.setLng(split[0]);
                addressBean.setLat(split[1]);
            }
        }
        return addressBean;
    }

    public String getAddressByPoint(String lat, String lng) {
        return this.getAddressBeanByPoint(lat, lng).getFullAddress();
    }

    public Long calcPoint(String startLat, String startLng, String endLat, String endLng) {
        Map r;
        List results;
        String url = this.url_calc.replace("#{key}", this.amap_key).replace("#{start}", startLng + "," + startLat).replace("#{end}", endLng + "," + endLat);
        String result = HttpUtil.doUrl(url, "GET");
        Long distance = 0L;
        Map<String, Object> map = JsonUtil.jsonToMap(result);
        if (map.get("status") != null && map.get("status").equals("1") && map.get("results") != null && (results = (List)map.get("results")).size() > 0 && (r = (Map)results.get(0)).get("distance") != null) {
            distance = Long.valueOf(r.get("distance").toString());
            return distance;
        }
        throw new RuntimeException(result);
    }

    public static void main(String[] args) {
        System.out.println(JsonUtil.beanToJson(new AmapUtil().getPointByAddress("\u676d\u5dde")));
    }

    class AddressBean {
        private String fullAddress;
        private String districtCode;
        private String districtName;
        private String provinceName;
        private String cityName;
        private String areaCode;
        private String countryName;
        private String townName;
        private String townCode;
        private String lat;
        private String lng;

        AddressBean() {
        }

        public String getFullAddress() {
            return this.fullAddress;
        }

        public void setFullAddress(String fullAddress) {
            this.fullAddress = fullAddress;
        }

        public String getDistrictCode() {
            return this.districtCode;
        }

        public void setDistrictCode(String districtCode) {
            this.districtCode = districtCode;
        }

        public String getDistrictName() {
            return this.districtName;
        }

        public void setDistrictName(String districtName) {
            this.districtName = districtName;
        }

        public String getProvinceName() {
            return this.provinceName;
        }

        public void setProvinceName(String provinceName) {
            this.provinceName = provinceName;
        }

        public String getCityName() {
            return this.cityName;
        }

        public void setCityName(String cityName) {
            this.cityName = cityName;
        }

        public String getAreaCode() {
            return this.areaCode;
        }

        public void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        public String getCountryName() {
            return this.countryName;
        }

        public void setCountryName(String countryName) {
            this.countryName = countryName;
        }

        public String getTownName() {
            return this.townName;
        }

        public void setTownName(String townName) {
            this.townName = townName;
        }

        public String getTownCode() {
            return this.townCode;
        }

        public void setTownCode(String townCode) {
            this.townCode = townCode;
        }

        public String getLat() {
            return this.lat;
        }

        public void setLat(String lat) {
            this.lat = lat;
        }

        public String getLng() {
            return this.lng;
        }

        public void setLng(String lng) {
            this.lng = lng;
        }
    }
}

