/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil.http;

import cn.easyutil.util.javaUtil.IOUtil;
import cn.easyutil.util.javaUtil.http.HttpBaseRequest;
import cn.easyutil.util.javaUtil.http.HttpFileReq;
import cn.easyutil.util.javaUtil.http.HttpMethod;
import cn.easyutil.util.javaUtil.http.HttpOperation;
import cn.easyutil.util.javaUtil.http.HttpReq;
import cn.easyutil.util.javaUtil.http.HttpRes;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;

public class HttpClientOperation
extends HttpOperation {
    public HttpClientOperation() {
    }

    public HttpClientOperation(HttpReq httpReq) {
        super(httpReq);
    }

    public HttpClientOperation(String url) {
        super(url);
    }

    public HttpClientOperation(String url, HttpMethod httpMethod) {
        super(url, httpMethod);
    }

    @Override
    protected HttpRes doUrl(boolean useSSL, HttpReq httpReq, InputStream certInput, char[] password) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        StringEntity httpEntity = null;
        HttpBaseRequest request = null;
        try {
            if (useSSL) {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(certInput, password);
                Iterator<Object> sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, password).build();
                SSLConnectionSocketFactory httpRes = new SSLConnectionSocketFactory((SSLContext)((Object)sslcontext));
                httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)httpRes).build();
            }
            request = new HttpBaseRequest(httpReq.getMethod());
            request.setURI(URI.create(httpReq.getUrl()));
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            if (httpReq.getFileParams() != null) {
                for (HttpFileReq httpFileReq : httpReq.getFileParams()) {
                    multipartEntityBuilder.addBinaryBody(httpFileReq.getParamName(), httpFileReq.getContent(), ContentType.DEFAULT_BINARY, httpFileReq.getFileName());
                }
            }
            if (httpReq.getParams().containsKey("_null")) {
                httpEntity = new StringEntity(httpReq.getParams().get("_null").toString(), ContentType.APPLICATION_JSON);
            } else {
                for (Object k : httpReq.getParams().keySet()) {
                    ContentType contentType = ContentType.create((String)"Content-Type", (String)"UTF-8");
                    multipartEntityBuilder.addTextBody(k.toString(), httpReq.getParams().get(k).toString(), contentType);
                }
                httpEntity = multipartEntityBuilder.build();
            }
            request.setEntity((HttpEntity)httpEntity);
            for (Map.Entry entry : httpReq.getHeader().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                request.addHeader(key, value);
            }
            RequestConfig conf = RequestConfig.custom().setConnectTimeout(httpReq.getConnectTimeOut()).build();
            request.setConfig(conf);
            response = httpClient.execute((HttpUriRequest)request);
            HttpRes httpRes = this.processResponse(response);
            return httpRes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
                if (certInput != null) {
                    certInput.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private HttpRes processResponse(CloseableHttpResponse response) {
        HttpRes result = new HttpRes();
        HttpEntity entity = response.getEntity();
        Header[] allHeaders = response.getAllHeaders();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : allHeaders) {
            String name = header.getName();
            String value = header.getValue();
            headers.put(name, value);
        }
        result.setResponseHeaders(headers);
        try {
            result.setResponseCode(response.getStatusLine().getStatusCode());
            byte[] bytes = IOUtil.inputToByte(entity.getContent());
            result.setResponseInputStream(IOUtil.byteToInput(bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

