/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil.bean;

import java.util.Arrays;
import java.util.List;

public enum FileTypeEnum {
    JPEG("FFD8FF", "JPEG"),
    JPG("FFD8FF", "JPG"),
    PNG("89504E47", "PNG"),
    SVG("3c3f786d6c2076657273696f6e3d22312e302220656e636f64696e67", "SVG"),
    AI("255044462d312e340d25e2e3cfd30d0a312030206f626a0d3c3c2f4d", "AI"),
    GIF("47494638", "GIF"),
    TIFF("49492A00", "TIFF"),
    BMP("424D", "BMP"),
    DWG("41433130", "DWG"),
    PSD("38425053", "PSD"),
    RTF("7B5C727466", "RTF"),
    XML("3C3F786D6C", "XML"),
    HTML("68746D6C3E", "HTML"),
    CSS("48544D4C207B0D0A0942", "CSS"),
    JS("696B2E71623D696B2E71", "JS"),
    EML("44656C69766572792D646174653A", "EML"),
    DBX("CFAD12FEC5FD746F", "DBX"),
    PST("2142444E", "PST"),
    XLS("D0CF11E0", "XLS"),
    DOC("D0CF11E0", "DOC"),
    XLSX("504B030414000600080000002100", "XLSX"),
    DOCX("504B030414000600080000002100", "DOCX"),
    VSD("d0cf11e0a1b11ae10000", "VSD"),
    MDB("5374616E64617264204A", "MDB"),
    WPS("d0cf11e0a1b11ae10000", "WPS"),
    TORRENT("6431303A637265617465", "TORRENT"),
    WPD("FF575043", "WPD"),
    EPS("252150532D41646F6265", "EPS"),
    PDF("255044462D312E", "PDF"),
    QDF("AC9EBD8F", "QDF"),
    PWL("E3828596", "PWL"),
    ZIP("504B0304", "ZIP"),
    RAR("52617221", "RAR"),
    JSP("3C2540207061676520", "JSP"),
    JAVA("7061636B61676520", "JAVA"),
    CLASS("CAFEBABE0000002E00", "CLASS"),
    JAR("504B03040A000000", "JAR"),
    MF("4D616E69666573742D56", "MF"),
    EXE("4D5A9000030000000400", "EXE"),
    CHM("49545346030000006000", "CHM"),
    WAV("57415645", "WAV"),
    AVI("41564920", "AVI"),
    RAM("2E7261FD", "RAM"),
    RM("2E524D46", "RM"),
    MPG("000001BA", "MPG"),
    MOV("6D6F6F76", "MOV"),
    ASF("3026B2758E66CF11", "ASF"),
    MID("4D546864", "MID"),
    MP4("00000020667479706d70", "MP4"),
    MP4_1("00000018667479706d70", "MP4"),
    MP3("49443303000000002176", "MP3"),
    FLV("464C5601050000000900", "FLV"),
    UNKNOW(null, null);

    private String header;
    private String type;

    private FileTypeEnum(String header, String type) {
        this.header = header;
        this.type = type;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static FileTypeEnum getFileTypeByType(String type) {
        FileTypeEnum[] values;
        for (FileTypeEnum en : values = FileTypeEnum.values()) {
            if (en == UNKNOW || !en.getType().equalsIgnoreCase(type)) continue;
            return en;
        }
        return UNKNOW;
    }

    public static FileTypeEnum getFileTypeByHeader(String header) {
        FileTypeEnum[] values;
        for (FileTypeEnum en : values = FileTypeEnum.values()) {
            if (en == UNKNOW || !header.toUpperCase().startsWith(en.getHeader().toUpperCase())) continue;
            return en;
        }
        return UNKNOW;
    }

    public static List<FileTypeEnum> pictureTypes() {
        FileTypeEnum[] pics = new FileTypeEnum[]{JPEG, PNG, GIF, TIFF, BMP, DWG, PSD, SVG};
        return Arrays.asList(pics);
    }

    public static List<FileTypeEnum> audiosTypes() {
        FileTypeEnum[] audios = new FileTypeEnum[]{WAV, MP3};
        return Arrays.asList(audios);
    }

    public static List<FileTypeEnum> videoTypes() {
        FileTypeEnum[] videos = new FileTypeEnum[]{AVI, RAM, RM, MPG, MOV, ASF, MP4, FLV, MID, MP4_1};
        return Arrays.asList(videos);
    }

    public static List<FileTypeEnum> docTypes() {
        FileTypeEnum[] docs = new FileTypeEnum[]{RTF, XML, HTML, CSS, JS, EML, DBX, PST, XLS, DOC, XLSX, DOCX, VSD, MDB, WPS, WPD, EPS, PDF, QDF, PWL, ZIP, RAR, JSP, JAVA, CLASS, JAR, MF, EXE, CHM};
        return Arrays.asList(docs);
    }
}

