/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.CalcUtil;
import cn.easyutil.util.javaUtil.CertCoder;
import cn.easyutil.util.javaUtil.ObjectUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class StringUtil {
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "\u6574";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";
    private static final char[] chs = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    static final Map<Integer, String> zoneNum = new HashMap<Integer, String>();
    static final int[] PARITYBIT;
    static final int[] POWER_LIST;

    public static String toPinYin(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    pybf.append(PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat)[0]);
                    continue;
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    throw new RuntimeException(e);
                }
            }
            pybf.append(arr[i]);
        }
        return pybf.toString();
    }

    public static boolean isMobile(String mobile) {
        if (StringUtil.isEmpty(mobile)) {
            return false;
        }
        Pattern p = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$");
        Matcher m = p.matcher(mobile);
        return m.matches();
    }

    public static boolean isMail(String mail) {
        if (StringUtil.isEmpty(mail)) {
            return false;
        }
        String reg = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(mail);
        return m.matches();
    }

    public static boolean isChineseChar(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        String reg = "^[\u4e00-\u9fa5],{0,}$";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isIdCard(String idCard) {
        if (idCard == null || idCard.length() != 15 && idCard.length() != 18) {
            return false;
        }
        if (!zoneNum.containsKey(Integer.valueOf(idCard.substring(0, 2)))) {
            return false;
        }
        String year = idCard.length() == 15 ? "19" + idCard.substring(6, 8) : idCard.substring(6, 10);
        int iyear = Integer.parseInt(year);
        if (iyear < 1900 || iyear > Calendar.getInstance().get(1)) {
            return false;
        }
        String month = idCard.length() == 15 ? idCard.substring(8, 10) : idCard.substring(10, 12);
        int imonth = Integer.parseInt(month);
        if (imonth < 1 || imonth > 12) {
            return false;
        }
        String day = idCard.length() == 15 ? idCard.substring(10, 12) : idCard.substring(12, 14);
        int iday = Integer.parseInt(day);
        if (iday < 1 || iday > 31) {
            return false;
        }
        if (!StringUtil.isValidDate(year + month + day)) {
            return false;
        }
        int power = 0;
        char[] cs = idCard.toUpperCase().toCharArray();
        for (int i = 0; i < cs.length && (i != cs.length - 1 || cs[i] != 'X'); ++i) {
            if (cs[i] < '0' || cs[i] > '9') {
                return false;
            }
            if (i >= cs.length - 1) continue;
            power += (cs[i] - 48) * POWER_LIST[i];
        }
        if (idCard.length() == 15) {
            return true;
        }
        return cs[cs.length - 1] == PARITYBIT[power % 11];
    }

    private static boolean isValidDate(String inDate) {
        if (inDate == null) {
            return false;
        }
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyyMMdd");
        if (inDate.trim().length() != dataFormat.toPattern().length()) {
            return false;
        }
        dataFormat.setLenient(false);
        try {
            dataFormat.parse(inDate.trim());
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private static boolean isDate(String strDate) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        Matcher m = pattern.matcher(strDate);
        return m.matches();
    }

    public static boolean isUrlPath(String url) {
        if (StringUtil.isEmpty(url)) {
            return false;
        }
        return url.trim().toUpperCase().startsWith("HTTP://") || url.trim().toUpperCase().startsWith("HTTPS://");
    }

    public static boolean isIp(String ip) {
        if (StringUtil.isEmpty(ip)) {
            return false;
        }
        String reg = "(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)\\.(25[0-5]|2[0-4]\\d|[0-1]\\d{2}|[1-9]?\\d)";
        Pattern p = Pattern.compile(reg);
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    public static boolean isNumber(String number) {
        try {
            Double.valueOf(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isInteger(String number) {
        try {
            Long.valueOf(number);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String conversionMapUnderscore(String v) {
        String str = "";
        for (int i = 0; i < v.toCharArray().length; ++i) {
            char c = v.toCharArray()[i];
            if (i == 0) {
                c = Character.toLowerCase(c);
            } else if (Character.isUpperCase(c)) {
                str = str + "_" + Character.toLowerCase(c);
                continue;
            }
            str = str + c;
        }
        return str;
    }

    public static String conversionCamelCase(String v) {
        int index = v.indexOf("_");
        while (index != -1) {
            v = v.replace(v.substring(index, index + 2), v.substring(index + 1, index + 2).toUpperCase());
            index = v.indexOf("_");
        }
        return v;
    }

    public static String toChineseMoney(BigDecimal money) {
        return StringUtil.toChineseMoney(money, 2);
    }

    private static String toChineseMoney(BigDecimal money, int money_precision) {
        StringBuffer sb = new StringBuffer();
        int signum = money.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = money.movePointRight(money_precision).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }

    public static String toShortString(String url, int in) {
        String sMD5EncryptResult;
        if (in < 0 || in > 4) {
            in = 0;
        }
        String hex = sMD5EncryptResult = StringUtil.toMD5(url);
        String[] resUrl = new String[4];
        for (int i = 0; i < 4; ++i) {
            String sTempSubString = hex.substring(i * 8, i * 8 + 8);
            long lHexLong = 0x3FFFFFFFL & Long.parseLong(sTempSubString, 16);
            String outChars = "";
            for (int j = 0; j < 6; ++j) {
                long index = 0x3DL & lHexLong;
                outChars = outChars + chs[(int)index];
                lHexLong >>= 5;
            }
            resUrl[i] = outChars;
        }
        return resUrl[in];
    }

    public static String toShortString(String url) {
        return StringUtil.toShortString(url, 0);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (ObjectUtil.isBaseObject(obj)) {
            return obj.toString().equals("");
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            return list.size() == 0;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.size() == 0;
        }
        if (obj.getClass().isArray()) {
            return Arrays.asList(obj).size() == 0;
        }
        Map<String, Object> map = ObjectUtil.getNotNullAttributes(obj);
        return map.size() == 0;
    }

    public static byte[] base64ToByte(String str) {
        try {
            if (str == null) {
                return null;
            }
            return new BASE64Decoder().decodeBuffer(str);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String base64Decode(String str) {
        try {
            if (str == null) {
                return null;
            }
            return new String(StringUtil.base64ToByte(str), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String base64Decode(String str, String charset) {
        try {
            if (str == null) {
                return null;
            }
            return new String(StringUtil.base64ToByte(str), charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String base64Encode(byte[] bts) {
        if (bts == null || bts.length == 0) {
            return null;
        }
        String base64Str = new BASE64Encoder().encode(bts);
        base64Str = base64Str.replace("\r", "").replace("\n", "");
        return base64Str;
    }

    public static String base64Encode(String oldStr) {
        if (oldStr == null) {
            return null;
        }
        try {
            byte[] bts = oldStr.getBytes("UTF-8");
            String base64Str = new BASE64Encoder().encode(bts);
            base64Str = base64Str.replace("\r", "").replace("\n", "");
            return base64Str;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String base64Encode(String oldStr, String charset) {
        try {
            if (oldStr == null) {
                return null;
            }
            byte[] bts = oldStr.getBytes(charset);
            return new BASE64Encoder().encode(bts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b : byteArray) {
            resultCharArray[index++] = hexDigits[b >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b & 0xF];
        }
        return new String(resultCharArray);
    }

    public static String toMD5(byte[] sourceData) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(sourceData);
            return StringUtil.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toMD5(String sourceData) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(sourceData.getBytes());
            return StringUtil.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toMD5(String sourceData, String sourceCharset) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(sourceData.getBytes(sourceCharset));
            return StringUtil.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toSHA1(byte[] sourceData) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(sourceData);
            return StringUtil.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toSHA1(String sourceData) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(sourceData.getBytes());
            return StringUtil.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toSHA1(String sourceData, String sourceCharset) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(sourceData.getBytes(sourceCharset));
            return StringUtil.byteArrayToHex(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toFull(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u0080') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toHalf(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\ufee0' || c[i] >= '\uff60') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String unicodEncode(String input) {
        StringBuffer unicode = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            String hexStr = Integer.toHexString(c);
            while (hexStr.length() < 4) {
                hexStr = "0" + hexStr;
            }
            unicode.append("\\u" + hexStr);
        }
        return unicode.toString();
    }

    public static String unicodDecode(String input) {
        StringBuffer string = new StringBuffer();
        String[] hex = input.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            string.append((char)data);
        }
        return string.toString();
    }

    public static String UrlEncode(String input) {
        return StringUtil.UrlEncode(input, "UTF-8");
    }

    public static String UrlEncode(String input, String charset) {
        try {
            return URLEncoder.encode(input, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String UrlDecode(String input) {
        return StringUtil.UrlDecode(input, "UTF-8");
    }

    public static String UrlDecode(String input, String charset) {
        try {
            return URLDecoder.decode(input, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String DESEncode(String text, String token, String charset) {
        try {
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            byte[] btToken = charset == null ? token.getBytes() : token.getBytes(charset);
            byte[] btText = charset == null ? text.getBytes() : text.getBytes(charset);
            DESKeySpec desKeySpec = new DESKeySpec(btToken);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(btToken);
            cipher.init(1, (Key)secretKey, iv);
            byte[] bts = cipher.doFinal(btText);
            return StringUtil.base64Encode(bts);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String DESEncode(String text, String token) {
        return StringUtil.DESEncode(text, token, null);
    }

    public static String DESDecode(String text, String token, String charset) {
        try {
            byte[] bytesrc = StringUtil.base64ToByte(text);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            byte[] btToken = charset == null ? token.getBytes() : token.getBytes(charset);
            DESKeySpec desKeySpec = new DESKeySpec(btToken);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            IvParameterSpec iv = new IvParameterSpec(btToken);
            cipher.init(2, (Key)secretKey, iv);
            byte[] retByte = cipher.doFinal(bytesrc);
            return charset == null ? new String(retByte) : new String(retByte, charset);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String DESDecode(String text, String token) {
        return StringUtil.DESDecode(text, token, null);
    }

    private static String toAES(String text, String token, String charset) {
        if (token.length() % 16 != 0) {
            throw new RuntimeException("the key size not 16");
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, new SecretKeySpec(token.getBytes(), "AES"));
            byte[] tempBts = cipher.doFinal(charset == null ? text.getBytes() : text.getBytes(charset));
            return StringUtil.base64Encode(tempBts).replace("\r", "").replace("\n", "");
        }
        catch (Exception e) {
            throw new RuntimeException("encryption or Decrypt exception", e);
        }
    }

    public static String AESEncode(String text, String token) {
        return StringUtil.toAES(text, token, "utf-8");
    }

    public static String AESEncode(String text, String token, String charset) {
        return StringUtil.toAES(text, token, charset);
    }

    private static String AESToString(String text, String token, String charset) {
        if (token.length() % 16 != 0) {
            throw new RuntimeException("the key size not 16");
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128);
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, new SecretKeySpec(token.getBytes(), "AES"));
            byte[] bts = cipher.doFinal(StringUtil.base64ToByte(text));
            return charset == null ? new String(bts) : new String(bts, charset);
        }
        catch (Exception e) {
            throw new RuntimeException("encryption or Decrypt exception", e);
        }
    }

    public static String AESDecode(String text, String token) {
        return StringUtil.AESToString(text, token, "utf-8");
    }

    public static String AESDecode(String text, String token, String charset) {
        return StringUtil.AESToString(text, token, charset);
    }

    public static String hexEncode(String src) {
        return StringUtil.hexEncode(src.getBytes());
    }

    public static String hexEncode(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] hexDecode(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(StringUtil.charToByte(hexChars[pos]) << 4 | StringUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String getRandomString(int length, String text) {
        if (StringUtil.isEmpty(text)) {
            throw new NullPointerException("the parameter must not be null");
        }
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(text.length());
            sb.append(text.charAt(number));
        }
        return sb.toString();
    }

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getRandomString(int length) {
        return StringUtil.getRandomString(length, new String(chs));
    }

    public static String unSecret(String val, String token) {
        char[] valBts = val.toCharArray();
        char[] tokenBts = token.toCharArray();
        return StringUtil.secret(valBts, tokenBts, false);
    }

    public static String toSecret(Object val, String token) {
        char[] valBts = val.toString().toCharArray();
        char[] tokenBts = token.toString().toCharArray();
        return StringUtil.secret(valBts, tokenBts, true);
    }

    private static String secret(char[] val, char[] token, boolean isSecret) {
        char[] old = Arrays.copyOf(val, val.length);
        int length = old.length < token.length ? token.length : old.length;
        int i = 0;
        int vm = 0;
        int tm = 0;
        while (i < length) {
            int a;
            vm = vm >= old.length ? 0 : vm;
            tm = tm >= token.length ? 0 : tm;
            char b = token[tm];
            if (isSecret) {
                old[vm] = chs[(a + b) % chs.length];
            } else {
                for (a = StringUtil.find(old[vm]); a < b; a += chs.length) {
                }
                old[vm] = chs[(a - b) % chs.length];
            }
            ++i;
            ++vm;
            ++tm;
        }
        return new String(old);
    }

    private static int find(char ch) {
        for (int i = 0; i < chs.length; ++i) {
            if (chs[i] != ch) continue;
            return i;
        }
        throw new RuntimeException("parameter must be english or number");
    }

    public static byte[] secret(byte[] val, byte[] token, boolean isSecret) {
        byte[] old = Arrays.copyOf(val, val.length);
        int length = old.length < token.length ? token.length : old.length;
        int i = 0;
        int vm = 0;
        int tm = 0;
        while (i < length) {
            vm = vm >= old.length ? 0 : vm;
            tm = tm >= token.length ? 0 : tm;
            old[vm] = isSecret ? (byte)(old[vm] + token[tm]) : (byte)(old[vm] - token[tm]);
            ++i;
            ++vm;
            ++tm;
        }
        return old;
    }

    public static String RSAPrivateEncode(String oldStr, String privateKey) {
        try {
            return CertCoder.doCoderByPrivateKey(oldStr, privateKey, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String RSAPublicEncode(String oldStr, String publicKey) {
        try {
            return CertCoder.doCoderByPublicKey(oldStr, publicKey, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String RSAPrivateDecode(String data, String privateKey) {
        try {
            return CertCoder.doCoderByPrivateKey(data, privateKey, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String RSAPublicDecode(String data, String publicKey) {
        try {
            return CertCoder.doCoderByPrivateKey(data, publicKey, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String RSASign(String oldValue, String privateKey) {
        try {
            return CertCoder.signByPrivateKey(oldValue.getBytes(), privateKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean RSAVerify(String oldValue, String passValue, String publicKey) {
        try {
            return CertCoder.verify(oldValue, passValue, publicKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CertCoder.PassBean createRSAKey() {
        try {
            return CertCoder.initKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static CertCoder.PassBean createRSAKey(Integer size) {
        try {
            return CertCoder.initKey(size);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Double calc(String operStr) {
        return CalcUtil.calcbra(operStr);
    }

    public static Double calc1(String operStr) {
        ScriptEngine se = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            return Double.parseDouble(se.eval(operStr).toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MinIndex minIndexOf(String val, String ... splits) {
        MinIndex mi = new MinIndex();
        for (String split : splits) {
            int temp = val.indexOf(split);
            if (temp == -1 || mi.distance != -1 && mi.distance <= temp) continue;
            mi.distance = temp;
            mi.splitStr = split;
        }
        return mi;
    }

    public static String getRandomUnicodeChar(int length) {
        String str = "";
        while (length-- > 0) {
            str = str + StringUtil.getRandomUnicodeChar();
        }
        return str;
    }

    public static String getRandomUnicodeChar() {
        String str = "";
        Random random = new Random();
        int highCode = 176 + Math.abs(random.nextInt(39));
        int lowCode = 161 + Math.abs(random.nextInt(93));
        byte[] b = new byte[]{Integer.valueOf(highCode).byteValue(), Integer.valueOf(lowCode).byteValue()};
        try {
            str = new String(b, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static String clearEmoji(String text) {
        byte[] bytes = null;
        try {
            bytes = text.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            short b = bytes[i];
            if (b > 0) {
                buffer.put(bytes[i++]);
                continue;
            }
            if (((b = (short)(b + 256)) ^ 0xC0) >> 4 == 0) {
                buffer.put(bytes, i, 2);
                i += 2;
                continue;
            }
            if ((b ^ 0xE0) >> 4 == 0) {
                buffer.put(bytes, i, 3);
                i += 3;
                continue;
            }
            if ((b ^ 0xF0) >> 4 != 0) continue;
            i += 4;
        }
        buffer.flip();
        try {
            return new String(buffer.array(), "utf-8").trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isBaseChar(char c) {
        if (StringUtil.isEmpty(Character.valueOf(c))) {
            return false;
        }
        for (char cr : chs) {
            if (cr != c) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String idcard = "320321199004100417";
        System.out.println(StringUtil.isIdCard(idcard));
    }

    static {
        zoneNum.put(11, "\u5317\u4eac");
        zoneNum.put(12, "\u5929\u6d25");
        zoneNum.put(13, "\u6cb3\u5317");
        zoneNum.put(14, "\u5c71\u897f");
        zoneNum.put(15, "\u5185\u8499\u53e4");
        zoneNum.put(21, "\u8fbd\u5b81");
        zoneNum.put(22, "\u5409\u6797");
        zoneNum.put(23, "\u9ed1\u9f99\u6c5f");
        zoneNum.put(31, "\u4e0a\u6d77");
        zoneNum.put(32, "\u6c5f\u82cf");
        zoneNum.put(33, "\u6d59\u6c5f");
        zoneNum.put(34, "\u5b89\u5fbd");
        zoneNum.put(35, "\u798f\u5efa");
        zoneNum.put(36, "\u6c5f\u897f");
        zoneNum.put(37, "\u5c71\u4e1c");
        zoneNum.put(41, "\u6cb3\u5357");
        zoneNum.put(42, "\u6e56\u5317");
        zoneNum.put(43, "\u6e56\u5357");
        zoneNum.put(44, "\u5e7f\u4e1c");
        zoneNum.put(45, "\u5e7f\u897f");
        zoneNum.put(46, "\u6d77\u5357");
        zoneNum.put(50, "\u91cd\u5e86");
        zoneNum.put(51, "\u56db\u5ddd");
        zoneNum.put(52, "\u8d35\u5dde");
        zoneNum.put(53, "\u4e91\u5357");
        zoneNum.put(54, "\u897f\u85cf");
        zoneNum.put(61, "\u9655\u897f");
        zoneNum.put(62, "\u7518\u8083");
        zoneNum.put(63, "\u9752\u6d77");
        zoneNum.put(64, "\u5b81\u590f");
        zoneNum.put(65, "\u65b0\u7586");
        zoneNum.put(71, "\u53f0\u6e7e");
        zoneNum.put(81, "\u9999\u6e2f");
        zoneNum.put(82, "\u6fb3\u95e8");
        zoneNum.put(91, "\u56fd\u5916");
        PARITYBIT = new int[]{49, 48, 88, 57, 56, 55, 54, 53, 52, 51, 50};
        POWER_LIST = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    }

    public static class MinIndex {
        public int distance = -1;
        public String splitStr = "+";
    }
}

