/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.ImageUtil;
import cn.easyutil.util.javaUtil.bean.MergeImageBean;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hslf.model.Slide;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.usermodel.PictureData;
import org.apache.poi.hslf.usermodel.RichTextRun;
import org.apache.poi.hslf.usermodel.SlideShow;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;

public class PPTUtil {
    public static List<byte[]> parseToPicture(InputStream input, String pptFileName) {
        try {
            if (pptFileName.endsWith(".ppt")) {
                SlideShow show = new SlideShow(input);
                return PPTUtil.parsePPTToPicture(show);
            }
            if (pptFileName.endsWith(".pptx")) {
                XMLSlideShow show = new XMLSlideShow(input);
                return PPTUtil.parsePPTXToPicture(show);
            }
            throw new RuntimeException("file type not ppt");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<byte[]> parsePPTToPicture(SlideShow show) {
        Dimension pgsize = show.getPageSize();
        Slide[] slide = show.getSlides();
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (Slide s : slide) {
            TextRun[] truns = s.getTextRuns();
            for (int k = 0; k < truns.length; ++k) {
                RichTextRun[] rtruns = truns[k].getRichTextRuns();
                for (int l = 0; l < rtruns.length; ++l) {
                    rtruns[l].setFontIndex(1);
                    rtruns[l].setFontName("\u5b8b\u4f53");
                }
            }
            BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
            s.draw(graphics);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)img, "jpeg", out);
                list.add(out.toByteArray());
                out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    private static List<byte[]> parsePPTXToPicture(XMLSlideShow show) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        Dimension pgsize = show.getPageSize();
        List slides = show.getSlides();
        for (XSLFSlide xslf : slides) {
            List shapes = xslf.getShapes();
            for (XSLFShape shape : shapes) {
                if (!(shape instanceof XSLFTextShape)) continue;
                XSLFTextShape sh = (XSLFTextShape)shape;
                List textParagraphs = sh.getTextParagraphs();
                for (XSLFTextParagraph xslfTextParagraph : textParagraphs) {
                    List textRuns = xslfTextParagraph.getTextRuns();
                    for (XSLFTextRun xslfTextRun : textRuns) {
                        xslfTextRun.setFontFamily("\u5b8b\u4f53");
                    }
                }
            }
            BufferedImage img = new BufferedImage(pgsize.width, pgsize.height, 1);
            Graphics2D graphics = img.createGraphics();
            graphics.setPaint(Color.white);
            graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, pgsize.width, pgsize.height));
            xslf.draw(graphics);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)img, "jpeg", out);
                list.add(out.toByteArray());
                out.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    public static List<byte[]> readImages(InputStream input, String pptFileName) {
        try {
            if (pptFileName.endsWith(".ppt")) {
                HSLFSlideShow show = new HSLFSlideShow(input);
                return PPTUtil.readPPTImages(show);
            }
            if (pptFileName.endsWith(".pptx")) {
                XMLSlideShow show = new XMLSlideShow(input);
                return PPTUtil.readPPTXImages(show);
            }
            throw new RuntimeException("file type not ppt");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<byte[]> readPPTImages(HSLFSlideShow show) {
        PictureData[] ps;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (PictureData p : ps = show.getPictures()) {
            byte[] pictureData = p.getData();
            list.add(pictureData);
        }
        return list;
    }

    private static List<byte[]> readPPTXImages(XMLSlideShow show) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        List ps = show.getPictureData();
        for (XSLFPictureData p : ps) {
            byte[] pictureData = p.getData();
            list.add(pictureData);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        List<byte[]> list = PPTUtil.parseToPicture(new FileInputStream(new File("D://11.ppt")), "11.pptx");
        ArrayList<MergeImageBean> li = new ArrayList<MergeImageBean>();
        int i = 0;
        for (byte[] bs : list) {
            MergeImageBean bean;
            if (i == 3) break;
            if (i == 0) {
                bean = new MergeImageBean();
                bean.setImg(ImageUtil.byteToImg(bs));
                bean.setX(0);
                bean.setY(0);
                bean.setWeight(300);
                bean.setHeight(300);
                li.add(bean);
            } else if (i == 1) {
                bean = new MergeImageBean();
                bean.setImg(ImageUtil.byteToImg(bs));
                bean.setX(0);
                bean.setY(300);
                bean.setWeight(150);
                bean.setHeight(300);
                li.add(bean);
            } else if (i == 2) {
                bean = new MergeImageBean();
                bean.setImg(ImageUtil.byteToImg(bs));
                bean.setX(150);
                bean.setY(300);
                bean.setWeight(150);
                bean.setHeight(300);
                li.add(bean);
            }
            ++i;
        }
        byte[] mer = ImageUtil.mergeImage(300, 600, li);
        FileOutputStream out = new FileOutputStream(new File("D:/ppt/\u5408\u6210.png"));
        out.write(mer);
        out.close();
    }
}

