/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDFUtil {
    public static void pdfToImage(InputStream in, OutputStream imageOut, int dpi) {
        if (in == null) {
            throw new RuntimeException("import of pdf must not be null");
        }
        PDDocument pdDocument = null;
        try {
            int count = 0;
            long start = System.currentTimeMillis();
            while (count == 0) {
                if (System.currentTimeMillis() - start > 3000L) {
                    throw new RuntimeException("read InputStream timeout");
                }
                count = in.available();
            }
            byte[] but = new byte[count];
            int length = 0;
            while ((length = in.read(but)) != -1) {
            }
            pdDocument = PDDocument.load((byte[])but);
            PDFRenderer renderer = new PDFRenderer(pdDocument);
            PdfReader reader = new PdfReader(but);
            int pages = reader.getNumberOfPages();
            for (int i = 0; i < pages; ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, (float)dpi);
                ImageIO.write((RenderedImage)image, "png", imageOut);
            }
            LoggerUtil.debug(PDFUtil.class, "pdf Conversion image success");
        }
        catch (IOException e) {
            LoggerUtil.error(PDFUtil.class, "pdf Conversion image failed");
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (pdDocument != null) {
                    pdDocument.close();
                }
                if (imageOut != null) {
                    imageOut.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void pdfToImage(String pdfPath, String imagePath) {
        try {
            PDFUtil.pdfToImage((InputStream)new FileInputStream(new File(pdfPath)), new FileOutputStream(new File(imagePath)), 300);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void pdfToImage(InputStream in, String imagePath) {
        if (!imagePath.endsWith(".png")) {
            imagePath = imagePath + ".png";
        }
        try {
            PDFUtil.pdfToImage(in, new FileOutputStream(new File(imagePath)), 300);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void pdfToImage(InputStream in, HttpServletResponse response, int dpi) {
        try {
            PDFUtil.pdfToImage(in, (OutputStream)response.getOutputStream(), dpi);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void pdfToImage(String pdfPath, HttpServletResponse response, int dpi) {
        try {
            PDFUtil.pdfToImage((InputStream)new FileInputStream(new File(pdfPath)), response, dpi);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void pdfToImage(InputStream in, HttpServletResponse response) {
        PDFUtil.pdfToImage(in, response, 300);
    }

    public static void imageToPdf(String imagePath, String pdfPath) {
        if (!pdfPath.endsWith(".pdf")) {
            pdfPath = pdfPath.contains(".") ? pdfPath.substring(0, pdfPath.indexOf(".")) + ".pdf" : pdfPath + ".pdf";
        }
        try {
            BufferedImage img = ImageIO.read(new File(imagePath));
            FileOutputStream fos = new FileOutputStream(pdfPath);
            Document doc = new Document(null, 0.0f, 0.0f, 0.0f, 0.0f);
            doc.setPageSize(new Rectangle((float)img.getWidth(), (float)img.getHeight()));
            Image image = Image.getInstance((String)imagePath);
            float scalePercentage = 24.0f;
            image.scalePercent(scalePercentage, scalePercentage);
            PdfWriter.getInstance((Document)doc, (OutputStream)fos);
            doc.open();
            doc.add((Element)image);
            doc.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void insertText(String pdfPath, String outPath, Map<String, Object> map) {
        if (StringUtil.isEmpty(map)) {
            throw new NullPointerException("filling data must not be null");
        }
        try {
            if (!outPath.endsWith(".pdf")) {
                outPath = outPath.contains(".") ? outPath.substring(0, outPath.indexOf(".")) + ".pdf" : outPath + ".pdf";
            }
            FileInputStream in = new FileInputStream(new File(pdfPath));
            ByteArrayOutputStream out = (ByteArrayOutputStream)PDFUtil.generate(new PdfReader((InputStream)in), map);
            FileOutputStream fos = new FileOutputStream(outPath);
            ((OutputStream)fos).write(out.toByteArray());
            ((OutputStream)fos).close();
            out.close();
            LoggerUtil.debug(PDFUtil.class, "PDF filling success");
        }
        catch (Exception e) {
            LoggerUtil.error(PDFUtil.class, "PDF filling failed");
            throw new RuntimeException(e);
        }
    }

    private static OutputStream generate(PdfReader template, Map<String, Object> data) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PdfStamper stamp = new PdfStamper(template, (OutputStream)out);
            AcroFields form = stamp.getAcroFields();
            for (String key : data.keySet()) {
                String value = data.get(key).toString();
                form.setFieldProperty(key, "textfont", (Object)BaseFont.createFont(), null);
                form.setField(key, value);
            }
            stamp.setFormFlattening(true);
            stamp.close();
            template.close();
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        PDFUtil.pdfToImage((InputStream)new FileInputStream(new File("D://www.pdf")), "D://ww-ong.png");
    }
}

