/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import java.math.BigDecimal;

public class NumberCalcUtil {
    private BigDecimal value;
    private int digits = 2;
    private boolean rounding = true;

    public static NumberCalcUtil of(Number number, int digits) {
        return new NumberCalcUtil(number, digits);
    }

    public static NumberCalcUtil of(Number number) {
        return new NumberCalcUtil(number, 2);
    }

    public NumberCalcUtil(Number number, int digits, boolean rounding) {
        this.digits = digits;
        this.rounding = rounding;
        this.value = BigDecimal.valueOf(number.doubleValue());
    }

    public NumberCalcUtil(Number number, int digits) {
        this(number, digits, false);
    }

    public NumberCalcUtil addition(Number a) {
        this.value = this.value.add(BigDecimal.valueOf(a.doubleValue())).setScale(this.digits, this.rounding ? 4 : 1);
        return this;
    }

    public BigDecimal getResult() {
        return this.value.setScale(this.digits, this.rounding ? 4 : 1);
    }

    public NumberCalcUtil subtraction(Number a) {
        this.value = this.value.subtract(BigDecimal.valueOf(a.doubleValue())).setScale(this.digits, this.rounding ? 4 : 1);
        return this;
    }

    public NumberCalcUtil multiply(Number a) {
        if (a.doubleValue() == 0.0) {
            this.value = new BigDecimal(0);
            return this;
        }
        this.value = this.value.multiply(BigDecimal.valueOf(a.doubleValue())).setScale(this.digits, this.rounding ? 4 : 1);
        return this;
    }

    public NumberCalcUtil divide(Number a) {
        if (a.doubleValue() == 0.0) {
            this.value = new BigDecimal(0);
            return this;
        }
        this.value = this.value.divide(BigDecimal.valueOf(a.doubleValue()), this.digits, this.rounding ? 4 : 1);
        return this;
    }
}

