/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.HttpUtil;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.bean.IpAddressBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IpUtil {
    public static String getLocalIp() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            String ip = ia.toString().split("/")[1];
            return ip;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPublicIp() {
        try {
            String ip = "";
            String chinaz = "http://ip.chinaz.com";
            String result = HttpUtil.doUrl(chinaz, "GET");
            Pattern p = Pattern.compile("\\<dd class\\=\"fz24\">(.*?)\\<\\/dd>");
            Matcher m = p.matcher(result);
            if (m.find()) {
                String ipstr;
                ip = ipstr = m.group(1);
            }
            return ip;
        }
        catch (Exception e) {
            throw new RuntimeException("\u65b9\u6cd5\u5185\u90e8\u9519\u8bef");
        }
    }

    public static String getLocalMac() {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i != 0) {
                    sb.append("-");
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append("0" + str);
                    continue;
                }
                sb.append(str);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IpAddressBean getIpAddress(String publicIp) {
        String url = "http://ip.taobao.com/service/getIpInfo.php?ip=" + publicIp;
        String address = HttpUtil.doUrl(url, "GET");
        Map<String, Object> map = JsonUtil.jsonToMap(address);
        if (map.get("code").equals(0)) {
            Map data = (Map)map.get("data");
            IpAddressBean bean = JsonUtil.mapToBean(data, IpAddressBean.class);
            return bean;
        }
        throw new RuntimeException("error:" + address);
    }
}

