/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.IOUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.bean.FileTypeEnum;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class FileUtil {
    public static boolean isPicture(InputStream input) {
        byte[] but = IOUtil.inputToByte(input);
        return FileUtil.isPicture(but);
    }

    public static boolean isVideo(InputStream input) {
        byte[] but = IOUtil.inputToByte(input);
        return FileUtil.isVideo(but);
    }

    public static boolean isDoc(InputStream input) {
        byte[] but = IOUtil.inputToByte(input);
        return FileUtil.isDoc(but);
    }

    public static boolean isAudio(InputStream input) {
        byte[] but = IOUtil.inputToByte(input);
        return FileUtil.isAudio(but);
    }

    public static boolean isAudio(byte[] but) {
        return FileTypeEnum.audiosTypes().contains((Object)FileUtil.getType(but));
    }

    public static boolean isDoc(byte[] but) {
        return FileTypeEnum.docTypes().contains((Object)FileUtil.getType(but));
    }

    public static boolean isVideo(byte[] but) {
        return FileTypeEnum.videoTypes().contains((Object)FileUtil.getType(but));
    }

    public static boolean isPicture(byte[] but) {
        return FileTypeEnum.pictureTypes().contains((Object)FileUtil.getType(but));
    }

    public static FileTypeEnum getType(InputStream input) {
        byte[] but = IOUtil.inputToByte(input);
        return FileUtil.getType(but);
    }

    public static FileTypeEnum getType(byte[] but) {
        if (but == null || but.length < 28) {
            throw new RuntimeException("\u6587\u4ef6\u89e3\u6790\u9519\u8bef");
        }
        byte[] data = new byte[28];
        for (int i = 0; i < data.length; ++i) {
            data[i] = but[i];
        }
        String header = FileUtil.bytesToHexString(data);
        return FileTypeEnum.getFileTypeByHeader(header);
    }

    public static byte[] toByteArray(String filePath) {
        File file = new File(filePath);
        return FileUtil.toByteArray(file);
    }

    public static InputStream toInput(String filePath) {
        try {
            return new FileInputStream(new File(filePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFileName(String url) {
        url = url.replace("/", File.separator).replace("\\\\", File.separator);
        return url.substring(url.lastIndexOf(File.separator) + 1);
    }

    public static String getSuffix(String url) {
        if (!url.contains(".")) {
            return null;
        }
        return url.substring(url.lastIndexOf(".") + 1);
    }

    @SafeVarargs
    public static void copy(String from, String to, FileExecutor<?> ... executors) {
        from = from.replace("/", File.separator).replace("\\\\", File.separator);
        to = to.replace("/", File.separator).replace("\\\\", File.separator);
        File fromFile = new File(from);
        if (!fromFile.exists()) {
            LoggerUtil.error(FileUtil.class, "\u62f7\u8d1d\u7684\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728 [ " + from + " ]");
            return;
        }
        if (fromFile.isDirectory()) {
            File dirFile = new File(to);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            for (File sonFile : fromFile.listFiles()) {
                boolean filterRresult = true;
                if (executors != null) {
                    for (FileExecutor<?> filter : executors) {
                        filterRresult &= filter.doExec(sonFile);
                    }
                }
                if (!filterRresult) continue;
                FileUtil.copy(from + File.separator + sonFile.getName(), to + File.separator + sonFile.getName(), executors);
            }
        } else {
            String parentDir;
            File dirFile;
            if (to.lastIndexOf(File.separator) == to.length() - 1) {
                new File(to).mkdirs();
                to = to + fromFile.getName();
            }
            if (!(dirFile = new File(parentDir = to.substring(0, to.lastIndexOf(File.separator)))).exists()) {
                dirFile.mkdirs();
            }
            try {
                FileInputStream in = new FileInputStream(fromFile);
                FileUtil.save(in, new File(to));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void copyWithString(String from, String to, FileExecutor<?> ... executors) {
        from = from.replace("/", File.separator).replace("\\\\", File.separator);
        to = to.replace("/", File.separator).replace("\\\\", File.separator);
        File fromFile = new File(from);
        if (!fromFile.exists()) {
            throw new RuntimeException("\u62f7\u8d1d\u7684\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728 [ " + from + " ]");
        }
        if (fromFile.isDirectory()) {
            File dirFile = new File(to);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            for (File sonFile : fromFile.listFiles()) {
                boolean filterRresult = true;
                if (executors != null) {
                    for (FileExecutor<?> filter : executors) {
                        filterRresult &= filter.doExec(sonFile);
                    }
                }
                if (!filterRresult) continue;
                to = to.lastIndexOf(File.separator) == to.length() - 1 ? to : to + File.separator;
                FileUtil.copyWithString(from + File.separator + sonFile.getName(), to + sonFile.getName(), executors);
            }
        } else {
            String parentDir;
            File dirFile;
            if (to.lastIndexOf(File.separator) == to.length() - 1) {
                new File(to).mkdirs();
                to = to + fromFile.getName();
            }
            if (!(dirFile = new File(parentDir = to.substring(0, to.lastIndexOf(File.separator)))).exists()) {
                dirFile.mkdirs();
            }
            FileUtil.saveWithString(fromFile, new File(to), executors);
        }
    }

    public static void saveWithString(File from, File to, FileExecutor<?> ... executors) {
        String suffix = FileUtil.getSuffix(from.getName());
        switch (suffix = suffix == null ? null : suffix.toLowerCase()) {
            case "zip": 
            case "rar": 
            case "jar": 
            case "war": 
            case "jpg": 
            case "png": 
            case "gif": {
                FileUtil.copy(from.getAbsolutePath(), to.getAbsolutePath(), executors);
                return;
            }
        }
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new FileReader(from));
            String line = in.readLine();
            out = new BufferedWriter(new FileWriter(to));
            while (line != null) {
                if (executors != null) {
                    for (FileExecutor<?> executor : executors) {
                        line = executor.replace(line, from, to);
                    }
                }
                if (line != null) {
                    out.append(line);
                    out.newLine();
                }
                line = in.readLine();
            }
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(InputStream in, File file) {
        block11: {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                out.write(IOUtil.inputToByte(in));
                out.flush();
            }
            catch (IOException e) {
                if (out == null) break block11;
                try {
                    out.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static byte[] toByteArray(File file) {
        FileInputStream fin = null;
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            fin = new FileInputStream(file);
            byte[] but = new byte[0x100000];
            int length = 0;
            while ((length = fin.read(but)) != -1) {
                out.write(but, 0, length);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                fin.close();
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String read(File file, Charset charset) {
        byte[] bytes = FileUtil.toByteArray(file);
        return new String(bytes, charset);
    }

    public static void del(String url, FileExecutor<?> ... fce) {
        File f = new File(url);
        if (!f.exists()) {
            return;
        }
        if (fce != null && fce.length > 0) {
            for (FileExecutor<?> ce : fce) {
                if (ce.doExec(f)) continue;
                return;
            }
        }
        if (f.isDirectory()) {
            for (File son : f.listFiles()) {
                FileUtil.del(son.getAbsolutePath(), fce);
            }
        }
        f.delete();
    }

    public static void change(String fileUrl, FileExecutor<?> re) {
        File param = new File(fileUrl);
        if (!param.exists()) {
            throw new RuntimeException("\u4fee\u6539\u7684\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728 [ " + fileUrl + " ]");
        }
        if (param.isDirectory()) {
            for (File sonFile : param.listFiles()) {
                if (!re.doExec(sonFile)) continue;
                FileUtil.change(sonFile.getAbsolutePath(), re);
            }
        } else {
            ArrayList<String> contends = new ArrayList<String>();
            BufferedWriter out = null;
            try {
                BufferedReader in = new BufferedReader(new FileReader(fileUrl));
                String line = in.readLine();
                while (line != null) {
                    line = re.replace(line, new File(fileUrl), new File(fileUrl));
                    contends.add(line);
                    line = in.readLine();
                }
                in.close();
                out = new BufferedWriter(new FileWriter(fileUrl));
                for (String newStr : contends) {
                    out.append(newStr);
                    out.newLine();
                }
                out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static String readFile(String fileUrl) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FileInputStream fin = null;
        String str = null;
        try {
            fin = new FileInputStream(fileUrl);
            FileUtil.copy(fin, bout);
            str = new String(bout.toByteArray(), "UTF-8");
        }
        catch (FileNotFoundException e) {
            LoggerUtil.error(FileUtil.class, "\u8981\u8bfb\u53d6\u7684\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728[ " + fileUrl + " ]");
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                bout.close();
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception e2) {
                LoggerUtil.error(FileUtil.class, "\u6587\u4ef6\u8bfb\u53d6\u6d41\u5173\u95ed\u5931\u8d25[ " + fileUrl + " ]", e2);
            }
        }
        return str;
    }

    public static void copy(InputStream in, OutputStream out) {
        try {
            byte[] bts = new byte[1024];
            int length = 0;
            while ((length = in.read(bts)) > 0) {
                out.write(bts, 0, length);
            }
            out.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static void rename(String from, String to, FileExecutor<?> ... res) {
        if (res != null && res.length > 0) {
            FileUtil.copyWithString(from, to, res);
        } else {
            FileUtil.copy(from, to, res);
        }
        FileUtil.del(from, new FileExecutor[0]);
    }

    public static abstract class FileExecutor<T> {
        T trunk = null;

        public FileExecutor(T trunk) {
            this.trunk = trunk;
        }

        public FileExecutor() {
        }

        public String replace(String source, File from, File to) {
            return source;
        }

        public boolean doExec(File f) {
            return true;
        }

        public T getTrunk() {
            return this.trunk;
        }

        public void setTrunk(T trunk) {
            this.trunk = trunk;
        }
    }
}

