/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.ObjectUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import cn.easyutil.util.javaUtil.annotation.ExcelCallBack;
import cn.easyutil.util.javaUtil.annotation.ExcelCellName;
import cn.easyutil.util.javaUtil.annotation.ExcelValParse;
import cn.easyutil.util.javaUtil.annotation.ExcelValSwitch;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private Long test;
    private int rowMax;
    private int rowMin;
    private int cellMax;
    private int cellMin;
    private Workbook workbook = new HSSFWorkbook();
    private List<ExcelBean> excelBeans = new ArrayList<ExcelBean>();

    public List<ExcelBean> getExcelBeans() {
        return this.excelBeans;
    }

    public ExcelUtil(InputStream in, boolean isNewType) {
        this.readExcel(in, isNewType);
    }

    public ExcelUtil(InputStream in) {
        this.readExcel(in, false);
    }

    public ExcelUtil() {
    }

    public void toExcel(OutputStream out) {
        try {
            this.workbook.write(out);
            this.workbook.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ExcelUtil createSheet(List<String> headers, List<List<String>> data, String sheetName) {
        Sheet sheet = this.workbook.createSheet(sheetName);
        Row createRow = sheet.createRow(0);
        ExcelUtil.writeRow(headers, createRow, new ExcelCallBack[0]);
        for (int i = 0; i < data.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            ExcelUtil.writeRow(data.get(i), row, new ExcelCallBack[0]);
        }
        return this;
    }

    public <T> ExcelUtil createSheet(List<T> list, String sheetName) {
        List<String> headers = ExcelUtil.getCellName(list.get(0));
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (T t : list) {
            data.add(ExcelUtil.getCellValue(t));
        }
        return this.createSheet(headers, data, sheetName);
    }

    public ExcelUtil loadExcel(InputStream in, boolean isNewType) {
        return this.readExcel(in, false);
    }

    public static <T> void createExcel(List<T> list, String fileName, HttpServletResponse response) {
        if (StringUtil.isEmpty(response) || StringUtil.isEmpty(fileName)) {
            throw new NullPointerException("the parameter file name or HttpServletResponse must not be null");
        }
        response.reset();
        response.setContentType("application/msexcel");
        try {
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xls");
        }
        catch (UnsupportedEncodingException e) {
            response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xls");
        }
        List<String> headers = ExcelUtil.getCellName(list.get(0));
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (T t : list) {
            data.add(ExcelUtil.getCellValue(t));
        }
        try {
            ExcelUtil.createExcel(headers, data, fileName, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void createExcel(List<String> headers, List<List<String>> data, String sheetName, OutputStream out) {
        HSSFWorkbook wb = new HSSFWorkbook();
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        int start = 0;
        while (start < data.size()) {
            List<List<String>> subData = null;
            if (data.size() - start > 60000) {
                subData = data.subList(start, start + 60000);
                start += 60000;
            } else {
                subData = data.subList(start, data.size());
                start = data.size();
            }
            Sheet sheet = wb.createSheet(sheetName + start);
            Row createRow = sheet.createRow(0);
            ExcelUtil.writeRow(headers, createRow, new ExcelCallBack[0]);
            for (int i = 0; i < subData.size(); ++i) {
                Row row = sheet.createRow(i + 1);
                ExcelUtil.writeRow(subData.get(i), row, new ExcelCallBack[0]);
            }
        }
        try {
            wb.write(out);
            wb.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void createExcel(List<T> list, String sheetName, OutputStream out) {
        List<String> headers = ExcelUtil.getCellName(list.get(0));
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (T t : list) {
            data.add(ExcelUtil.getCellValue(t));
        }
        ExcelUtil.createExcel(headers, data, sheetName, out);
    }

    public static void createExcel(LinkedHashMap<String, Object> headers, List<Map<String, Object>> data, String fileName, OutputStream out) {
        ArrayList<String> hs = new ArrayList<String>();
        ArrayList<String> hvs = new ArrayList<String>();
        ArrayList<List<String>> ds = new ArrayList<List<String>>();
        Set<Map.Entry<String, Object>> set = headers.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            hvs.add(entry.getKey());
            hs.add(entry.getValue().toString());
        }
        for (Map<String, Object> map : data) {
            ArrayList<String> oneData = new ArrayList<String>();
            for (String v : hvs) {
                if (map.containsKey(v)) {
                    oneData.add(map.get(v).toString());
                    continue;
                }
                oneData.add("");
            }
            ds.add(oneData);
        }
        ExcelUtil.createExcel(hs, ds, fileName, out);
    }

    private static <T> void writeRow(List<T> data, Row row, ExcelCallBack ... callBack) {
        if (callBack != null && callBack.length > 0) {
            callBack[0].write(data, row);
            return;
        }
        ExcelUtil.createHeader(row, data);
    }

    private static <T> void createHeader(Row createRow, List<T> list) {
        if (StringUtil.isEmpty(list)) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Cell cell = createRow.createCell(i);
            cell.setCellValue(list.get(i).toString());
        }
    }

    private static <T> List<String> getCellName(T obj) {
        ArrayList<String> result = new ArrayList<String>();
        Class<?> objClass = obj.getClass();
        while (!objClass.equals(Object.class)) {
            Field[] fields;
            for (Field f : fields = objClass.getDeclaredFields()) {
                Annotation[] ans;
                for (Annotation a : ans = f.getDeclaredAnnotations()) {
                    ExcelCellName name;
                    if (!(a instanceof ExcelCellName) || (name = (ExcelCellName)a).value() == null) continue;
                    if (name.value().equals("")) {
                        result.add("unkown");
                        continue;
                    }
                    result.add(name.value());
                }
            }
            objClass = objClass.getSuperclass();
        }
        return result;
    }

    private static <T> List<String> getCellValue(T obj) {
        ArrayList<String> result = new ArrayList<String>();
        Class<?> objClass = obj.getClass();
        while (!objClass.equals(Object.class)) {
            Field[] fields;
            for (Field f : fields = objClass.getDeclaredFields()) {
                ExcelCellName a = f.getDeclaredAnnotation(ExcelCellName.class);
                if (a == null) continue;
                String value = "";
                try {
                    Object ant = ObjectUtil.getAttributeValue(obj, f.getName());
                    value = ant.toString();
                    if (!StringUtil.isEmpty(a.dateFormart())) {
                        Comparable<java.util.Date> date;
                        String dateFormart = a.dateFormart();
                        SimpleDateFormat format = new SimpleDateFormat(dateFormart);
                        if (ant instanceof java.util.Date) {
                            date = (java.util.Date)ant;
                            value = format.format((java.util.Date)date);
                        } else if (ant instanceof Long) {
                            date = (Long)ant;
                            value = format.format(date);
                        } else if (ant instanceof Date) {
                            date = (Date)ant;
                            value = format.format((java.util.Date)date);
                        }
                        result.add(value);
                        continue;
                    }
                    ExcelValParse parse = a.Parse();
                    ExcelValSwitch aSwitch = a.Switch();
                    if (parse.parseValueClass() != Object.class && !StringUtil.isEmpty(parse.parseValueMethod())) {
                        Class enumClass = parse.parseValueClass();
                        String enumMothed = parse.parseValueMethod();
                        Method method = null;
                        try {
                            method = enumClass.getDeclaredMethod(enumMothed, f.getType());
                        }
                        catch (Exception exception) {
                            method = enumClass.getDeclaredMethod(enumMothed, ExcelUtil.getReversBaseClass(f.getType()));
                        }
                        Object t = enumClass.newInstance();
                        method.setAccessible(true);
                        value = method.invoke(t, ant).toString();
                        method.setAccessible(false);
                        result.add(value);
                        continue;
                    }
                    if (aSwitch.switchValues().length > 0) {
                        String string;
                        String[] vs;
                        String split = aSwitch.switchSplitBy();
                        if (StringUtil.isEmpty(split)) {
                            split = "=";
                        }
                        HashMap<String, String> values = new HashMap<String, String>();
                        for (String v2 : vs = aSwitch.switchValues()) {
                            String[] sp;
                            if (StringUtil.isEmpty(v2) || (sp = v2.split(split)) == null || sp.length < 1) continue;
                            values.put(sp[0], sp[1]);
                        }
                        if (!values.isEmpty() && !StringUtil.isEmpty(string = (String)values.get(value))) {
                            result.add(string);
                            continue;
                        }
                    }
                    result.add(value);
                }
                catch (Exception e) {
                    result.add(value);
                }
            }
            objClass = objClass.getSuperclass();
        }
        return result;
    }

    private static Class getReversBaseClass(Class value) {
        if (value == null) {
            return null;
        }
        if (value.equals(Long.class)) {
            return Long.TYPE;
        }
        if (value.equals(Long.TYPE)) {
            return Long.class;
        }
        if (value.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (value.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (value.equals(Double.class)) {
            return Double.TYPE;
        }
        if (value.equals(Double.TYPE)) {
            return Double.class;
        }
        if (value.equals(Float.class)) {
            return Float.TYPE;
        }
        if (value.equals(Float.TYPE)) {
            return Float.class;
        }
        if (value.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (value.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (value.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (value.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (value.equals(Short.class)) {
            return Short.TYPE;
        }
        if (value.equals(Short.TYPE)) {
            return Short.class;
        }
        if (value.equals(Character.class)) {
            return Character.TYPE;
        }
        if (value.equals(Character.TYPE)) {
            return Character.class;
        }
        return value;
    }

    public ExcelUtil readExcel(InputStream in, boolean isNewType) {
        Object wb = null;
        if (in == null) {
            return null;
        }
        try {
            wb = !isNewType ? new HSSFWorkbook(in) : new XSSFWorkbook(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Sheet sheet = wb.getSheetAt(0);
        int rowSize = sheet.getPhysicalNumberOfRows();
        for (int i = 0; i < rowSize; ++i) {
            Row row = sheet.getRow(i);
            int cellSize = row.getPhysicalNumberOfCells();
            for (int j = 0; j < cellSize; ++j) {
                ExcelBean bean = new ExcelBean();
                Cell cell = row.getCell(j);
                String obj = this.getCellData(cell);
                if (StringUtil.isEmpty(obj)) continue;
                bean.setRowNo(i);
                bean.setCellNo(j);
                bean.setData(obj);
                this.excelBeans.add(bean);
            }
        }
        try {
            wb.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (ExcelBean ex : this.excelBeans) {
            if (ex.getRowNo() > this.rowMax) {
                this.rowMax = ex.getRowNo();
            }
            if (ex.getRowNo() < this.rowMin) {
                this.rowMin = ex.getRowNo();
            }
            if (ex.getCellNo() > this.cellMax) {
                this.cellMax = ex.getCellNo();
            }
            if (ex.getCellNo() >= this.cellMin) continue;
            this.cellMin = ex.getCellNo();
        }
        return this;
    }

    private String getCellData(Cell cell) {
        if (cell == null) {
            return null;
        }
        cell.setCellType(CellType.STRING);
        return cell.getStringCellValue();
    }

    public <T> List<T> toList(Class<T> clazz) {
        return this.toList(clazz, 0, this.rowMax);
    }

    public <T> List<T> toList(Class<T> clazz, int startRow, int endRow) {
        if (StringUtil.isEmpty(this.excelBeans)) {
            return null;
        }
        Map<String, ExcelCellName> map = ObjectUtil.getFieldAnnotation(clazz, ExcelCellName.class);
        if (StringUtil.isEmpty(map)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        String[] fields = new String[map.size()];
        ExcelBean[] anValues = new ExcelBean[map.size()];
        int i = 0;
        for (String s : map.keySet()) {
            ExcelCellName an = map.get(s);
            String value = an.value();
            fields[i] = s;
            anValues[i] = this.get(value);
            ++i;
        }
        for (int j = startRow; j < endRow; ++j) {
            Object t = null;
            try {
                t = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (int j2 = 0; j2 < anValues.length; ++j2) {
                ExcelBean b;
                Integer cellNo = anValues[j2].getCellNo();
                if (cellNo == null || (b = this.match(j + 1, cellNo, 2)) == null) continue;
                try {
                    ObjectUtil.setAttribute(t, fields[j2], b.getData());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            result.add(t);
        }
        return result;
    }

    public <T> T toBean(Class<T> clazz) {
        if (StringUtil.isEmpty(this.excelBeans)) {
            return null;
        }
        Map<String, ExcelCellName> map = ObjectUtil.getFieldAnnotation(clazz, ExcelCellName.class);
        if (StringUtil.isEmpty(map)) {
            return null;
        }
        T t = null;
        try {
            t = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String s : map.keySet()) {
            ExcelBean bean;
            ExcelCellName an = map.get(s);
            String value = an.value();
            if (value.equals("") || StringUtil.isEmpty(bean = this.get(value))) continue;
            Integer rowNo = bean.getRowNo();
            Integer cellNo = bean.getCellNo();
            int location = an.location();
            ExcelBean match = this.match(rowNo, cellNo, location);
            if (StringUtil.isEmpty(match)) continue;
            try {
                Field field = clazz.getDeclaredField(s);
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type.equals(Integer.class)) {
                    field.set(t, new BigDecimal(match.getData()).intValue());
                } else if (type.equals(Long.class)) {
                    field.set(t, new BigDecimal(match.getData()).longValue());
                } else if (type.equals(String.class)) {
                    field.set(t, match.getData());
                } else if (type.equals(Double.class)) {
                    field.set(t, new BigDecimal(match.getData()).doubleValue());
                } else if (type.equals(Boolean.class)) {
                    field.set(t, Boolean.valueOf(match.getData()));
                } else {
                    field.set(t, match.getData());
                }
                field.setAccessible(false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return t;
    }

    private ExcelBean match(int row, int cell, int location) {
        switch (location) {
            case 1: {
                int i = 0;
                while (row - i >= this.cellMin) {
                    ExcelBean bean = this.get(row - i, cell);
                    if (!StringUtil.isEmpty(bean)) {
                        return bean;
                    }
                    ++i;
                }
                return null;
            }
            case 2: {
                int i = 0;
                while (row + i <= this.rowMax) {
                    ExcelBean bean = this.get(row + i, cell);
                    if (!StringUtil.isEmpty(bean)) {
                        return bean;
                    }
                    ++i;
                }
                return null;
            }
            case 3: {
                int i = 0;
                while (cell - i >= this.cellMin) {
                    ExcelBean bean = this.get(row, cell - i);
                    if (!StringUtil.isEmpty(bean)) {
                        return bean;
                    }
                    ++i;
                }
                return null;
            }
            case 4: {
                int i = 0;
                while (cell + i <= this.cellMax) {
                    ExcelBean bean = this.get(row, cell + i);
                    if (!StringUtil.isEmpty(bean)) {
                        return bean;
                    }
                    ++i;
                }
                break;
            }
        }
        return null;
    }

    public <T> List<T> excelToList(Class<T> clazz) {
        return null;
    }

    public ExcelBean get(String data) {
        if (StringUtil.isEmpty(this.excelBeans)) {
            return null;
        }
        for (ExcelBean excelBean : this.excelBeans) {
            if (!excelBean.getData().equals(data)) continue;
            return excelBean;
        }
        return null;
    }

    public ExcelBean get(int row, int cell) {
        if (StringUtil.isEmpty(this.excelBeans)) {
            return null;
        }
        for (ExcelBean excelBean : this.excelBeans) {
            if (!excelBean.getRowNo().equals(row) || !excelBean.getCellNo().equals(cell)) continue;
            return excelBean;
        }
        return null;
    }

    public static class ExcelBean {
        private Integer rowNo;
        private Integer cellNo;
        private String data;

        public Integer getRowNo() {
            return this.rowNo;
        }

        public void setRowNo(Integer rowNo) {
            this.rowNo = rowNo;
        }

        public Integer getCellNo() {
            return this.cellNo;
        }

        public void setCellNo(Integer cellNo) {
            this.cellNo = cellNo;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

