/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtil {
    public static final long oneMinuteTime = 60000L;
    public static final long oneHourTime = 3600000L;
    public static final long oneDayTime = 86400000L;
    public static final long oneWeekTime = 604800000L;
    public static final SimpleDateFormat DATE_FORMAT_0 = new SimpleDateFormat("yy/MM/dd");
    public static final SimpleDateFormat DATE_FORMAT_1 = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_FORMAT_2 = new SimpleDateFormat("yyyyMM");
    public static final SimpleDateFormat DATE_FORMAT_3 = new SimpleDateFormat("yyyyMMddHHmmss");
    public static final SimpleDateFormat DATE_FORMAT_4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT_5 = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    public static final SimpleDateFormat DATE_FORMAT_6 = new SimpleDateFormat("yyyy-MM-dd_HH");
    public static final SimpleDateFormat DATE_FORMAT_7 = new SimpleDateFormat("yyyyMMdd");
    private static final String[] constellationArr = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
    private static final int[] dayArr = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};

    public static String getConstellation(long timeStamp) {
        int day = 0;
        int month = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM:dd");
        String format = simpleDateFormat.format(timeStamp);
        String[] strings = format.split(":");
        month = Integer.parseInt(strings[0]);
        day = Integer.parseInt(strings[1]);
        return day < dayArr[month - 1] ? constellationArr[month - 1] : constellationArr[month];
    }

    public static String getConstellation() {
        return DateUtil.getConstellation(System.currentTimeMillis());
    }

    public static long sumDay(long nowTime, int day) {
        return nowTime + 86400000L * (long)day;
    }

    public static long sumMonth(long time, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(time));
        calendar.set(2, calendar.get(2) + month);
        Date date = calendar.getTime();
        return date.getTime();
    }

    public static long sumWeek(long time, int week) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(time));
        calendar.set(3, calendar.get(3) + week);
        Date date = calendar.getTime();
        return date.getTime();
    }

    public static long sumYear(long time, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(time));
        calendar.set(1, calendar.get(1) + year);
        Date date = calendar.getTime();
        return date.getTime();
    }

    public static int getYear() {
        return DateUtil.getYear(System.currentTimeMillis());
    }

    public static int getYear(long time) {
        String[] strs = DateUtil.format(DATE_FORMAT_1, time).split("-");
        return LocalDate.of((int)Integer.valueOf(strs[0]), Integer.valueOf(strs[1]), (int)Integer.valueOf(strs[2])).getYear();
    }

    public static int getWeek() {
        return DateUtil.getWeek(System.currentTimeMillis());
    }

    public static int getWeek(long time) {
        String[] strs = DateUtil.format(DATE_FORMAT_1, time).split("-");
        return LocalDate.of((int)Integer.valueOf(strs[0]), Integer.valueOf(strs[1]), (int)Integer.valueOf(strs[2])).getDayOfWeek().getValue();
    }

    public static int getMonth(long time) {
        String[] strs = DateUtil.format(DATE_FORMAT_1, time).split("-");
        return LocalDate.of((int)Integer.valueOf(strs[0]), Integer.valueOf(strs[1]), (int)Integer.valueOf(strs[2])).getMonthValue();
    }

    public static int getMonth() {
        return DateUtil.getMonth(System.currentTimeMillis());
    }

    public static int getDayOfMonth(long time) {
        String[] strs = DateUtil.format(DATE_FORMAT_1, time).split("-");
        return LocalDate.of((int)Integer.valueOf(strs[0]), Integer.valueOf(strs[1]), (int)Integer.valueOf(strs[2])).getDayOfMonth();
    }

    public static int getDayOfMonth() {
        return DateUtil.getDayOfMonth(System.currentTimeMillis());
    }

    public static boolean isSameDay(long time1, long time2) {
        return DateUtil.getZero(time1) == DateUtil.getZero(time2);
    }

    public static boolean isSameMonth(long time1, long time2) {
        String[] strs2;
        String[] strs1 = DateUtil.format(DATE_FORMAT_1, time1).split("-");
        if (!strs1[0].equals((strs2 = DateUtil.format(DATE_FORMAT_1, time2).split("-"))[0])) {
            return false;
        }
        return strs1[1].equals(strs2[1]);
    }

    public static boolean isSameYear(long time1, long time2) {
        String[] strs1 = DateUtil.format(DATE_FORMAT_1, time1).split("-");
        String[] strs2 = DateUtil.format(DATE_FORMAT_1, time2).split("-");
        return strs1[0].equals(strs2[0]);
    }

    public static long getZero() {
        return DateUtil.getZero(System.currentTimeMillis());
    }

    public static long getZero(long time) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(time));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTimeInMillis();
    }

    public static long getDayStartTime(long time) {
        return (Long)DateUtil.getTodayStartAndEnd(time).get("start_time");
    }

    public static long getDayEndTime(long time) {
        return (Long)DateUtil.getTodayStartAndEnd(time).get("end_time");
    }

    public static long getWeekStartTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateUtil.getDayStartTime(cal.getTimeInMillis());
    }

    public static long getWeekEndTime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(DateUtil.getWeekStartTime(time)));
        cal.add(7, 6);
        return DateUtil.getDayEndTime(cal.getTimeInMillis());
    }

    public static long getYearStartTime(long time) {
        String[] strs = DateUtil.format(DATE_FORMAT_1, time).split("-");
        int start = Integer.valueOf(strs[0]) + 1;
        String formart = start + "-01-01 00:00:00";
        return DateUtil.parse(formart);
    }

    public static long getYearEndTime(long time) {
        String[] strs = DateUtil.format(DATE_FORMAT_1, time).split("-");
        int start = Integer.valueOf(strs[0]) + 1;
        String formart = start + "-12-31 23:59:59";
        return DateUtil.parse(formart);
    }

    public static long getMonthStartTime(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getYear(time), DateUtil.getMonth(time) - 1, 1);
        return DateUtil.getDayStartTime(calendar.getTimeInMillis());
    }

    public static long getMonthEndTime(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getYear(time), DateUtil.getMonth(time) - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtil.getYear(time), DateUtil.getMonth(time) - 1, day);
        return DateUtil.getDayEndTime(calendar.getTimeInMillis());
    }

    private static Map<String, Object> getTodayStartAndEnd(Long time) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (time != null) {
            Date date = new Date(time);
            Calendar now = Calendar.getInstance();
            now.setTime(date);
            Calendar strat = now;
            strat.set(11, 0);
            strat.set(12, 0);
            strat.set(13, 0);
            strat.set(14, 0);
            Long start_time = strat.getTimeInMillis();
            Calendar end = now;
            end.add(5, 1);
            end.set(11, 0);
            end.set(12, 0);
            end.set(13, 0);
            end.set(14, 0);
            Long end_time = end.getTimeInMillis();
            map.put("start_time", start_time);
            map.put("end_time", end_time - 1L);
            return map;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar strat = Calendar.getInstance();
        strat.set(11, 0);
        strat.set(12, 0);
        strat.set(13, 0);
        strat.set(14, 0);
        Long start_time = strat.getTimeInMillis();
        Calendar end = Calendar.getInstance();
        end.add(5, 1);
        end.set(11, 0);
        end.set(12, 0);
        end.set(13, 0);
        end.set(14, 0);
        Long end_time = end.getTimeInMillis();
        map.put("start_time", start_time);
        map.put("end_time", end_time);
        return map;
    }

    public static long parse(String time) {
        try {
            return DateUtil.parse(DATE_FORMAT_4, time);
        }
        catch (Exception e) {
            return DateUtil.parse(DATE_FORMAT_1, time);
        }
    }

    public static long parse(SimpleDateFormat f, String time) {
        try {
            return f.parse(time).getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static long sumHour(long time, int hour) {
        return time + (long)(3600000 * hour);
    }

    public static long sumHour(int hour) {
        return DateUtil.sumHour(System.currentTimeMillis(), hour);
    }

    public static int differHour(long time1, long time2) {
        long time = (time1 - time2) / 3600000L;
        return Integer.valueOf((time + "").replace("-", ""));
    }

    public static int differHour(String time1, String time2) {
        return DateUtil.differHour(time1, DATE_FORMAT_4, time2, DATE_FORMAT_4);
    }

    public static int differHour(String time1, SimpleDateFormat format1, String time2, SimpleDateFormat format2) {
        long parseTime1 = DateUtil.parse(format1, time1);
        long parseTime2 = DateUtil.parse(format2, time2);
        return DateUtil.differHour(parseTime1, parseTime2);
    }

    public static int differDay(long time1, long time2) {
        long time = (time1 - time2) / 86400000L;
        return Integer.valueOf((time + "").replace("-", ""));
    }

    public static int differDay(String time1, String time2) {
        return DateUtil.differDay(time1, DATE_FORMAT_4, time2, DATE_FORMAT_4);
    }

    public static int differDay(String time1, SimpleDateFormat format1, String time2, SimpleDateFormat format2) {
        long parseTime1 = DateUtil.parse(format1, time1);
        long parseTime2 = DateUtil.parse(format2, time2);
        return DateUtil.differDay(parseTime1, parseTime2);
    }

    public static int differWeek(long time1, long time2) {
        long time = (time1 - time2) / 604800000L;
        return Integer.valueOf((time + "").replace("-", ""));
    }

    public static int differWeek(String time1, String time2) {
        return DateUtil.differWeek(time1, DATE_FORMAT_4, time2, DATE_FORMAT_4);
    }

    public static int differWeek(String time1, SimpleDateFormat format1, String time2, SimpleDateFormat format2) {
        long parseTime1 = DateUtil.parse(format1, time1);
        long parseTime2 = DateUtil.parse(format2, time2);
        return DateUtil.differWeek(parseTime1, parseTime2);
    }

    public static String format(SimpleDateFormat format, long time) {
        return format.format(time);
    }

    public static String format(long time) {
        return DATE_FORMAT_4.format(time);
    }
}

