/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import cn.easyutil.util.javaUtil.JsonUtil;
import cn.easyutil.util.javaUtil.LoggerUtil;
import cn.easyutil.util.javaUtil.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CommandUtil {
    private String ip;
    private String username;
    private String password;
    private String charset;

    public String getIp() {
        if (StringUtil.isEmpty(this.ip)) {
            throw new NullPointerException("remote connection ip must be not null,please set field of [ip]");
        }
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUsername() {
        if (StringUtil.isEmpty(this.username)) {
            throw new NullPointerException("remote connection username must be not null,please set field of [username]");
        }
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        if (StringUtil.isEmpty(this.password)) {
            throw new NullPointerException("remote connection password must be not null,please set field of [password]");
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCharset() {
        if (this.charset == null) {
            this.charset = "UTF-8";
        }
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public CommandUtil() {
    }

    public CommandUtil(String ip, String username, String password) {
        this.ip = ip;
        this.username = username;
        this.password = password;
    }

    public static List<String> execute(String command) {
        String charset = "GBK";
        String osName = System.getProperty("os.name");
        if (osName.trim().toUpperCase().contains("WINDOWS") && !command.startsWith("cmd /c")) {
            command = "cmd /c " + command;
        }
        if (osName.trim().toUpperCase().contains("LINUX")) {
            charset = "UTF-8";
        }
        return CommandUtil.execute(command, charset);
    }

    public static List<String> execute(String command, String charset) {
        InputStream in = null;
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            in = process.getInputStream();
            ArrayList<String> buff = new ArrayList<String>();
            byte[] but = new byte[10240000];
            int length = 0;
            while ((length = in.read(but)) != -1) {
                if (charset == null) {
                    charset = "utf-8";
                }
                String str = new String(but, 0, length, charset);
                buff.add(str);
            }
            LoggerUtil.debug(CommandUtil.class, "excuting command [" + command + "] succcess");
            ArrayList<String> arrayList = buff;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<String> execute(String ip, String username, String password, String ... command) {
        return CommandUtil.execute(new CommandUtil(ip, username, password), command);
    }

    public static List<String> execute(CommandUtil easyCommandUtil, String ... command) {
        try (Connection conn = null;){
            conn = new Connection(easyCommandUtil.getIp());
            conn.connect();
            boolean isAuthenticated = conn.authenticateWithPassword(easyCommandUtil.getUsername(), easyCommandUtil.getPassword());
            if (!isAuthenticated) {
                LoggerUtil.debug(CommandUtil.class, "the server [" + easyCommandUtil.getIp() + "] connect exception");
                throw new IOException("the server [" + easyCommandUtil.getIp() + "] connect exception");
            }
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < command.length; ++i) {
                List<String> re = CommandUtil.exString(conn, command[i], easyCommandUtil.getCharset());
                result.add(JsonUtil.beanToJson(re));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    private static List<String> exString(Connection conn, String command, String charset) {
        ArrayList<String> list = new ArrayList<String>();
        Session sess = null;
        BufferedReader br = null;
        InputStream stdout = null;
        try {
            Object line;
            sess = conn.openSession();
            sess.execCommand(command);
            stdout = new StreamGobbler(sess.getStdout());
            br = new BufferedReader(new InputStreamReader(stdout));
            while ((line = br.readLine()) != null) {
                list.add(new String(((String)line).getBytes(), charset));
            }
            LoggerUtil.debug(CommandUtil.class, "excuting command [" + command + "] success");
            line = list;
            return line;
        }
        catch (Exception e) {
            LoggerUtil.debug(CommandUtil.class, "excuting command [" + command + "] failed");
            LoggerUtil.error(CommandUtil.class, e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                br.close();
                stdout.close();
                sess.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) {
        List<String> execute = CommandUtil.execute("cmd /c dir D://");
        System.out.println(JsonUtil.beanToJson(execute));
    }
}

