/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.util.javaUtil;

import cn.easyutil.util.javaUtil.StringUtil;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;

public class CertCoder {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "RSA".equals("DSA") ? "SHA1withDSA" : "SHA1withRSA";
    private static final int SIZE = 1024;

    public static String signByPrivateKey(byte[] data, String privateKey) throws Exception {
        byte[] keyBytes = StringUtil.base64ToByte(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(priKey);
        signature.update(data);
        return StringUtil.base64Encode(signature.sign());
    }

    public static boolean verify(String oldValue, String passValue, String publicKey) throws Exception {
        byte[] data = oldValue.getBytes();
        byte[] keyBytes = StringUtil.base64ToByte(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(pubKey);
        signature.update(data);
        return signature.verify(StringUtil.base64ToByte(oldValue));
    }

    public static String doCoderByPrivateKey(String data, String key, boolean type) throws Exception {
        int typeValue = type ? 1 : 2;
        byte[] valueBts = type ? data.getBytes() : StringUtil.base64ToByte(data);
        byte[] keyBytes = StringUtil.base64ToByte(key);
        int maxDataSize = type ? 64 : 128;
        byte[] bts = new byte[]{};
        int index = 0;
        do {
            index += maxDataSize;
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(typeValue, privateKey);
            byte[] tempBts = cipher.doFinal(Arrays.copyOfRange(valueBts, index - maxDataSize, index < valueBts.length ? index : valueBts.length));
            byte[] result = Arrays.copyOf(bts, bts.length + tempBts.length);
            System.arraycopy(tempBts, 0, result, bts.length, tempBts.length);
            bts = result;
        } while (index < valueBts.length);
        return type ? StringUtil.base64Encode(bts) : new String(bts, "UTF-8");
    }

    public static Key loadKeyForPKCS8(KeyFactory keyFactory, byte[] keyBytes, boolean isPrivate) throws InvalidKeySpecException {
        if (isPrivate) {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
            return keyFactory.generatePrivate(pkcs8KeySpec);
        }
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        return keyFactory.generatePublic(x509KeySpec);
    }

    public static Key loadKeyForPKCS1(KeyFactory keyFactory, byte[] keyBuffer, boolean isPrivate) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBuffer);
        return isPrivate ? keyFactory.generatePrivate(keySpec) : keyFactory.generatePublic(keySpec);
    }

    public static String doCoderByPublicKey(String data, String key, boolean type) throws Exception {
        int typeValue = type ? 1 : 2;
        byte[] valueBts = type ? data.getBytes() : StringUtil.base64ToByte(data);
        byte[] keyBytes = StringUtil.base64ToByte(key);
        int maxDataSize = type ? 64 : 128;
        byte[] bts = new byte[]{};
        int index = 0;
        do {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            Key publicKey = CertCoder.loadKeyForPKCS8(keyFactory, keyBytes, false);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(typeValue, publicKey);
            byte[] tempBts = cipher.doFinal(Arrays.copyOfRange(valueBts, index - maxDataSize, (index += maxDataSize) < valueBts.length ? index : valueBts.length));
            byte[] result = Arrays.copyOf(bts, bts.length + tempBts.length);
            System.arraycopy(tempBts, 0, result, bts.length, tempBts.length);
            bts = result;
        } while (index < valueBts.length);
        return type ? StringUtil.base64Encode(bts) : new String(bts, "UTF-8");
    }

    public static PassBean initKey() throws Exception {
        return CertCoder.initKey(null);
    }

    public static PassBean initKey(Integer size) throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(size == null ? 1024 : size, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        PassBean pb = new PassBean();
        if (KEY_ALGORITHM.equals("DSA")) {
            DSAPublicKey publicKey = (DSAPublicKey)keyPair.getPublic();
            DSAPrivateKey privateKey = (DSAPrivateKey)keyPair.getPrivate();
            pb.setPrivateKey(StringUtil.base64Encode(privateKey.getEncoded()));
            pb.setPublicKey(StringUtil.base64Encode(publicKey.getEncoded()));
        } else if (KEY_ALGORITHM.equals(KEY_ALGORITHM)) {
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            pb.setPrivateKey(StringUtil.base64Encode(privateKey.getEncoded()));
            pb.setPublicKey(StringUtil.base64Encode(publicKey.getEncoded()));
        }
        return pb;
    }

    public static void main(String[] args) throws Exception {
        String privateKey = "MIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDOv0Fum4ijUnc2iKiDbBsZcPflpJfMdAjPI9H0juBbkPHEUXZYUUdRq19kis3IIbe4JDiE0Dod6glaGH1hy67G6MWsOBfTHmFPjmwYDlyf/GH/CZr8+Z8bnozQzmlmPngJhhm2cwyJGOjysmv7Ho0SuDZJv64cuBS5dpbdxtQWSq1aiHzqjEcxo5PhzkgPiAeIOa0ab3VpQQRyj5X4Qh31L8erYoOph/3xX2SvhA9xFh2wgvYnHWbsn7bJMoostxE2acwR0egEOPKgYP/Ruqgq6zS+yPf38ePJo/5mWh0PBa4sMVpJ7H8kJWpSQlhTGsiEDnkzVkUMAbm4p2P6oRLVAgMBAAECggEBAIxcQgLiqwAeg3rNioI2yasbC+GnPbt7Z2OhsO+0dFMV811R5OOOwrmKfCfZKF3frkfgp1Jbv6kBc7nr+GuFibHW5CTIrDwTWwNU8MPgNDgVcz5feg6XNdLdcEJucBYPARWOKjS4pOEKvVPPmAmTszjrQUgOTxmGS+OhxEjqrKA4d9HbJdPnGRT7jKmSPFUxhrqxmfnagE8eltCV1gbqziJjrxXCfyALDaFMTbVyUs3InYJXHPrKTJwOPP9A9bK+qcAJSvbmJlllk+HM6CKOIWHT7KJLNlSIlOsUPOcg78QKfez8NcPdrosA5pWrjuELwBRtx4/TunAo5bBeOsRiDt0CgYEA89viiwi6pc9qbdv9QNCh9TMpHssuGbzwbbAg9GkrVzyotCTdrCtZVjHHCPnaw9V6CtS/qF2XUsdO30S+r+nLsTLW2b8MND/9cLxAFsYMIevXGMs7Oc/27RSwjnZCqt1KEaUK6mTt7X7YDjXGJP2u8XEhT9AMsIV4HXC+QjLb25MCgYEA2QpcLx5cIM4SrmWExOWrwhb3+9K7DdDnO6d45d/MGrB8KKOYR0pLUnh5T6gyiwHlk1+oT7Qomf+FQIxx2EW2smueQKupJp54o5Ur6uVKmxM406So3jM3xC94OLkdoz6r5fLFyClrtuuKfVjhjgansIXkZhj4hTQ8BzwzzBBR6PcCgYBAJxOVEgnQPx23ow0f9QL2d6wUrs0E9mCl6pTw144QWCPlqGEsvwa0l0nOQbTcmheOK+PzzhNWMpq8P+COdMoiZsaA6DK0uDTbaJrPovBkKCAhJK4DCoPiYPQFtnTZcHfg5nNVsJGrThhWvKzQ5HAWknV6Arij46jyzcsvrSOLwwKBgE2ZrqwKJtZz16oTEg10MJ0MqU2YYtjlwEdL8aX/BnLkdv/wvhl/Lr8l4/nfIXMiEntG0F7vAzVMbtBNZsb05gWVBNgKiEgOkQOr6i/qG2qmzMKfNOF9Xor+jfV5+mbLmZp12tFePe0A+lsm1D57kqlCtg7rDrBRpMTReZOUojSxAoGAQZ2yK367PGxMs170dI2ooAvjOmc8bVN8gf1v4h9foZcGkEPZr1pJ161JCSZkl7HYZPRmQmqBfm63ewj35tYUqJ1x71ixjxiSnfbOFHrt2zfk/bzeWZpAerLcDtYHNQnl6hzv435YEOOd9BmYZLTSgOHgszxxJNeJJPMpug0tBpc=";
        String publicKey = "MIIEcDCCA9mgAwIBAgIEAqlroTANBgkqhkiG9w0BAQUFADCBijELMAkGA1UEBhMCQ04xEjAQBgNVBAgTCUd1YW5nZG9uZzERMA8GA1UEBxMIU2hlbnpoZW4xEDAOBgNVBAoTB1RlbmNlbnQxDDAKBgNVBAsTA1dYRzETMBEGA1UEAxMKTW1wYXltY2hDQTEfMB0GCSqGSIb3DQEJARYQbW1wYXltY2hAdGVuY2VudDAeFw0xODEyMjkwOTA2MTZaFw0yODEyMjYwOTA2MTZaMIGfMQswCQYDVQQGEwJDTjESMBAGA1UECBMJR3Vhbmdkb25nMREwDwYDVQQHEwhTaGVuemhlbjEQMA4GA1UEChMHVGVuY2VudDEOMAwGA1UECxMFTU1QYXkxMzAxBgNVBAMUKuWNl+S6rOS6jOS4g+WFq+aIv+WcsOS6p+e7j+e6quaciemZkOWFrOWPuDESMBAGA1UEBBMJMTAzNDY3MjY5MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzr9BbpuIo1J3Noiog2wbGXD35aSXzHQIzyPR9I7gW5DxxFF2WFFHUatfZIrNyCG3uCQ4hNA6HeoJWhh9YcuuxujFrDgX0x5hT45sGA5cn/xh/wma/PmfG56M0M5pZj54CYYZtnMMiRjo8rJr+x6NErg2Sb+uHLgUuXaW3cbUFkqtWoh86oxHMaOT4c5ID4gHiDmtGm91aUEEco+V+EId9S/Hq2KDqYf98V9kr4QPcRYdsIL2Jx1m7J+2yTKKLLcRNmnMEdHoBDjyoGD/0bqoKus0vsj39/HjyaP+ZlodDwWuLDFaSex/JCVqUkJYUxrIhA55M1ZFDAG5uKdj+qES1QIDAQABo4IBRjCCAUIwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdIkNFUy1DQSBHZW5lcmF0ZSBDZXJ0aWZpY2F0ZSIwHQYDVR0OBBYEFD+feohG/IUfbFOmQfm09p/+t2UFMIG/BgNVHSMEgbcwgbSAFD4FJvYiYrQVW4jNZH6w1GKn5YZ0oYGQpIGNMIGKMQswCQYDVQQGEwJDTjESMBAGA1UECBMJR3Vhbmdkb25nMREwDwYDVQQHEwhTaGVuemhlbjEQMA4GA1UEChMHVGVuY2VudDEMMAoGA1UECxMDV1hHMRMwEQYDVQQDEwpNbXBheW1jaENBMR8wHQYJKoZIhvcNAQkBFhBtbXBheW1jaEB0ZW5jZW50ggkAu1SXK7wA6FcwDgYDVR0PAQH/BAQDAgbAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMCMA0GCSqGSIb3DQEBBQUAA4GBAA47N9VH0LpraRmBHTWorw6sOQF8SQonP5kGLOpwN8cxrL32fnrxiT0Vg8L5orvzbSWn2UC2QRHgWexFuDNkFZ4W3vTMaRNJjfgX0ES57ZVF2Ln05JqYtCfrdlD4+jJFLa4ILHa1KuYDiXZ8HbnnCWjS9cnpRtFioAacKbiCkCeo";
        String sss = "\u8428asdf\u5b89\u6170\u5fb7";
        String result = CertCoder.doCoderByPrivateKey(sss, privateKey, true);
        System.out.println(result);
        result = CertCoder.doCoderByPublicKey(result, publicKey, false);
        System.out.println(result);
    }

    public static class PassBean {
        private String publicKey;
        private String privateKey;

        public String getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }
    }
}

