/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Properties;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.LogicalConnectionImpl;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={OracleConnection.class})
@ProxyLocale
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableConnection
extends TxnReplayableBase
implements JDBCReplayable,
ReplayableConnection {
    private static final Method CREATEARRAY_METHOD = TxnReplayableConnection.getCreateARRAYMethod();
    private static final Method CREATEARRAYOF_METHOD = TxnReplayableConnection.getCreateArrayOfMethod();
    private static final Method CREATESTRUCT_METHOD = TxnReplayableConnection.getCreateStructMethod();
    String originalUser = "";
    String originalPasswd = "";
    private Object logicalProxy = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;

    protected TxnReplayableConnection() {
        this.thisProxyNameInLog = "CONN" + this.thisProxyNameInLog;
    }

    private static final Method getCreateARRAYMethod() {
        try {
            return OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateArrayOfMethod() {
        try {
            return Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateStructMethod() {
        try {
            return Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class}), @Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class})})
    protected void preForStatementCreation(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={})})
    protected void preForAbort(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="close", args={})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = stackTraceElementArray != null && stackTraceElementArray.length > 4 ? stackTraceElementArray[4].getClassName() : "";
        this.isClosedAndNoReplay = !string.startsWith("oracle.ucp");
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="openProxySession", args={int.class, Properties.class})})
    protected void preForOpenProxySession(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="createARRAY", args={String.class, Object.class}), @Signature(name="createBlob", args={byte[].class}), @Signature(name="createBlobWithUnpickledBytes", args={byte[].class}), @Signature(name="createBfile", args={byte[].class}), @Signature(name="createClob", args={byte[].class}), @Signature(name="createClob", args={byte[].class, short.class}), @Signature(name="createClobWithUnpickledBytes", args={byte[].class})})
    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={})})
    protected void postForAbort(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        this.failoverMngr.setReplayInitiationTimeout(n2);
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource, String string, String string2) throws SQLException {
        TxnFailoverManagerImpl txnFailoverManagerImpl = (TxnFailoverManagerImpl)TxnFailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(txnFailoverManagerImpl);
        this.originalUser = string;
        this.originalPasswd = string2;
    }

    @Override
    public void setSessionStateConsistency(boolean bl) throws SQLException {
        this.failoverMngr.setSessionStateConsistency(bl);
    }

    @Override
    public Object getProxyObject() throws SQLException {
        return this.logicalProxy;
    }

    @Override
    public void setProxyObject(Object object) throws SQLException {
        this.logicalProxy = object;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.failoverMngr.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.failoverMngr.endRequest();
    }

    @Override
    public void disableReplay() throws SQLException {
        this.failoverMngr.disableReplay();
    }

    public ARRAY createARRAY(String string, Object object) throws SQLException {
        Object object2 = !object.getClass().isArray() || this.isElementTypePrimitive(object) ? object : this.unwrapProxies(object);
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method method = CREATEARRAY_METHOD;
        this.preForAll(method, this, string, object2);
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            ARRAY aRRAY = oracleConnection.createARRAY(string, object2);
            return (ARRAY)this.postForAll(method, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2 = (Object[])this.unwrapProxies(objectArray);
        if (CREATEARRAYOF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        Method method = CREATEARRAYOF_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            ProxyFactory proxyFactory = this.failoverMngr.getProxyFactory();
            if (proxyFactory != null) {
                return (Array)this.postForAll(method, proxyFactory.proxyFor(array));
            }
            this.failoverMngr.disableReplayInternal(method, 370, "Replay disabled", null);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method method = CREATESTRUCT_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            ProxyFactory proxyFactory = this.failoverMngr.getProxyFactory();
            if (proxyFactory != null) {
                return (Struct)this.postForAll(method, proxyFactory.proxyFor(struct));
            }
            this.failoverMngr.disableReplayInternal(method, 370, "Replay disabled", null);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    Object unwrapProxies(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            if (n2 > 0) {
                Object[] objectArray2 = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray2[i2] = this.unwrapProxies(objectArray[i2]);
                }
                return objectArray2;
            }
            return object;
        }
        if (object instanceof TxnReplayableBase) {
            return ((TxnReplayableBase)object).getDelegate();
        }
        return object;
    }

    boolean isElementTypePrimitive(Object object) {
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isPrimitive();
    }

    @Override
    public ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        return this.failoverMngr.getReplayStatistics(statisticsReportType);
    }

    @Override
    public void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        this.failoverMngr.clearReplayStatistics(statisticsReportType);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        LogicalConnectionImpl logicalConnectionImpl = new LogicalConnectionImpl(oraclePooledConnection, (OracleConnection)((Object)this), bl);
        return logicalConnectionImpl;
    }
}

