/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.starter.register;

import cn.easyes.common.utils.EEVersionUtils;
import cn.easyes.common.utils.LogUtils;
import cn.easyes.starter.register.ClassPathMapperScanner;
import cn.easyes.starter.register.EsMapperScan;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class MapperScannerRegister
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes mapperScanAttrs;
        Boolean enable = Optional.ofNullable(this.environment.getProperty("easy-es.enable")).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        if (!enable.booleanValue()) {
            LogUtils.info((String[])new String[]{"===> Easy-Es is not enabled"});
            return;
        }
        boolean banner = Optional.ofNullable(this.environment.getProperty("easy-es.banner")).map(Boolean::parseBoolean).orElse(Boolean.TRUE);
        if (banner) {
            String versionStr = EEVersionUtils.getJarVersion(this.getClass());
            System.out.println("\n___                     _  _            ___\n  | __|   __ _     ___    | || |   ___    | __|    ___\n  | _|   / _` |   (_-<     \\_, |  |___|   | _|    (_-<\n  |___|  \\__,_|   /__/_   _|__/   _____   |___|   /__/_\n_|\"\"\"\"\"|_|\"\"\"\"\"|_|\"\"\"\"\"|_| \"\"\"\"|_|     |_|\"\"\"\"\"|_|\"\"\"\"\"|\n\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\n------------------------------------------------------>");
            System.out.println(":: version   :: " + versionStr + "                                 >");
            System.out.println(":: home      :: https://easy-es.cn/                   >");
            System.out.println(":: community :: https://dromara.org/                  >");
            System.out.println(":: wechat    :: 252645816, add and become muscle man! >");
            System.out.println("------------------------------------------------------>");
        }
        if ((mapperScanAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EsMapperScan.class.getName()))) != null) {
            this.registerBeanDefinitions(mapperScanAttrs, registry);
        }
    }

    void registerBeanDefinitions(AnnotationAttributes annoAttrs, BeanDefinitionRegistry registry) {
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        Optional.ofNullable(this.resourceLoader).ifPresent(arg_0 -> ((ClassPathMapperScanner)scanner).setResourceLoader(arg_0));
        ArrayList basePackages = new ArrayList();
        basePackages.addAll(Arrays.stream(annoAttrs.getStringArray("value")).filter(StringUtils::hasText).collect(Collectors.toList()));
        scanner.registerFilters();
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

