/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamtobe.toolset;

import android.app.Notification;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;

public class NotificationAdapter {
    private static Integer TITLE_COLOR = null;
    private static float TITLE_SIZE = 0.0f;
    private static Integer CONTENT_COLOR = null;
    private static float CONTENT_SIZE = 0.0f;
    private static final String TITLE_TEXT = "SAMPLE-TITLE";
    private static final String CONTENT_TEXT = "SAMPLE-TEXT";

    public static Integer getTitleColor(Context context) {
        if (TITLE_COLOR == null) {
            NotificationAdapter.extractNotificationStyle(context);
        }
        return TITLE_COLOR;
    }

    public static float getTitleSize(Context context) {
        if (TITLE_SIZE == 0.0f) {
            NotificationAdapter.extractNotificationStyle(context);
        }
        return TITLE_SIZE;
    }

    public static Integer getTextColor(Context context) {
        if (CONTENT_COLOR == null) {
            NotificationAdapter.extractNotificationStyle(context);
        }
        return CONTENT_COLOR;
    }

    public static float getTextSize(Context context) {
        if (CONTENT_SIZE == 0.0f) {
            NotificationAdapter.extractNotificationStyle(context);
        }
        return CONTENT_SIZE;
    }

    private static void recurseGroup(ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View v = viewGroup.getChildAt(i);
            if (v instanceof TextView) {
                TextView text = (TextView)v;
                String szText = text.getText().toString();
                if (TITLE_TEXT.equals(szText)) {
                    TITLE_COLOR = text.getTextColors().getDefaultColor();
                    TITLE_SIZE = text.getTextSize();
                } else if (CONTENT_TEXT.equals(szText)) {
                    CONTENT_COLOR = text.getTextColors().getDefaultColor();
                    CONTENT_SIZE = text.getTextSize();
                }
                if (TITLE_COLOR != null && CONTENT_COLOR != null) {
                    return;
                }
            }
            if (!(v instanceof ViewGroup)) continue;
            NotificationAdapter.recurseGroup((ViewGroup)viewGroup.getChildAt(i));
        }
    }

    private static void extractNotificationStyle(Context context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        try {
            RemoteViews tempView;
            Notification.Builder builder = new Notification.Builder(context);
            builder.setContentTitle((CharSequence)TITLE_TEXT);
            builder.setContentText((CharSequence)CONTENT_TEXT);
            LinearLayout group = new LinearLayout(context);
            if (Build.VERSION.SDK_INT >= 24) {
                tempView = builder.createContentView();
            } else {
                Notification notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
                tempView = notification.contentView;
            }
            ViewGroup event = (ViewGroup)tempView.apply(context, (ViewGroup)group);
            NotificationAdapter.recurseGroup(event);
            group.removeAllViews();
        }
        catch (Exception e) {
            TITLE_COLOR = null;
        }
    }
}

