/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamtobe.percentsmoothhandler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import cn.dreamtobe.percentsmoothhandler.ISmoothTarget;
import java.lang.ref.WeakReference;
import junit.framework.Assert;

public class SmoothHandler
extends Handler {
    final WeakReference<ISmoothTarget> targetWeakReference;
    private float aimPercent;
    private float minInternalPercent = 0.03f;
    private float smoothInternalPercent = 0.01f;
    private int smoothIncreaseDelayMillis = 1;
    private final String TAG = "SmoothHandler";
    public static boolean NEED_LOG = false;
    private boolean ignoreCommit = false;
    private long tempStartTimestamp;
    private long tempDurationMillis;
    private long tempRemainDurationMillis;
    private long tempLastConsumeMillis;
    private boolean tempWarnedAccuracyProblem;
    public static float ALLOWED_PRECISION_ERROR = 1.0E-5f;

    public float getMinInternalPercent() {
        return this.minInternalPercent;
    }

    public void setMinInternalPercent(float minInternalPercent) {
        Assert.assertTrue((String)"the min internal percent must more than 0", (minInternalPercent > 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((String)"the min internal percent must less than 1", (minInternalPercent <= 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((String)"the min internal percent must more than the smooth internal percent", (minInternalPercent > this.smoothInternalPercent ? 1 : 0) != 0);
        this.minInternalPercent = minInternalPercent;
    }

    public float getSmoothInternalPercent() {
        return this.smoothInternalPercent;
    }

    public void setSmoothInternalPercent(float smoothInternalPercent) {
        Assert.assertTrue((String)"the smooth internal percent must more than 0", (this.minInternalPercent > 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((String)"the smooth internal percent must less than 0.5", ((double)this.minInternalPercent < 0.5 ? 1 : 0) != 0);
        Assert.assertTrue((String)"the smooth internal percent must less than the min internal percent", (smoothInternalPercent < this.minInternalPercent ? 1 : 0) != 0);
        this.smoothInternalPercent = smoothInternalPercent;
    }

    public int getSmoothIncreaseDelayMillis() {
        return this.smoothIncreaseDelayMillis;
    }

    public void setSmoothIncreaseDelayMillis(int smoothIncreaseDelayMillis) {
        Assert.assertTrue((String)"the delay of increase duration must more than 0", (this.minInternalPercent > 0.0f ? 1 : 0) != 0);
        this.smoothIncreaseDelayMillis = smoothIncreaseDelayMillis;
    }

    public SmoothHandler(WeakReference<ISmoothTarget> targetWeakReference) {
        this(targetWeakReference, Looper.getMainLooper());
    }

    public SmoothHandler(WeakReference<ISmoothTarget> targetWeakReference, Looper looper) {
        super(looper);
        this.targetWeakReference = targetWeakReference;
        this.aimPercent = ((ISmoothTarget)targetWeakReference.get()).getPercent();
        this.clear();
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (this.targetWeakReference == null || this.targetWeakReference.get() == null) {
            return;
        }
        ISmoothTarget target = (ISmoothTarget)this.targetWeakReference.get();
        float currentPercent = target.getPercent();
        float desiredPercentDelta = this.calculatePercent(currentPercent);
        this.setPercent2Target(Math.min(currentPercent + desiredPercentDelta, this.aimPercent));
        float realPercentDelta = target.getPercent() - currentPercent;
        if (target.getPercent() >= this.aimPercent || target.getPercent() >= 1.0f || target.getPercent() == 0.0f && this.aimPercent == 0.0f) {
            if (NEED_LOG) {
                Log.d((String)"SmoothHandler", (String)String.format("finish aimPercent(%f) durationMillis(%d)", Float.valueOf(this.aimPercent), this.tempDurationMillis));
            }
            this.clear();
            return;
        }
        this.sendEmptyMessageDelayed(0, this.calculateDelay(realPercentDelta, desiredPercentDelta));
    }

    private void clear() {
        this.resetTempDelay();
        this.ignoreCommit = false;
        this.removeMessages(0);
    }

    public void commitPercent(float percent) {
        if (this.ignoreCommit) {
            this.ignoreCommit = false;
            return;
        }
        this.aimPercent = percent;
    }

    private void setPercent2Target(float percent) {
        if (this.targetWeakReference == null || this.targetWeakReference.get() == null) {
            return;
        }
        this.ignoreCommit = true;
        ((ISmoothTarget)this.targetWeakReference.get()).setPercent(percent);
        this.ignoreCommit = false;
    }

    public void loopSmooth(float percent) {
        this.loopSmooth(percent, -1L);
    }

    public void loopSmooth(float percent, long durationMillis) {
        if (this.targetWeakReference == null || this.targetWeakReference.get() == null) {
            return;
        }
        if (NEED_LOG) {
            Log.d((String)"SmoothHandler", (String)String.format("start loopSmooth aimPercent(%f) durationMillis(%d)", Float.valueOf(this.aimPercent), durationMillis));
        }
        ISmoothTarget target = (ISmoothTarget)this.targetWeakReference.get();
        this.setPercent2Target(this.aimPercent);
        this.clear();
        this.aimPercent = percent;
        if (this.aimPercent - target.getPercent() > this.minInternalPercent) {
            if (durationMillis >= 0L) {
                this.tempStartTimestamp = SystemClock.uptimeMillis();
                this.tempDurationMillis = durationMillis;
                this.tempRemainDurationMillis = durationMillis;
            }
            this.sendEmptyMessage(0);
        } else {
            this.setPercent2Target(percent);
        }
    }

    private void resetTempDelay() {
        this.tempLastConsumeMillis = this.smoothIncreaseDelayMillis;
        this.tempStartTimestamp = -1L;
        this.tempDurationMillis = -1L;
        this.tempRemainDurationMillis = -1L;
        this.tempWarnedAccuracyProblem = false;
    }

    private float calculatePercent(float currentPercent) {
        if (this.tempDurationMillis < 0L) {
            return this.smoothInternalPercent;
        }
        long usedDuration = SystemClock.uptimeMillis() - this.tempStartTimestamp;
        long lastRemainDurationMillis = this.tempRemainDurationMillis;
        this.tempRemainDurationMillis = this.tempDurationMillis - usedDuration;
        this.tempLastConsumeMillis = Math.max(lastRemainDurationMillis - this.tempRemainDurationMillis, 1L);
        long splitByDelay = Math.max(this.tempRemainDurationMillis / this.tempLastConsumeMillis, 1L);
        float percentDelta = this.aimPercent - currentPercent;
        float internalPercent = percentDelta / (float)splitByDelay;
        return internalPercent;
    }

    private long calculateDelay(float realPercentDelta, float desiredPercentDelta) {
        if (this.tempDurationMillis < 0L) {
            return this.smoothIncreaseDelayMillis;
        }
        if (realPercentDelta - desiredPercentDelta <= ALLOWED_PRECISION_ERROR) {
            return this.smoothIncreaseDelayMillis;
        }
        if (!this.tempWarnedAccuracyProblem) {
            this.tempWarnedAccuracyProblem = true;
            Log.w((String)"SmoothHandler", (String)String.format("Occur Accuracy Problem in %s, (real percent delta is %f, but desired percent delta is %f), so we use delay to handle the temporary duration, as result the processing will not smooth", this.targetWeakReference.get(), Float.valueOf(realPercentDelta), Float.valueOf(desiredPercentDelta)));
        }
        float delta = realPercentDelta - desiredPercentDelta;
        long remedyDelayMillis = (long)(delta / desiredPercentDelta * (float)this.tempLastConsumeMillis);
        return remedyDelayMillis + (long)this.smoothIncreaseDelayMillis;
    }
}

