/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamtobe.kpswitch.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import cn.dreamtobe.kpswitch.IPanelHeightTarget;
import cn.dreamtobe.kpswitch.R;
import cn.dreamtobe.kpswitch.util.KPSwitchConflictUtil;
import cn.dreamtobe.kpswitch.util.KeyBoardSharedPreferences;
import cn.dreamtobe.kpswitch.util.StatusBarHeightUtil;
import cn.dreamtobe.kpswitch.util.ViewUtil;

public class KeyboardUtil {
    private static int LAST_SAVE_KEYBOARD_HEIGHT = 0;
    private static int MAX_PANEL_HEIGHT = 0;
    private static int MIN_PANEL_HEIGHT = 0;
    private static int MIN_KEYBOARD_HEIGHT = 0;

    public static void showKeyboard(View view) {
        view.requestFocus();
        InputMethodManager inputManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        inputManager.showSoftInput(view, 0);
    }

    public static void hideKeyboard(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    private static boolean saveKeyboardHeight(Context context, int keyboardHeight) {
        if (LAST_SAVE_KEYBOARD_HEIGHT == keyboardHeight) {
            return false;
        }
        if (keyboardHeight < 0) {
            return false;
        }
        LAST_SAVE_KEYBOARD_HEIGHT = keyboardHeight;
        Log.d((String)"KeyBordUtil", (String)String.format("save keyboard: %d", keyboardHeight));
        return KeyBoardSharedPreferences.save(context, keyboardHeight);
    }

    public static int getKeyboardHeight(Context context) {
        if (LAST_SAVE_KEYBOARD_HEIGHT == 0) {
            LAST_SAVE_KEYBOARD_HEIGHT = KeyBoardSharedPreferences.get(context, KeyboardUtil.getMinPanelHeight(context.getResources()));
        }
        return LAST_SAVE_KEYBOARD_HEIGHT;
    }

    public static int getValidPanelHeight(Context context) {
        int maxPanelHeight = KeyboardUtil.getMaxPanelHeight(context.getResources());
        int minPanelHeight = KeyboardUtil.getMinPanelHeight(context.getResources());
        int validPanelHeight = KeyboardUtil.getKeyboardHeight(context);
        validPanelHeight = Math.max(minPanelHeight, validPanelHeight);
        validPanelHeight = Math.min(maxPanelHeight, validPanelHeight);
        return validPanelHeight;
    }

    public static int getMaxPanelHeight(Resources res) {
        if (MAX_PANEL_HEIGHT == 0) {
            MAX_PANEL_HEIGHT = res.getDimensionPixelSize(R.dimen.max_panel_height);
        }
        return MAX_PANEL_HEIGHT;
    }

    public static int getMinPanelHeight(Resources res) {
        if (MIN_PANEL_HEIGHT == 0) {
            MIN_PANEL_HEIGHT = res.getDimensionPixelSize(R.dimen.min_panel_height);
        }
        return MIN_PANEL_HEIGHT;
    }

    public static int getMinKeyboardHeight(Context context) {
        if (MIN_KEYBOARD_HEIGHT == 0) {
            MIN_KEYBOARD_HEIGHT = context.getResources().getDimensionPixelSize(R.dimen.min_keyboard_height);
        }
        return MIN_KEYBOARD_HEIGHT;
    }

    @TargetApi(value=13)
    public static ViewTreeObserver.OnGlobalLayoutListener attach(Activity activity, IPanelHeightTarget target, OnKeyboardShowingListener listener) {
        int screenHeight;
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        boolean isFullScreen = ViewUtil.isFullScreen(activity);
        boolean isTranslucentStatus = ViewUtil.isTranslucentStatus(activity);
        boolean isFitSystemWindows = ViewUtil.isFitsSystemWindows(activity);
        Display display = activity.getWindowManager().getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point screenSize = new Point();
            display.getSize(screenSize);
            screenHeight = screenSize.y;
        } else {
            screenHeight = display.getHeight();
        }
        KeyboardStatusListener globalLayoutListener = new KeyboardStatusListener(isFullScreen, isTranslucentStatus, isFitSystemWindows, contentView, target, listener, screenHeight);
        contentView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)globalLayoutListener);
        return globalLayoutListener;
    }

    public static ViewTreeObserver.OnGlobalLayoutListener attach(Activity activity, IPanelHeightTarget target) {
        return KeyboardUtil.attach(activity, target, null);
    }

    @TargetApi(value=16)
    public static void detach(Activity activity, ViewTreeObserver.OnGlobalLayoutListener l) {
        ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
        if (Build.VERSION.SDK_INT >= 16) {
            contentView.getViewTreeObserver().removeOnGlobalLayoutListener(l);
        } else {
            contentView.getViewTreeObserver().removeGlobalOnLayoutListener(l);
        }
    }

    public static interface OnKeyboardShowingListener {
        public void onKeyboardShowing(boolean var1);
    }

    private static class KeyboardStatusListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private static final String TAG = "KeyboardStatusListener";
        private int previousDisplayHeight = 0;
        private final ViewGroup contentView;
        private final IPanelHeightTarget panelHeightTarget;
        private final boolean isFullScreen;
        private final boolean isTranslucentStatus;
        private final boolean isFitSystemWindows;
        private final int statusBarHeight;
        private boolean lastKeyboardShowing;
        private final OnKeyboardShowingListener keyboardShowingListener;
        private final int screenHeight;
        private boolean isOverlayLayoutDisplayHContainStatusBar = false;
        private int maxOverlayLayoutHeight;

        KeyboardStatusListener(boolean isFullScreen, boolean isTranslucentStatus, boolean isFitSystemWindows, ViewGroup contentView, IPanelHeightTarget panelHeightTarget, OnKeyboardShowingListener listener, int screenHeight) {
            this.contentView = contentView;
            this.panelHeightTarget = panelHeightTarget;
            this.isFullScreen = isFullScreen;
            this.isTranslucentStatus = isTranslucentStatus;
            this.isFitSystemWindows = isFitSystemWindows;
            this.statusBarHeight = StatusBarHeightUtil.getStatusBarHeight(contentView.getContext());
            this.keyboardShowingListener = listener;
            this.screenHeight = screenHeight;
        }

        @TargetApi(value=13)
        public void onGlobalLayout() {
            int displayHeight;
            View userRootView = this.contentView.getChildAt(0);
            View actionBarOverlayLayout = (View)this.contentView.getParent();
            Rect r = new Rect();
            if (this.isTranslucentStatus) {
                actionBarOverlayLayout.getWindowVisibleDisplayFrame(r);
                int overlayLayoutDisplayHeight = r.bottom - r.top;
                if (!this.isOverlayLayoutDisplayHContainStatusBar) {
                    boolean bl = this.isOverlayLayoutDisplayHContainStatusBar = overlayLayoutDisplayHeight == this.screenHeight;
                }
                displayHeight = !this.isOverlayLayoutDisplayHContainStatusBar ? overlayLayoutDisplayHeight + this.statusBarHeight : overlayLayoutDisplayHeight;
            } else {
                userRootView.getWindowVisibleDisplayFrame(r);
                displayHeight = r.bottom - r.top;
            }
            this.calculateKeyboardHeight(displayHeight);
            this.calculateKeyboardShowing(displayHeight);
            this.previousDisplayHeight = displayHeight;
        }

        private void calculateKeyboardHeight(int displayHeight) {
            int keyboardHeight;
            if (this.previousDisplayHeight == 0) {
                this.previousDisplayHeight = displayHeight;
                this.panelHeightTarget.refreshHeight(KeyboardUtil.getValidPanelHeight(this.getContext()));
                return;
            }
            if (KPSwitchConflictUtil.isHandleByPlaceholder(this.isFullScreen, this.isTranslucentStatus, this.isFitSystemWindows)) {
                View actionBarOverlayLayout = (View)this.contentView.getParent();
                keyboardHeight = actionBarOverlayLayout.getHeight() - displayHeight;
                Log.d((String)TAG, (String)String.format("action bar over layout %d display height: %d", ((View)this.contentView.getParent()).getHeight(), displayHeight));
            } else {
                keyboardHeight = Math.abs(displayHeight - this.previousDisplayHeight);
            }
            if (keyboardHeight <= KeyboardUtil.getMinKeyboardHeight(this.getContext())) {
                return;
            }
            Log.d((String)TAG, (String)String.format("pre display height: %d display height: %d keyboard: %d ", this.previousDisplayHeight, displayHeight, keyboardHeight));
            if (keyboardHeight == this.statusBarHeight) {
                Log.w((String)TAG, (String)String.format("On global layout change get keyboard height just equal statusBar height %d", keyboardHeight));
                return;
            }
            boolean changed = KeyboardUtil.saveKeyboardHeight(this.getContext(), keyboardHeight);
            if (changed) {
                int validPanelHeight = KeyboardUtil.getValidPanelHeight(this.getContext());
                if (this.panelHeightTarget.getHeight() != validPanelHeight) {
                    this.panelHeightTarget.refreshHeight(validPanelHeight);
                }
            }
        }

        private void calculateKeyboardShowing(int displayHeight) {
            boolean isKeyboardShowing;
            View actionBarOverlayLayout = (View)this.contentView.getParent();
            int actionBarOverlayLayoutHeight = actionBarOverlayLayout.getHeight() - actionBarOverlayLayout.getPaddingTop();
            if (KPSwitchConflictUtil.isHandleByPlaceholder(this.isFullScreen, this.isTranslucentStatus, this.isFitSystemWindows)) {
                isKeyboardShowing = !this.isTranslucentStatus && actionBarOverlayLayoutHeight - displayHeight == this.statusBarHeight ? this.lastKeyboardShowing : actionBarOverlayLayoutHeight > displayHeight;
            } else {
                int phoneDisplayHeight = this.contentView.getResources().getDisplayMetrics().heightPixels;
                if (!this.isTranslucentStatus && phoneDisplayHeight == actionBarOverlayLayoutHeight) {
                    Log.w((String)TAG, (String)String.format("skip the keyboard status calculate, the current activity is paused. and phone-display-height %d, root-height+actionbar-height %d", phoneDisplayHeight, actionBarOverlayLayoutHeight));
                    return;
                }
                isKeyboardShowing = this.maxOverlayLayoutHeight == 0 ? this.lastKeyboardShowing : displayHeight < this.maxOverlayLayoutHeight - KeyboardUtil.getMinKeyboardHeight(this.getContext());
                this.maxOverlayLayoutHeight = Math.max(this.maxOverlayLayoutHeight, actionBarOverlayLayoutHeight);
            }
            if (this.lastKeyboardShowing != isKeyboardShowing) {
                Log.d((String)TAG, (String)String.format("displayHeight %d actionBarOverlayLayoutHeight %d keyboard status change: %B", displayHeight, actionBarOverlayLayoutHeight, isKeyboardShowing));
                this.panelHeightTarget.onKeyboardShowing(isKeyboardShowing);
                if (this.keyboardShowingListener != null) {
                    this.keyboardShowingListener.onKeyboardShowing(isKeyboardShowing);
                }
            }
            this.lastKeyboardShowing = isKeyboardShowing;
        }

        private Context getContext() {
            return this.contentView.getContext();
        }
    }
}

