/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamtobe.kpswitch.handler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import cn.dreamtobe.kpswitch.IPanelConflictLayout;
import cn.dreamtobe.kpswitch.util.KeyboardUtil;
import cn.dreamtobe.kpswitch.util.StatusBarHeightUtil;
import cn.dreamtobe.kpswitch.util.ViewUtil;

public class KPSwitchRootLayoutHandler {
    private static final String TAG = "KPSRootLayoutHandler";
    private int mOldHeight = -1;
    private final View mTargetRootView;
    private final int mStatusBarHeight;
    private final boolean mIsTranslucentStatus;
    private IPanelConflictLayout mPanelLayout;

    public KPSwitchRootLayoutHandler(View rootView) {
        this.mTargetRootView = rootView;
        this.mStatusBarHeight = StatusBarHeightUtil.getStatusBarHeight(rootView.getContext());
        Activity activity = (Activity)rootView.getContext();
        this.mIsTranslucentStatus = ViewUtil.isTranslucentStatus(activity);
    }

    @TargetApi(value=16)
    public void handleBeforeMeasure(int width, int height) {
        if (this.mIsTranslucentStatus && Build.VERSION.SDK_INT >= 16 && this.mTargetRootView.getFitsSystemWindows()) {
            Rect rect = new Rect();
            this.mTargetRootView.getWindowVisibleDisplayFrame(rect);
            height = rect.bottom - rect.top;
        }
        Log.d((String)TAG, (String)("onMeasure, width: " + width + " height: " + height));
        if (height < 0) {
            return;
        }
        if (this.mOldHeight < 0) {
            this.mOldHeight = height;
            return;
        }
        int offset = this.mOldHeight - height;
        if (offset == 0) {
            Log.d((String)TAG, (String)("" + offset + " == 0 break;"));
            return;
        }
        if (Math.abs(offset) == this.mStatusBarHeight) {
            Log.w((String)TAG, (String)String.format("offset just equal statusBar height %d", offset));
            return;
        }
        this.mOldHeight = height;
        IPanelConflictLayout panel = this.getPanelLayout(this.mTargetRootView);
        if (panel == null) {
            Log.w((String)TAG, (String)"can't find the valid panel conflict layout, give up!");
            return;
        }
        if (Math.abs(offset) < KeyboardUtil.getMinKeyboardHeight(this.mTargetRootView.getContext())) {
            Log.w((String)TAG, (String)"system bottom-menu-bar(such as HuaWei Mate7) causes layout changed");
            return;
        }
        if (offset > 0) {
            panel.handleHide();
        } else if (panel.isKeyboardShowing() && panel.isVisible()) {
            panel.handleShow();
        }
    }

    private IPanelConflictLayout getPanelLayout(View view) {
        if (this.mPanelLayout != null) {
            return this.mPanelLayout;
        }
        if (view instanceof IPanelConflictLayout) {
            this.mPanelLayout = (IPanelConflictLayout)view;
            return this.mPanelLayout;
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                IPanelConflictLayout v = this.getPanelLayout(((ViewGroup)view).getChildAt(i));
                if (v == null) continue;
                this.mPanelLayout = v;
                return this.mPanelLayout;
            }
        }
        return null;
    }
}

