/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamtobe.kpswitch.handler;

import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import cn.dreamtobe.kpswitch.IPanelConflictLayout;
import cn.dreamtobe.kpswitch.R;
import cn.dreamtobe.kpswitch.util.ViewUtil;

public class KPSwitchPanelLayoutHandler
implements IPanelConflictLayout {
    private final View panelLayout;
    private boolean mIsHide = false;
    private boolean mIgnoreRecommendHeight = false;
    private final int[] processedMeasureWHSpec = new int[2];
    private boolean mIsKeyboardShowing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KPSwitchPanelLayoutHandler(View panelLayout, AttributeSet attrs) {
        this.panelLayout = panelLayout;
        if (attrs != null) {
            TypedArray typedArray = null;
            try {
                typedArray = panelLayout.getContext().obtainStyledAttributes(attrs, R.styleable.KPSwitchPanelLayout);
                this.mIgnoreRecommendHeight = typedArray.getBoolean(R.styleable.KPSwitchPanelLayout_ignore_recommend_height, false);
            }
            finally {
                if (typedArray != null) {
                    typedArray.recycle();
                }
            }
        }
    }

    public boolean filterSetVisibility(int visibility) {
        if (visibility == 0) {
            this.mIsHide = false;
        }
        if (visibility == this.panelLayout.getVisibility()) {
            return true;
        }
        return this.isKeyboardShowing() && visibility == 0;
    }

    public int[] processOnMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIsHide) {
            this.panelLayout.setVisibility(8);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0x40000000);
        }
        this.processedMeasureWHSpec[0] = widthMeasureSpec;
        this.processedMeasureWHSpec[1] = heightMeasureSpec;
        return this.processedMeasureWHSpec;
    }

    public void setIsKeyboardShowing(boolean isKeyboardShowing) {
        this.mIsKeyboardShowing = isKeyboardShowing;
    }

    @Override
    public boolean isKeyboardShowing() {
        return this.mIsKeyboardShowing;
    }

    @Override
    public boolean isVisible() {
        return !this.mIsHide;
    }

    @Override
    public void handleShow() {
        throw new IllegalAccessError("You can't invoke handle show in handler, please instead of handling in the panel layout, maybe just need invoke super.setVisibility(View.VISIBLE)");
    }

    @Override
    public void handleHide() {
        this.mIsHide = true;
    }

    public void resetToRecommendPanelHeight(int recommendPanelHeight) {
        if (this.mIgnoreRecommendHeight) {
            return;
        }
        ViewUtil.refreshHeight(this.panelLayout, recommendPanelHeight);
    }

    @Override
    public void setIgnoreRecommendHeight(boolean ignoreRecommendHeight) {
        this.mIgnoreRecommendHeight = ignoreRecommendHeight;
    }
}

