/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.config;

import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;
import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class SaSsoConfig
implements Serializable {
    private static final long serialVersionUID = -6541180061782004705L;
    public String mode = "";
    public long ticketTimeout = 300L;
    public String allowUrl = "*";
    public Boolean isSlo = true;
    public Boolean isHttp = false;
    public String client;
    public String authUrl = "/sso/auth";
    public String checkTicketUrl = "/sso/checkTicket";
    public String getDataUrl = "/sso/getData";
    public String userinfoUrl = "/sso/userinfo";
    public String sloUrl = "/sso/signout";
    public String ssoLogoutCall;
    public String serverUrl;
    public Supplier<Object> notLoginView = () -> "\u5f53\u524d\u4f1a\u8bdd\u5728SSO-Server\u8ba4\u8bc1\u4e2d\u5fc3\u5c1a\u672a\u767b\u5f55";
    public BiFunction<String, String, Object> doLoginHandle = (name, pwd) -> SaResult.error();
    public BiFunction<Object, String, Object> ticketResultHandle = null;
    public Function<String, String> sendHttp = url -> {
        throw new SaSsoException("\u8bf7\u914d\u7f6e Http \u8bf7\u6c42\u5904\u7406\u5668").setCode(30010);
    };

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public long getTicketTimeout() {
        return this.ticketTimeout;
    }

    public SaSsoConfig setTicketTimeout(long ticketTimeout) {
        this.ticketTimeout = ticketTimeout;
        return this;
    }

    public String getAllowUrl() {
        return this.allowUrl;
    }

    public SaSsoConfig setAllowUrl(String allowUrl) {
        this.allowUrl = allowUrl;
        return this;
    }

    public Boolean getIsSlo() {
        return this.isSlo;
    }

    public SaSsoConfig setIsSlo(Boolean isSlo) {
        this.isSlo = isSlo;
        return this;
    }

    public Boolean getIsHttp() {
        return this.isHttp;
    }

    public SaSsoConfig setIsHttp(Boolean isHttp) {
        this.isHttp = isHttp;
        return this;
    }

    public String getClient() {
        return this.client;
    }

    public SaSsoConfig setClient(String client) {
        this.client = client;
        return this;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public SaSsoConfig setAuthUrl(String authUrl) {
        this.authUrl = authUrl;
        return this;
    }

    public String getCheckTicketUrl() {
        return this.checkTicketUrl;
    }

    public SaSsoConfig setCheckTicketUrl(String checkTicketUrl) {
        this.checkTicketUrl = checkTicketUrl;
        return this;
    }

    public String getGetDataUrl() {
        return this.getDataUrl;
    }

    public SaSsoConfig setGetDataUrl(String getDataUrl) {
        this.getDataUrl = getDataUrl;
        return this;
    }

    public String getUserinfoUrl() {
        return this.userinfoUrl;
    }

    public SaSsoConfig setUserinfoUrl(String userinfoUrl) {
        this.userinfoUrl = userinfoUrl;
        return this;
    }

    public String getSloUrl() {
        return this.sloUrl;
    }

    public SaSsoConfig setSloUrl(String sloUrl) {
        this.sloUrl = sloUrl;
        return this;
    }

    public String getSsoLogoutCall() {
        return this.ssoLogoutCall;
    }

    public SaSsoConfig setSsoLogoutCall(String ssoLogoutCall) {
        this.ssoLogoutCall = ssoLogoutCall;
        return this;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public SaSsoConfig setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public String toString() {
        return "SaSsoConfig [mode=" + this.mode + ", ticketTimeout=" + this.ticketTimeout + ", allowUrl=" + this.allowUrl + ", isSlo=" + this.isSlo + ", isHttp=" + this.isHttp + ", client=" + this.client + ", authUrl=" + this.authUrl + ", checkTicketUrl=" + this.checkTicketUrl + ", getDataUrl=" + this.getDataUrl + ", userinfoUrl=" + this.userinfoUrl + ", sloUrl=" + this.sloUrl + ", ssoLogoutCall=" + this.ssoLogoutCall + ", serverUrl=" + this.serverUrl + "]";
    }

    public String splicingAuthUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getAuthUrl());
    }

    public String splicingCheckTicketUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getCheckTicketUrl());
    }

    public String splicingGetDataUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getGetDataUrl());
    }

    public String splicingUserinfoUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getUserinfoUrl());
    }

    public String splicingSloUrl() {
        return SaFoxUtil.spliceTwoUrl((String)this.getServerUrl(), (String)this.getSloUrl());
    }

    public SaSsoConfig setAllow(String ... url) {
        this.allowUrl = SaFoxUtil.arrayJoin((String[])url);
        return this;
    }

    public SaSsoConfig setNotLoginView(Supplier<Object> notLoginView) {
        this.notLoginView = notLoginView;
        return this;
    }

    public Supplier<Object> getNotLoginView() {
        return this.notLoginView;
    }

    public SaSsoConfig setDoLoginHandle(BiFunction<String, String, Object> doLoginHandle) {
        this.doLoginHandle = doLoginHandle;
        return this;
    }

    public BiFunction<String, String, Object> getDoLoginHandle() {
        return this.doLoginHandle;
    }

    public SaSsoConfig setTicketResultHandle(BiFunction<Object, String, Object> ticketResultHandle) {
        this.ticketResultHandle = ticketResultHandle;
        return this;
    }

    public BiFunction<Object, String, Object> getTicketResultHandle() {
        return this.ticketResultHandle;
    }

    public SaSsoConfig setSendHttp(Function<String, String> sendHttp) {
        this.sendHttp = sendHttp;
        return this;
    }

    public Function<String, String> getSendHttp() {
        return this.sendHttp;
    }
}

