/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.granttype.handler;

import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.consts.GrantType;
import cn.dev33.satoken.oauth2.consts.SaOAuth2Consts;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.exception.SaOAuth2ClientModelException;
import cn.dev33.satoken.oauth2.exception.SaOAuth2RefreshTokenException;
import cn.dev33.satoken.oauth2.granttype.handler.SaOAuth2GrantTypeHandlerInterface;
import java.util.List;

public class RefreshTokenGrantTypeHandler
implements SaOAuth2GrantTypeHandlerInterface {
    @Override
    public String getHandlerGrantType() {
        return GrantType.refresh_token;
    }

    @Override
    public AccessTokenModel getAccessToken(SaRequest req, String clientId, List<String> scopes) {
        String refreshToken = req.getParamNotNull(SaOAuth2Consts.Param.refresh_token);
        RefreshTokenModel rt = SaOAuth2Manager.getDao().getRefreshToken(refreshToken);
        SaOAuth2RefreshTokenException.throwBy(rt == null, "\u65e0\u6548refresh_token: " + refreshToken, refreshToken, 30111);
        SaOAuth2ClientModelException.throwBy(!rt.clientId.equals(clientId), "\u65e0\u6548client_id: " + clientId, clientId, 30122);
        AccessTokenModel accessTokenModel = SaOAuth2Manager.getDataGenerate().refreshAccessToken(refreshToken);
        return accessTokenModel;
    }
}

