/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.oauth2.dao;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.oauth2.SaOAuth2Manager;
import cn.dev33.satoken.oauth2.data.model.AccessTokenModel;
import cn.dev33.satoken.oauth2.data.model.ClientTokenModel;
import cn.dev33.satoken.oauth2.data.model.CodeModel;
import cn.dev33.satoken.oauth2.data.model.RefreshTokenModel;
import cn.dev33.satoken.oauth2.data.model.loader.SaClientModel;
import cn.dev33.satoken.oauth2.template.SaOAuth2Util;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.List;

public interface SaOAuth2Dao {
    default public void saveCode(CodeModel c) {
        if (c == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingCodeSaveKey(c.code), (Object)c, SaOAuth2Manager.getServerConfig().getCodeTimeout());
    }

    default public void saveCodeIndex(CodeModel c) {
        if (c == null) {
            return;
        }
        this.getSaTokenDao().set(this.splicingCodeIndexKey(c.clientId, c.loginId), c.code, SaOAuth2Manager.getServerConfig().getCodeTimeout());
    }

    default public void saveAccessToken(AccessTokenModel at) {
        if (at == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingAccessTokenSaveKey(at.accessToken), (Object)at, at.getExpiresIn());
    }

    default public void saveAccessTokenIndex(AccessTokenModel at) {
        if (at == null) {
            return;
        }
        this.getSaTokenDao().set(this.splicingAccessTokenIndexKey(at.clientId, at.loginId), at.accessToken, at.getExpiresIn());
    }

    default public void saveRefreshToken(RefreshTokenModel rt) {
        if (rt == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingRefreshTokenSaveKey(rt.refreshToken), (Object)rt, rt.getExpiresIn());
    }

    default public void saveRefreshTokenIndex(RefreshTokenModel rt) {
        if (rt == null) {
            return;
        }
        this.getSaTokenDao().set(this.splicingRefreshTokenIndexKey(rt.clientId, rt.loginId), rt.refreshToken, rt.getExpiresIn());
    }

    default public void saveClientToken(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        this.getSaTokenDao().setObject(this.splicingClientTokenSaveKey(ct.clientToken), (Object)ct, ct.getExpiresIn());
    }

    default public void saveClientTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        this.getSaTokenDao().set(this.splicingClientTokenIndexKey(ct.clientId), ct.clientToken, ct.getExpiresIn());
    }

    default public void saveLowerClientTokenIndex(ClientTokenModel ct) {
        if (ct == null) {
            return;
        }
        long ttl = ct.getExpiresIn();
        SaClientModel cm = SaOAuth2Util.checkClientModel(ct.clientId);
        if (cm.getLowerClientTokenTimeout() != -1L) {
            ttl = cm.getLowerClientTokenTimeout();
        }
        this.getSaTokenDao().set(this.splicingLowerClientTokenIndexKey(ct.clientId), ct.clientToken, ttl);
    }

    default public void saveGrantScope(String clientId, Object loginId, List<String> scopes) {
        if (!SaFoxUtil.isEmpty(scopes)) {
            long ttl = SaOAuth2Util.checkClientModel(clientId).getAccessTokenTimeout();
            String value = SaOAuth2Manager.getDataConverter().convertScopeListToString(scopes);
            this.getSaTokenDao().set(this.splicingGrantScopeKey(clientId, loginId), value, ttl);
        }
    }

    default public void saveState(String state) {
        if (!SaFoxUtil.isEmpty((Object)state)) {
            long ttl = SaOAuth2Manager.getServerConfig().getCodeTimeout();
            this.getSaTokenDao().set(this.splicingStateSaveKey(state), state, ttl);
        }
    }

    default public void deleteCode(String code) {
        if (code != null) {
            this.getSaTokenDao().deleteObject(this.splicingCodeSaveKey(code));
        }
    }

    default public void deleteCodeIndex(String clientId, Object loginId) {
        this.getSaTokenDao().delete(this.splicingCodeIndexKey(clientId, loginId));
    }

    default public void deleteAccessToken(String accessToken) {
        if (accessToken != null) {
            this.getSaTokenDao().deleteObject(this.splicingAccessTokenSaveKey(accessToken));
        }
    }

    default public void deleteAccessTokenIndex(String clientId, Object loginId) {
        this.getSaTokenDao().delete(this.splicingAccessTokenIndexKey(clientId, loginId));
    }

    default public void deleteRefreshToken(String refreshToken) {
        if (refreshToken != null) {
            this.getSaTokenDao().deleteObject(this.splicingRefreshTokenSaveKey(refreshToken));
        }
    }

    default public void deleteRefreshTokenIndex(String clientId, Object loginId) {
        this.getSaTokenDao().delete(this.splicingRefreshTokenIndexKey(clientId, loginId));
    }

    default public void deleteClientToken(String clientToken) {
        if (clientToken != null) {
            this.getSaTokenDao().deleteObject(this.splicingClientTokenSaveKey(clientToken));
        }
    }

    default public void deleteClientTokenIndex(String clientId) {
        this.getSaTokenDao().delete(this.splicingClientTokenIndexKey(clientId));
    }

    default public void deleteLowerClientToken(String lowerClientToken) {
        this.deleteClientToken(lowerClientToken);
    }

    default public void deleteLowerClientTokenIndex(String clientId) {
        this.getSaTokenDao().delete(this.splicingLowerClientTokenIndexKey(clientId));
    }

    default public void deleteGrantScope(String clientId, Object loginId) {
        this.getSaTokenDao().delete(this.splicingGrantScopeKey(clientId, loginId));
    }

    default public void deleteGrantScope(String state) {
        this.getSaTokenDao().delete(this.splicingStateSaveKey(state));
    }

    default public CodeModel getCode(String code) {
        if (code == null) {
            return null;
        }
        return (CodeModel)this.getSaTokenDao().getObject(this.splicingCodeSaveKey(code));
    }

    default public String getCodeValue(String clientId, Object loginId) {
        return this.getSaTokenDao().get(this.splicingCodeIndexKey(clientId, loginId));
    }

    default public AccessTokenModel getAccessToken(String accessToken) {
        if (accessToken == null) {
            return null;
        }
        return (AccessTokenModel)this.getSaTokenDao().getObject(this.splicingAccessTokenSaveKey(accessToken));
    }

    default public String getAccessTokenValue(String clientId, Object loginId) {
        return this.getSaTokenDao().get(this.splicingAccessTokenIndexKey(clientId, loginId));
    }

    default public RefreshTokenModel getRefreshToken(String refreshToken) {
        if (refreshToken == null) {
            return null;
        }
        return (RefreshTokenModel)this.getSaTokenDao().getObject(this.splicingRefreshTokenSaveKey(refreshToken));
    }

    default public String getRefreshTokenValue(String clientId, Object loginId) {
        return this.getSaTokenDao().get(this.splicingRefreshTokenIndexKey(clientId, loginId));
    }

    default public ClientTokenModel getClientToken(String clientToken) {
        if (clientToken == null) {
            return null;
        }
        return (ClientTokenModel)this.getSaTokenDao().getObject(this.splicingClientTokenSaveKey(clientToken));
    }

    default public String getClientTokenValue(String clientId) {
        return this.getSaTokenDao().get(this.splicingClientTokenIndexKey(clientId));
    }

    default public String getLowerClientTokenValue(String clientId) {
        return this.getSaTokenDao().get(this.splicingLowerClientTokenIndexKey(clientId));
    }

    default public List<String> getGrantScope(String clientId, Object loginId) {
        String value = this.getSaTokenDao().get(this.splicingGrantScopeKey(clientId, loginId));
        return SaOAuth2Manager.getDataConverter().convertScopeStringToList(value);
    }

    default public String getState(String state) {
        if (SaFoxUtil.isEmpty((Object)state)) {
            return null;
        }
        return this.getSaTokenDao().get(this.splicingStateSaveKey(state));
    }

    default public String splicingCodeSaveKey(String code) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:code:" + code;
    }

    default public String splicingCodeIndexKey(String clientId, Object loginId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:code-index:" + clientId + ":" + loginId;
    }

    default public String splicingAccessTokenSaveKey(String accessToken) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:access-token:" + accessToken;
    }

    default public String splicingAccessTokenIndexKey(String clientId, Object loginId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:access-token-index:" + clientId + ":" + loginId;
    }

    default public String splicingRefreshTokenSaveKey(String refreshToken) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:refresh-token:" + refreshToken;
    }

    default public String splicingRefreshTokenIndexKey(String clientId, Object loginId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:refresh-token-index:" + clientId + ":" + loginId;
    }

    default public String splicingClientTokenSaveKey(String clientToken) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:client-token:" + clientToken;
    }

    default public String splicingClientTokenIndexKey(String clientId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:client-token-index:" + clientId;
    }

    default public String splicingLowerClientTokenIndexKey(String clientId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:lower-client-token-index:" + clientId;
    }

    default public String splicingGrantScopeKey(String clientId, Object loginId) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:grant-scope:" + clientId + ":" + loginId;
    }

    default public String splicingStateSaveKey(String state) {
        return this.getSaTokenConfig().getTokenName() + ":oauth2:state:" + state;
    }

    default public SaTokenDao getSaTokenDao() {
        return SaManager.getSaTokenDao();
    }

    default public SaTokenConfig getSaTokenConfig() {
        return SaManager.getConfig();
    }
}

