/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jwt;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.exception.ApiDisabledException;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.jwt.SaJwtUtil;
import cn.dev33.satoken.stp.SaLoginModel;
import cn.dev33.satoken.stp.SaTokenInfo;
import cn.dev33.satoken.stp.StpLogic;
import java.util.Map;

public class StpLogicJwtForStateless
extends StpLogic {
    public StpLogicJwtForStateless() {
        super("login");
    }

    public StpLogicJwtForStateless(String loginType) {
        super(loginType);
    }

    public String jwtSecretKey() {
        return this.getConfig().getJwtSecretKey();
    }

    public String createTokenValue(Object loginId, String device, long timeout, Map<String, Object> extraData) {
        return SaJwtUtil.createToken(this.loginType, loginId, device, timeout, extraData, this.jwtSecretKey());
    }

    public SaTokenInfo getTokenInfo() {
        SaTokenInfo info = new SaTokenInfo();
        info.tokenName = this.getTokenName();
        info.tokenValue = this.getTokenValue();
        info.isLogin = this.isLogin();
        info.loginId = this.getLoginIdDefaultNull();
        info.loginType = this.getLoginType();
        info.tokenTimeout = this.getTokenTimeout();
        info.sessionTimeout = -2L;
        info.tokenSessionTimeout = -2L;
        info.tokenActivityTimeout = -2L;
        info.loginDevice = this.getLoginDevice();
        return info;
    }

    public void login(Object id, SaLoginModel loginModel) {
        SaTokenException.throwByNull((Object)id, (String)"\u8d26\u53f7id\u4e0d\u80fd\u4e3a\u7a7a");
        loginModel.build(this.getConfig());
        String tokenValue = this.createTokenValue(id, loginModel.getDeviceOrDefault(), loginModel.getTimeout(), loginModel.getExtraData());
        this.setTokenValue(tokenValue, loginModel.getCookieTimeout());
        SaManager.getSaTokenListener().doLogin(this.loginType, id, loginModel);
    }

    public String getLoginIdNotHandle(String tokenValue) {
        String loginType = SaJwtUtil.getPayloadsNotCheck(tokenValue, this.jwtSecretKey()).getStr((Object)"loginType");
        if (!this.getLoginType().equals(loginType)) {
            return null;
        }
        try {
            Object loginId = SaJwtUtil.getLoginId(tokenValue, this.jwtSecretKey());
            return String.valueOf(loginId);
        }
        catch (NotLoginException e) {
            return null;
        }
    }

    public void logout() {
        SaHolder.getStorage().delete(this.splicingKeyJustCreatedSave());
        if (this.getConfig().getIsReadCookie().booleanValue()) {
            SaHolder.getResponse().deleteCookie(this.getTokenName());
        }
    }

    public Object getExtra(String key) {
        return SaJwtUtil.getPayloads(this.getTokenValue(), this.jwtSecretKey()).get((Object)key);
    }

    public long getTokenTimeout() {
        return SaJwtUtil.getTimeout(this.getTokenValue(), this.jwtSecretKey());
    }

    public String getLoginDevice() {
        String tokenValue = this.getTokenValue();
        if (tokenValue == null) {
            return null;
        }
        if (!this.isLogin()) {
            return null;
        }
        return SaJwtUtil.getPayloadsNotCheck(tokenValue, this.jwtSecretKey()).getStr((Object)"device");
    }

    public SaTokenDao getSaTokenDao() {
        throw new ApiDisabledException();
    }
}

