/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.jfinal;

import cn.dev33.satoken.jfinal.SaControllerContext;
import com.jfinal.aop.Invocation;
import com.jfinal.config.Constants;
import com.jfinal.core.Action;
import com.jfinal.core.ActionException;
import com.jfinal.core.ActionHandler;
import com.jfinal.core.ActionMapping;
import com.jfinal.core.ActionReporter;
import com.jfinal.core.CPI;
import com.jfinal.core.Controller;
import com.jfinal.core.ControllerFactory;
import com.jfinal.core.ForwardActionRender;
import com.jfinal.kit.ReflectKit;
import com.jfinal.log.Log;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import com.jfinal.render.RenderManager;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaTokenActionHandler
extends ActionHandler {
    protected boolean devMode;
    protected ActionMapping actionMapping;
    protected ControllerFactory controllerFactory;
    protected ActionReporter actionReporter;
    protected static final RenderManager renderManager = RenderManager.me();
    private static final Log log = Log.getLog(ActionHandler.class);

    protected void init(ActionMapping actionMapping, Constants constants) {
        this.actionMapping = actionMapping;
        this.devMode = constants.getDevMode();
        this.controllerFactory = constants.getControllerFactory();
        this.actionReporter = constants.getActionReporter();
    }

    protected Action getAction(String target, String[] urlPara) {
        return this.actionMapping.getAction(target, urlPara);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.indexOf(46) != -1) {
            return;
        }
        isHandled[0] = true;
        String[] urlPara = new String[]{null};
        Action action = this.getAction(target, urlPara);
        if (action == null) {
            if (log.isWarnEnabled()) {
                String qs = request.getQueryString();
                log.warn("404 Action Not Found: " + (qs == null ? target : target + "?" + qs));
            }
            renderManager.getRenderFactory().getErrorRender(404).setContext(request, response).render();
            return;
        }
        Controller controller = null;
        try {
            controller = this.controllerFactory.getController(action.getControllerClass());
            CPI._init_((Controller)controller, (Action)action, (HttpServletRequest)request, (HttpServletResponse)response, (String)urlPara[0]);
            SaControllerContext.hold(controller);
            if (this.devMode) {
                if (this.actionReporter.isReportAfterInvocation(request)) {
                    new Invocation(action, controller).invoke();
                    this.actionReporter.report(target, controller, action);
                } else {
                    this.actionReporter.report(target, controller, action);
                    new Invocation(action, controller).invoke();
                }
            } else {
                new Invocation(action, controller).invoke();
            }
            Render render = controller.getRender();
            if (render instanceof ForwardActionRender) {
                String actionUrl = ((ForwardActionRender)render).getActionUrl();
                if (target.equals(actionUrl)) {
                    throw new RuntimeException("The forward action url is the same as before.");
                }
                this.handle(actionUrl, request, response, isHandled);
                return;
            }
            if (render == null) {
                render = renderManager.getRenderFactory().getDefaultRender(action.getViewPath() + action.getMethodName());
            }
            render.setContext(request, response, action.getViewPath()).render();
        }
        catch (RenderException e) {
            if (log.isErrorEnabled()) {
                String qs = request.getQueryString();
                log.error(qs == null ? target : target + "?" + qs, (Throwable)e);
            }
        }
        catch (ActionException e) {
            this.handleActionException(target, request, response, action, e);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                String qs = request.getQueryString();
                String targetInfo = qs == null ? target : target + "?" + qs;
                String sign = ReflectKit.getMethodSignature((Method)action.getMethod());
                log.error(sign + " : " + targetInfo, (Throwable)e);
            }
            renderManager.getRenderFactory().getErrorRender(500).setContext(request, response, action.getViewPath()).render();
        }
        finally {
            SaControllerContext.release();
            this.controllerFactory.recycle(controller);
        }
    }

    private void handleActionException(String target, HttpServletRequest request, HttpServletResponse response, Action action, ActionException e) {
        int errorCode = e.getErrorCode();
        String msg = null;
        if (errorCode == 404) {
            msg = "404 Not Found: ";
        } else if (errorCode == 400) {
            msg = "400 Bad Request: ";
        } else if (errorCode == 401) {
            msg = "401 Unauthorized: ";
        } else if (errorCode == 403) {
            msg = "403 Forbidden: ";
        }
        if (msg != null) {
            if (log.isWarnEnabled()) {
                String qs = request.getQueryString();
                msg = msg + (qs == null ? target : target + "?" + qs);
                if (e.getMessage() != null) {
                    msg = msg + "\n" + e.getMessage();
                }
                log.warn(msg);
            }
        } else if (log.isErrorEnabled()) {
            String qs = request.getQueryString();
            log.error(errorCode + " Error: " + (qs == null ? target : target + "?" + qs), (Throwable)e);
        }
        e.getErrorRender().setContext(request, response, action.getViewPath()).render();
    }
}

