/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.json;

import cn.dev33.satoken.exception.SaJsonConvertException;
import cn.dev33.satoken.json.SaJsonTemplate;
import cn.dev33.satoken.util.SaFoxUtil;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class SaJsonTemplateForJackson
implements SaJsonTemplate {
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "HH:mm:ss";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public ObjectMapper objectMapper = new ObjectMapper();
    public ObjectMapper mapObjectMapper = new ObjectMapper();

    public SaJsonTemplateForJackson() {
        BasicPolymorphicTypeValidator ptv = BasicPolymorphicTypeValidator.builder().allowIfSubType(Object.class).allowIfBaseType(Object.class).build();
        this.objectMapper.activateDefaultTyping((PolymorphicTypeValidator)ptv, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JavaTimeModule timeModule = new JavaTimeModule();
        timeModule.addSerializer((JsonSerializer)new LocalDateTimeSerializer(DATE_TIME_FORMATTER));
        timeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DATE_TIME_FORMATTER));
        timeModule.addSerializer((JsonSerializer)new LocalDateSerializer(DATE_FORMATTER));
        timeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DATE_FORMATTER));
        timeModule.addSerializer((JsonSerializer)new LocalTimeSerializer(TIME_FORMATTER));
        timeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(TIME_FORMATTER));
        this.objectMapper.registerModule((Module)timeModule);
    }

    public String objectToJson(Object obj) {
        if (SaFoxUtil.isEmpty((Object)obj)) {
            return null;
        }
        try {
            if (obj instanceof Map) {
                return this.mapObjectMapper.writeValueAsString(obj);
            }
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new SaJsonConvertException((Throwable)e);
        }
    }

    public <T> T jsonToObject(String jsonStr, Class<T> type) {
        if (SaFoxUtil.isEmpty((Object)jsonStr)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(jsonStr, type);
        }
        catch (JsonProcessingException e) {
            throw new SaJsonConvertException((Throwable)e);
        }
    }

    public Map<String, Object> jsonToMap(String jsonStr) {
        if (SaFoxUtil.isEmpty((Object)jsonStr)) {
            return null;
        }
        try {
            Map map = (Map)this.mapObjectMapper.readValue(jsonStr, Map.class);
            return map;
        }
        catch (JsonProcessingException e) {
            throw new SaJsonConvertException((Throwable)e);
        }
    }
}

