/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.same;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.exception.SameTokenInvalidException;
import cn.dev33.satoken.util.SaFoxUtil;

public class SaSameTemplate {
    public static final String SAME_TOKEN = "SA-SAME-TOKEN";

    public String getToken() {
        String currentToken = this.getTokenNh();
        if (SaFoxUtil.isEmpty(currentToken)) {
            currentToken = this.refreshToken();
        }
        return currentToken;
    }

    public boolean isValid(String token) {
        if (SaFoxUtil.isEmpty(token)) {
            return false;
        }
        return token.equals(this.getToken()) || token.equals(this.getPastTokenNh());
    }

    public void checkToken(String token) {
        if (!this.isValid(token)) {
            token = token == null ? "" : token;
            throw new SameTokenInvalidException("\u65e0\u6548Same-Token\uff1a" + token).setCode(10301);
        }
    }

    public void checkCurrentRequestToken() {
        this.checkToken(SaHolder.getRequest().getHeader(SAME_TOKEN));
    }

    public String refreshToken() {
        String sameToken = this.getTokenNh();
        if (!SaFoxUtil.isEmpty(sameToken)) {
            this.savePastToken(sameToken, this.getTokenTimeout());
        }
        String newSameToken = this.createToken();
        this.saveToken(newSameToken);
        return newSameToken;
    }

    public void saveToken(String token) {
        if (SaFoxUtil.isEmpty(token)) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingTokenSaveKey(), token, SaManager.getConfig().getSameTokenTimeout());
    }

    public void savePastToken(String token, long timeout) {
        if (SaFoxUtil.isEmpty(token)) {
            return;
        }
        SaManager.getSaTokenDao().set(this.splicingPastTokenSaveKey(), token, timeout);
    }

    public String getTokenNh() {
        return SaManager.getSaTokenDao().get(this.splicingTokenSaveKey());
    }

    public String getPastTokenNh() {
        return SaManager.getSaTokenDao().get(this.splicingPastTokenSaveKey());
    }

    public long getTokenTimeout() {
        return SaManager.getSaTokenDao().getTimeout(this.splicingTokenSaveKey());
    }

    public String createToken() {
        return SaFoxUtil.getRandomString(64);
    }

    public String splicingTokenSaveKey() {
        return SaManager.getConfig().getTokenName() + ":var:same-token";
    }

    public String splicingPastTokenSaveKey() {
        return SaManager.getConfig().getTokenName() + ":var:past-same-token";
    }
}

