/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.strategy;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.annotation.SaCheckDisable;
import cn.dev33.satoken.annotation.SaCheckHttpBasic;
import cn.dev33.satoken.annotation.SaCheckHttpDigest;
import cn.dev33.satoken.annotation.SaCheckLogin;
import cn.dev33.satoken.annotation.SaCheckOr;
import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaCheckSafe;
import cn.dev33.satoken.exception.RequestPathInvalidException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.fun.strategy.SaCheckElementAnnotationFunction;
import cn.dev33.satoken.fun.strategy.SaCheckMethodAnnotationFunction;
import cn.dev33.satoken.fun.strategy.SaCheckOrAnnotationFunction;
import cn.dev33.satoken.fun.strategy.SaCheckRequestPathFunction;
import cn.dev33.satoken.fun.strategy.SaCreateSessionFunction;
import cn.dev33.satoken.fun.strategy.SaCreateStpLogicFunction;
import cn.dev33.satoken.fun.strategy.SaCreateTokenFunction;
import cn.dev33.satoken.fun.strategy.SaGenerateUniqueTokenFunction;
import cn.dev33.satoken.fun.strategy.SaGetAnnotationFunction;
import cn.dev33.satoken.fun.strategy.SaHasElementFunction;
import cn.dev33.satoken.fun.strategy.SaIsAnnotationPresentFunction;
import cn.dev33.satoken.fun.strategy.SaRequestPathInvalidHandleFunction;
import cn.dev33.satoken.httpauth.basic.SaHttpBasicUtil;
import cn.dev33.satoken.httpauth.digest.SaHttpDigestUtil;
import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.ArrayList;
import java.util.UUID;

public final class SaStrategy {
    public static final SaStrategy instance = new SaStrategy();
    public SaCreateTokenFunction createToken = (loginId, loginType) -> {
        String tokenStyle;
        switch (tokenStyle = SaManager.getStpLogic(loginType).getConfigOrGlobal().getTokenStyle()) {
            case "uuid": {
                return UUID.randomUUID().toString();
            }
            case "simple-uuid": {
                return UUID.randomUUID().toString().replaceAll("-", "");
            }
            case "random-32": {
                return SaFoxUtil.getRandomString(32);
            }
            case "random-64": {
                return SaFoxUtil.getRandomString(64);
            }
            case "random-128": {
                return SaFoxUtil.getRandomString(128);
            }
            case "tik": {
                return SaFoxUtil.getRandomString(2) + "_" + SaFoxUtil.getRandomString(14) + "_" + SaFoxUtil.getRandomString(16) + "__";
            }
        }
        SaManager.getLog().warn("\u914d\u7f6e\u7684 tokenStyle \u503c\u65e0\u6548\uff1a{}\uff0c\u4ec5\u5141\u8bb8\u4ee5\u4e0b\u53d6\u503c: uuid\u3001simple-uuid\u3001random-32\u3001random-64\u3001random-128\u3001tik", tokenStyle);
        return UUID.randomUUID().toString();
    };
    public SaCreateSessionFunction createSession = sessionId -> new SaSession((String)sessionId);
    public SaHasElementFunction hasElement = (list, element) -> {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (list.contains(element)) {
            return true;
        }
        for (String patt : list) {
            if (!SaFoxUtil.vagueMatch(patt, element)) continue;
            return true;
        }
        return false;
    };
    public SaCheckMethodAnnotationFunction checkMethodAnnotation = method -> {
        SaStrategy.instance.checkElementAnnotation.accept(method.getDeclaringClass());
        SaStrategy.instance.checkElementAnnotation.accept(method);
    };
    public SaCheckElementAnnotationFunction checkElementAnnotation = element -> {
        SaCheckOr checkOr;
        SaCheckHttpDigest checkHttpDigest;
        SaCheckHttpBasic checkHttpBasic;
        SaCheckDisable checkDisable;
        SaCheckSafe checkSafe;
        SaCheckPermission checkPermission;
        SaCheckRole checkRole;
        SaCheckLogin checkLogin = (SaCheckLogin)SaStrategy.instance.getAnnotation.apply(element, SaCheckLogin.class);
        if (checkLogin != null) {
            SaManager.getStpLogic(checkLogin.type(), false).checkByAnnotation(checkLogin);
        }
        if ((checkRole = (SaCheckRole)SaStrategy.instance.getAnnotation.apply(element, SaCheckRole.class)) != null) {
            SaManager.getStpLogic(checkRole.type(), false).checkByAnnotation(checkRole);
        }
        if ((checkPermission = (SaCheckPermission)SaStrategy.instance.getAnnotation.apply(element, SaCheckPermission.class)) != null) {
            SaManager.getStpLogic(checkPermission.type(), false).checkByAnnotation(checkPermission);
        }
        if ((checkSafe = (SaCheckSafe)SaStrategy.instance.getAnnotation.apply(element, SaCheckSafe.class)) != null) {
            SaManager.getStpLogic(checkSafe.type(), false).checkByAnnotation(checkSafe);
        }
        if ((checkDisable = (SaCheckDisable)SaStrategy.instance.getAnnotation.apply(element, SaCheckDisable.class)) != null) {
            SaManager.getStpLogic(checkDisable.type(), false).checkByAnnotation(checkDisable);
        }
        if ((checkHttpBasic = (SaCheckHttpBasic)SaStrategy.instance.getAnnotation.apply(element, SaCheckHttpBasic.class)) != null) {
            SaHttpBasicUtil.check(checkHttpBasic.realm(), checkHttpBasic.account());
        }
        if ((checkHttpDigest = (SaCheckHttpDigest)SaStrategy.instance.getAnnotation.apply(element, SaCheckHttpDigest.class)) != null) {
            SaHttpDigestUtil.checkByAnnotation(checkHttpDigest);
        }
        if ((checkOr = (SaCheckOr)SaStrategy.instance.getAnnotation.apply(element, SaCheckOr.class)) != null) {
            SaStrategy.instance.checkOrAnnotation.accept(checkOr);
        }
    };
    public SaCheckOrAnnotationFunction checkOrAnnotation = at -> {
        SaCheckHttpDigest[] checkHttpDigestArray;
        SaCheckHttpBasic[] checkHttpBasicArray;
        SaCheckDisable[] checkDisableArray;
        SaCheckSafe[] checkSafeArray;
        SaCheckPermission[] checkPermissionArray;
        SaCheckRole[] checkRoleArray;
        SaCheckLogin[] checkLoginArray;
        ArrayList<SaTokenException> errorList = new ArrayList<SaTokenException>();
        for (SaCheckLogin item : checkLoginArray = at.login()) {
            try {
                SaManager.getStpLogic(item.type(), false).checkByAnnotation(item);
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        for (SaCheckRole item : checkRoleArray = at.role()) {
            try {
                SaManager.getStpLogic(item.type(), false).checkByAnnotation(item);
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        for (SaCheckPermission item : checkPermissionArray = at.permission()) {
            try {
                SaManager.getStpLogic(item.type(), false).checkByAnnotation(item);
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        for (SaCheckSafe item : checkSafeArray = at.safe()) {
            try {
                SaManager.getStpLogic(item.type(), false).checkByAnnotation(item);
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        for (SaCheckDisable item : checkDisableArray = at.disable()) {
            try {
                SaManager.getStpLogic(item.type(), false).checkByAnnotation(item);
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        for (SaCheckHttpBasic item : checkHttpBasicArray = at.httpBasic()) {
            try {
                SaHttpBasicUtil.check(item.realm(), item.account());
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        for (SaCheckHttpDigest item : checkHttpDigestArray = at.httpDigest()) {
            try {
                SaHttpDigestUtil.checkByAnnotation(item);
                return;
            }
            catch (SaTokenException e) {
                errorList.add(e);
            }
        }
        if (errorList.size() != 0) {
            throw (SaTokenException)errorList.get(0);
        }
    };
    public SaGetAnnotationFunction getAnnotation = (element, annotationClass) -> element.getAnnotation(annotationClass);
    public SaIsAnnotationPresentFunction isAnnotationPresent = (method, annotationClass) -> SaStrategy.instance.getAnnotation.apply(method, annotationClass) != null || SaStrategy.instance.getAnnotation.apply(method.getDeclaringClass(), annotationClass) != null;
    public SaGenerateUniqueTokenFunction generateUniqueToken = (elementName, maxTryTimes, createTokenFunction, checkTokenFunction) -> {
        int i = 1;
        while (true) {
            String token = (String)createTokenFunction.get();
            if (maxTryTimes == -1) {
                return token;
            }
            if (((Boolean)checkTokenFunction.apply(token)).booleanValue()) {
                return token;
            }
            if (i >= maxTryTimes) {
                throw new SaTokenException(elementName + " \u751f\u6210\u5931\u8d25\uff0c\u5df2\u5c1d\u8bd5" + i + "\u6b21\uff0c\u751f\u6210\u7b97\u6cd5\u8fc7\u4e8e\u7b80\u5355\u6216\u8d44\u6e90\u6c60\u5df2\u8017\u5c3d");
            }
            ++i;
        }
    };
    public SaCreateStpLogicFunction createStpLogic = loginType -> new StpLogic((String)loginType);
    public static String[] INVALID_CHARACTER = new String[]{"//", "\\", "%2e", "%2E", "%2f", "%2F", "%5c", "%5C", "%25"};
    public SaCheckRequestPathFunction checkRequestPath = (requestPath, extArg1, extArg2) -> {
        if (requestPath == null) {
            throw new RequestPathInvalidException("\u975e\u6cd5\u8bf7\u6c42\uff1anull", null);
        }
        for (String item : INVALID_CHARACTER) {
            if (!requestPath.contains(item)) continue;
            throw new RequestPathInvalidException("\u975e\u6cd5\u8bf7\u6c42\uff1a" + requestPath, requestPath);
        }
        if (requestPath.contains("/.") || requestPath.contains("\\.")) {
            throw new RequestPathInvalidException("\u975e\u6cd5\u8bf7\u6c42\uff1a" + requestPath, requestPath);
        }
    };
    public SaRequestPathInvalidHandleFunction requestPathInvalidHandle = null;
    @Deprecated
    public static final SaStrategy me = instance;

    private SaStrategy() {
    }

    public SaStrategy setCreateToken(SaCreateTokenFunction createToken) {
        this.createToken = createToken;
        return this;
    }

    public SaStrategy setCreateSession(SaCreateSessionFunction createSession) {
        this.createSession = createSession;
        return this;
    }

    public SaStrategy setHasElement(SaHasElementFunction hasElement) {
        this.hasElement = hasElement;
        return this;
    }

    public SaStrategy setCheckMethodAnnotation(SaCheckMethodAnnotationFunction checkMethodAnnotation) {
        this.checkMethodAnnotation = checkMethodAnnotation;
        return this;
    }

    public SaStrategy setCheckElementAnnotation(SaCheckElementAnnotationFunction checkElementAnnotation) {
        this.checkElementAnnotation = checkElementAnnotation;
        return this;
    }

    public SaStrategy setCheckOrAnnotation(SaCheckOrAnnotationFunction checkOrAnnotation) {
        this.checkOrAnnotation = checkOrAnnotation;
        return this;
    }

    public SaStrategy setGetAnnotation(SaGetAnnotationFunction getAnnotation) {
        this.getAnnotation = getAnnotation;
        return this;
    }

    public SaStrategy setIsAnnotationPresent(SaIsAnnotationPresentFunction isAnnotationPresent) {
        this.isAnnotationPresent = isAnnotationPresent;
        return this;
    }

    public SaStrategy setGenerateUniqueToken(SaGenerateUniqueTokenFunction generateUniqueToken) {
        this.generateUniqueToken = generateUniqueToken;
        return this;
    }

    public SaStrategy setCreateStpLogic(SaCreateStpLogicFunction createStpLogic) {
        this.createStpLogic = createStpLogic;
        return this;
    }
}

