/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.utils;

import cn.dalgen.mybatis.AbstractBaseMojo;
import cn.dalgen.mybatis.ddl.DalddlMojo;
import cn.dalgen.mybatis.gen.DalgenMojo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.IOUtil;

public class ConfInit {
    public static final String NEED_COPY_CONFIG = "dalgen/config/";
    public static final String NEED_COPY_TEMPLATES = "dalgen/templates/";
    public static final String NEED_COPY_EXT = "dalgen/ext/";
    public static final String NEED_DDL_COPY_CONFIG = "dalddl/config/";
    public static final String NEED_DDL_COPY_TEMPLATES = "dalddl/templates/";
    public static final String NEED_DDL_COPY_EXT = "dalddl/ext/";
    private static JarFile jarFile;

    public static void copyConfigFile(AbstractBaseMojo dalgenMojo) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String fileName = jarEntry.getName();
            if (dalgenMojo instanceof DalgenMojo && StringUtils.startsWithIgnoreCase((String)fileName, (String)NEED_COPY_CONFIG)) {
                if (StringUtils.equalsIgnoreCase((String)fileName, (String)"dalgen/config/config.xml")) {
                    if (!dalgenMojo.getConfig().exists()) {
                        dalgenMojo.getLog().info((CharSequence)"\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5f00\u59cb");
                        ConfInit.copyAndOverWriteFile(fileName, dalgenMojo.getConfig());
                        dalgenMojo.getLog().info((CharSequence)("\u521d\u59cb\u5316\u5b8c\u6210,\u4e0b\u4e00\u6b65\u5230 " + StringUtils.substringAfter((String)dalgenMojo.getConfig().getAbsolutePath(), (String)dalgenMojo.getProject().getBasedir().getAbsolutePath()) + " \u4e2d\u914d\u7f6e\u6570\u636e\u6e90"));
                        System.exit(0);
                    }
                } else {
                    ConfInit.copyAndOverWriteFile(fileName, new File(dalgenMojo.getConfig().getParent() + jarEntry.getName().substring(NEED_COPY_CONFIG.length() - 1)));
                }
            }
            if (!(dalgenMojo instanceof DalddlMojo) || !StringUtils.startsWithIgnoreCase((String)fileName, (String)NEED_DDL_COPY_CONFIG)) continue;
            if (StringUtils.equalsIgnoreCase((String)fileName, (String)"dalddl/config/config.xml")) {
                if (dalgenMojo.getConfig().exists()) continue;
                dalgenMojo.getLog().info((CharSequence)"\u521d\u59cb\u5316\u914d\u7f6e\u4fe1\u606f\u5f00\u59cb");
                ConfInit.copyAndOverWriteFile(fileName, dalgenMojo.getConfig());
                dalgenMojo.getLog().info((CharSequence)("\u521d\u59cb\u5316\u5b8c\u6210,\u4e0b\u4e00\u6b65\u5230 " + StringUtils.substringAfter((String)dalgenMojo.getConfig().getAbsolutePath(), (String)dalgenMojo.getProject().getBasedir().getAbsolutePath()) + " \u4e2d\u914d\u7f6e\u6570\u636e\u6e90"));
                System.exit(0);
                continue;
            }
            ConfInit.copyAndOverWriteFile(fileName, new File(dalgenMojo.getConfig().getParent() + jarEntry.getName().substring(NEED_DDL_COPY_CONFIG.length() - 1)));
        }
    }

    public static void copyTemplateFile(AbstractBaseMojo dalgenMojo) {
        Enumeration<JarEntry> entries = jarFile.entries();
        boolean _copyTemplate = dalgenMojo.isCopyTemplate();
        if (!_copyTemplate && StringUtils.startsWithIgnoreCase((String)dalgenMojo.getTemplateDirectory().getAbsolutePath(), (String)dalgenMojo.getProject().getBuild().getOutputDirectory())) {
            _copyTemplate = true;
        }
        if (_copyTemplate) {
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String fileName = jarEntry.getName();
                if (dalgenMojo instanceof DalgenMojo && StringUtils.startsWithIgnoreCase((String)fileName, (String)NEED_COPY_TEMPLATES)) {
                    ConfInit.copyAndOverWriteFile(fileName, new File(dalgenMojo.getTemplateDirectory().getAbsolutePath() + jarEntry.getName().substring(NEED_COPY_TEMPLATES.length() - 1)));
                }
                if (!(dalgenMojo instanceof DalddlMojo) || !StringUtils.startsWithIgnoreCase((String)fileName, (String)NEED_DDL_COPY_TEMPLATES)) continue;
                ConfInit.copyAndOverWriteFile(fileName, new File(dalgenMojo.getTemplateDirectory().getAbsolutePath() + jarEntry.getName().substring(NEED_DDL_COPY_TEMPLATES.length() - 1)));
            }
        }
    }

    public static void copyExtFile(AbstractBaseMojo dalgenMojo) {
        if (!dalgenMojo.getTemplateExtDirectory().exists()) {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String fileName = jarEntry.getName();
                if (dalgenMojo instanceof DalgenMojo && StringUtils.startsWithIgnoreCase((String)fileName, (String)NEED_COPY_EXT)) {
                    ConfInit.copyAndOverWriteFile(fileName, new File(dalgenMojo.getTemplateExtDirectory().getAbsolutePath() + jarEntry.getName().substring(NEED_COPY_EXT.length() - 1)));
                }
                if (!(dalgenMojo instanceof DalddlMojo) || !StringUtils.startsWithIgnoreCase((String)fileName, (String)NEED_DDL_COPY_EXT)) continue;
                ConfInit.copyAndOverWriteFile(fileName, new File(dalgenMojo.getTemplateExtDirectory().getAbsolutePath() + jarEntry.getName().substring(NEED_DDL_COPY_EXT.length() - 1)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndOverWriteFile(String soureName, File outFile) {
        block8: {
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            if (StringUtils.indexOf((String)soureName, (char)'.') == -1) {
                return;
            }
            BufferedReader reader = null;
            BufferedWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(ConfInit.class.getResourceAsStream("/" + soureName), "UTF-8"));
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.write("\n");
                }
                writer.flush();
                IOUtil.close((Reader)reader);
            }
            catch (Exception e) {
                System.out.println("======");
                break block8;
            }
            finally {
                IOUtil.close(reader);
                IOUtil.close(writer);
            }
            IOUtil.close((Writer)writer);
        }
    }

    static {
        try {
            jarFile = new JarFile(URLDecoder.decode(ConfInit.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

