/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model;

import cn.dalgen.mybatis.gen.model.config.DeleteColumn;
import cn.dalgen.mybatis.gen.model.db.DataBase;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class Config {
    private Map<String, DataBase> dataSourceMap = Maps.newHashMap();
    private Map<String, String> typeMap = Maps.newHashMap();
    private List<String> splitTableSuffixs = Lists.newArrayList();
    private Map<String, String> indexReplaceMap = Maps.newHashMap();
    private Map<String, String> outpathMap = Maps.newHashMap();
    private Map<String, String> extParamMap = Maps.newHashMap();
    private DeleteColumn deleteColumn;

    public Config() {
        this.extParamMap.put("Repository", "true");
        this.extParamMap.put("DoMapperName", "DO");
        this.extParamMap.put("EntityNaming", "[EntityName]DO");
        this.extParamMap.put("XMLMapperNaming", "[EntityName]DOMapper");
        this.extParamMap.put("MapperInterfaceNaming", "[EntityName]DOMapper");
        this.extParamMap.put("DaoNaming", "[EntityName]DAO");
        this.extParamMap.put("sqlName", "lower");
    }

    public void addDataSource(DataBase dataBase) {
        this.dataSourceMap.put(dataBase.getName(), dataBase);
    }

    public Map<String, DataBase> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public Map<String, String> getTypeMap() {
        return this.typeMap;
    }

    public void addTypeMap(String type, String to) {
        this.typeMap.put(type, to);
    }

    public List<String> getSplitTableSuffixs() {
        return this.splitTableSuffixs;
    }

    public void addSplitTableSuffix(String splitTableSuffix) {
        this.splitTableSuffixs.add(splitTableSuffix);
    }

    public String getOutpath(String name) {
        String path = this.outpathMap.get(name);
        if (StringUtils.isBlank((String)path)) {
            path = this.outpathMap.get("default");
        }
        return path;
    }

    public boolean containCmd(String cmdName) {
        return this.outpathMap.containsKey(cmdName);
    }

    public List<String> cmdNames() {
        return Lists.newArrayList(this.outpathMap.keySet());
    }

    public void addOutpath(String name, String path) {
        this.outpathMap.put(name, path == null ? "" : path);
    }

    public void addExtParam(String key, String value) {
        this.extParamMap.put(key, value);
    }

    public String getExtParam(String key) {
        return this.extParamMap.get(key);
    }

    public DeleteColumn getDeleteColumn() {
        return this.deleteColumn;
    }

    public void setDeleteColumn(DeleteColumn deleteColumn) {
        this.deleteColumn = deleteColumn;
    }

    public String dealIndexName(String indexName) {
        Validate.notEmpty((String)indexName, (String)"\u7d22\u5f15\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        indexName = StringUtils.upperCase((String)indexName);
        for (Map.Entry<String, String> entry : this.indexReplaceMap.entrySet()) {
            if (!StringUtils.startsWith((String)indexName, (String)entry.getKey())) continue;
            return StringUtils.replace((String)indexName, (String)entry.getKey(), (String)entry.getValue(), (int)1);
        }
        return indexName;
    }

    public void addIndexReplaceMap(String indexPre, String replaceStr) {
        if (StringUtils.isBlank((String)replaceStr)) {
            replaceStr = "";
        } else if (!StringUtils.endsWith((String)replaceStr, (String)"_")) {
            replaceStr = replaceStr + "_";
        }
        if (!StringUtils.endsWith((String)indexPre, (String)"_")) {
            indexPre = indexPre + "_";
        }
        this.indexReplaceMap.put(StringUtils.upperCase((String)indexPre), StringUtils.upperCase((String)replaceStr));
    }
}

