/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen;

import cn.dalgen.mybatis.AbstractBaseMojo;
import cn.dalgen.mybatis.gen.dataloaders.DalgenLoader;
import cn.dalgen.mybatis.gen.dataloaders.DalgenTbLoader;
import cn.dalgen.mybatis.gen.enums.SystemEnum;
import cn.dalgen.mybatis.gen.utils.CmdUtil;
import cn.dalgen.mybatis.gen.utils.ConfInit;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import cn.dalgen.mybatis.gen.utils.SysUtil;
import com.google.common.collect.Lists;
import fmpp.ProcessingException;
import fmpp.ProgressListener;
import fmpp.progresslisteners.ConsoleProgressListener;
import fmpp.setting.SettingException;
import fmpp.setting.Settings;
import fmpp.tdd.EvalException;
import fmpp.tdd.Interpreter;
import fmpp.util.MiscUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="gen")
public class DalgenMojo
extends AbstractBaseMojo {
    private static final String DEFAULT_ERROR_MSG = "\"%s\" is a required parameter. ";
    private CmdUtil cmdUtil = new CmdUtil();
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/src/")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}/templates/")
    private File templateDirectory;
    @Parameter(defaultValue="dalgen/ext/")
    private File templateExtDirectory;
    @Parameter(defaultValue="dalgen/config/config.xml")
    private File config;
    @Parameter(defaultValue="true")
    private boolean copyTemplate;
    private boolean testF = false;

    public DalgenMojo() {
    }

    public DalgenMojo(File outputDirectory, File templateDirectory, File templateExtDirectory, File config, MavenProject project, boolean testF) {
        this.outputDirectory = outputDirectory;
        this.templateDirectory = templateDirectory;
        this.templateExtDirectory = templateExtDirectory;
        this.config = config;
        this.project = project;
        this.testF = testF;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.configInit(this.testF);
        List buildPlugins = this.project.getBuildPlugins();
        for (Plugin plugin : buildPlugins) {
            if (!"cn.dalgen.plugins".equals(plugin.getGroupId()) || !"mybatis-maven-plugin".equals(plugin.getArtifactId())) continue;
            CmdUtil.DALGEN_VERSION = plugin.getVersion();
            break;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            ConfigUtil.readConfig(this.config);
            String _cmd = this.cmdUtil.consoleInput();
            if (StringUtils.equalsIgnoreCase((String)"Q", (String)_cmd)) {
                this.getLog().info((CharSequence)"dalgen success");
                return;
            }
            if (StringUtils.equalsIgnoreCase((String)"q", (String)_cmd)) {
                this.getLog().info((CharSequence)"dalgen \u653e\u5f03\u751f\u6210");
                return;
            }
            if (ConfigUtil.getConfig().containCmd(_cmd)) {
                ConfigUtil.setCmd("*");
            }
            ConfigUtil.dalgenPath = this.config.getParentFile().getParent();
            if (!StringUtils.endsWith((String)"*", (String)ConfigUtil.getCmd())) {
                this.executeInit();
            }
            this.executeGen(_cmd);
            if (StringUtils.endsWith((String)"*", (String)ConfigUtil.getCmd())) {
                this.executeExtGen(_cmd);
            }
            this.getLog().info((CharSequence)"dalgen \u6267\u884c\u751f\u6210");
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)MiscUtil.causeMessages((Throwable)e));
            throw new MojoFailureException(MiscUtil.causeMessages((Throwable)e), (Throwable)e);
        }
    }

    private void configInit(boolean testF) throws MojoExecutionException, MojoFailureException {
        if (testF) {
            return;
        }
        if (this.project == null) {
            throw new MojoExecutionException(String.format(DEFAULT_ERROR_MSG, "project") + "This plugin can be used only inside a project.");
        }
        ConfInit.copyConfigFile(this);
        ConfInit.copyTemplateFile(this);
        ConfInit.copyExtFile(this);
    }

    private void executeInit() throws SettingException, IOException, EvalException, ProcessingException {
        Settings settings = new Settings(new File("."));
        settings.set("sourceRoot", (Object)this.templateDirectory.getAbsolutePath());
        settings.set("outputRoot", (Object)this.config.getParentFile().getParent());
        settings.set("outputEncoding", (Object)"UTF-8");
        settings.set("sourceEncoding", (Object)"UTF-8");
        ArrayList ignoreList = Lists.newArrayList((Object[])new String[]{"ignore(.DS_Store)", "ignore(*/.DS_Store)", "ignore(config/*.*)", "ignore(lib/*.*)", "ignore(css/*.*)", "ignore(dalgen/*.*)"});
        for (String cmd : ConfigUtil.getConfig().cmdNames()) {
            ignoreList.add("ignore(" + cmd + "/*.*)");
        }
        settings.set("data", (Object)("dalgen: " + DalgenTbLoader.class.getName() + "(),project:1"));
        settings.set("modes", (Object)Interpreter.evalAsSequence((String)StringUtils.join((Collection)ignoreList, (String)",")));
        settings.addProgressListener((ProgressListener)new ConsoleProgressListener());
        settings.execute();
        this.getLog().info((CharSequence)"\u521d\u59cb\u5316\u8868\u5b8c\u6210");
    }

    private void executeGen(String cmdName) throws SettingException, IOException, EvalException, ProcessingException {
        Settings settings = new Settings(new File("."));
        settings.set("sourceRoot", (Object)this.templateDirectory.getAbsolutePath());
        String outPath = DalgenMojo.getOutPath(cmdName, this.outputDirectory.getAbsolutePath());
        File outPathFile = new File(outPath);
        if (!outPathFile.exists()) {
            outPathFile.mkdirs();
        }
        settings.set("outputRoot", (Object)outPath);
        settings.set("outputEncoding", (Object)"UTF-8");
        settings.set("sourceEncoding", (Object)"UTF-8");
        ArrayList ignoreList = Lists.newArrayList((Object[])new String[]{"ignore(.DS_Store)", "ignore(*/.DS_Store)", "ignore(config/*.*)", "ignore(lib/*.*)", "ignore(css/*.*)", "ignore(init/*.*)"});
        for (String cmd : ConfigUtil.getConfig().cmdNames()) {
            if (StringUtils.equals((String)cmd, (String)cmdName)) {
                ignoreList.add("ignore(dalgen/*.*)");
                continue;
            }
            ignoreList.add("ignore(" + cmd + "/*.*)");
        }
        settings.set("data", (Object)("dalgen: " + DalgenLoader.class.getName() + "()"));
        settings.set("modes", (Object)Interpreter.evalAsSequence((String)StringUtils.join((Collection)ignoreList, (String)",")));
        settings.addProgressListener((ProgressListener)new ConsoleProgressListener());
        settings.execute();
    }

    private void executeExtGen(String cmdName) throws SettingException, IOException, EvalException, ProcessingException {
        if (!this.templateExtDirectory.exists()) {
            return;
        }
        Settings settings = new Settings(new File("."));
        settings.set("sourceRoot", (Object)this.templateExtDirectory.getAbsolutePath());
        String outPath = DalgenMojo.getOutPath(cmdName, this.outputDirectory.getAbsolutePath());
        File outPathFile = new File(outPath);
        if (!outPathFile.exists()) {
            outPathFile.mkdirs();
        }
        settings.set("outputRoot", (Object)outPath);
        settings.set("outputEncoding", (Object)"UTF-8");
        settings.set("sourceEncoding", (Object)"UTF-8");
        ArrayList ignoreList = Lists.newArrayList((Object[])new String[]{"ignore(.DS_Store)", "ignore(*/.DS_Store)", "ignore(config/*.*)", "ignore(lib/*.*)", "ignore(css/*.*)", "ignore(init/*.*)"});
        for (String cmd : ConfigUtil.getConfig().cmdNames()) {
            if (StringUtils.equals((String)cmd, (String)cmdName)) {
                ignoreList.add("ignore(dalgen/*.*)");
                continue;
            }
            ignoreList.add("ignore(" + cmd + "/*.*)");
        }
        settings.set("data", (Object)("dalgen: " + DalgenLoader.class.getName() + "()"));
        settings.set("modes", (Object)Interpreter.evalAsSequence((String)StringUtils.join((Collection)ignoreList, (String)",")));
        settings.addProgressListener((ProgressListener)new ConsoleProgressListener());
        settings.execute();
    }

    private static String getOutPath(String cmdName, String outputPath) throws SettingException {
        String outpath = ConfigUtil.getConfig().getOutpath(cmdName);
        if (StringUtils.isNotBlank((String)outpath)) {
            if (outpath.contains(":") || outpath.startsWith("/")) {
                if (SystemEnum.Window == SysUtil.getSystem()) {
                    return outpath;
                }
                return outpath;
            }
            String absolutePath = StringUtils.replace((String)outputPath, (String)"\\", (String)"/");
            if (outpath.startsWith("../")) {
                int i;
                String[] paths = StringUtils.split((String)absolutePath, (String)"/");
                String[] splits = StringUtils.split((String)outpath, (String)"/");
                int cnt = 0;
                for (String split : splits) {
                    if (!StringUtils.equals((String)"..", (String)split)) continue;
                    ++cnt;
                }
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < paths.length - cnt; ++i) {
                    sb.append("/").append(paths[i]);
                }
                for (i = cnt; i < splits.length; ++i) {
                    sb.append("/").append(splits[i]);
                }
                return sb.toString();
            }
            return absolutePath + "/" + outpath;
        }
        return outputPath;
    }

    public void setCmdUtil(CmdUtil cmdUtil) {
        this.cmdUtil = cmdUtil;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public File getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public File getConfig() {
        return this.config;
    }

    @Override
    public boolean isCopyTemplate() {
        return this.copyTemplate;
    }

    @Override
    public File getTemplateExtDirectory() {
        return this.templateExtDirectory;
    }
}

