/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.ddl;

import cn.dalgen.mybatis.AbstractBaseMojo;
import cn.dalgen.mybatis.gen.utils.CmdUtil;
import cn.dalgen.mybatis.gen.utils.ConfInit;
import cn.dalgen.mybatis.gen.utils.ConfigUtil;
import fmpp.util.MiscUtil;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="ddl")
public class DalddlMojo
extends AbstractBaseMojo {
    private static final String DEFAULT_ERROR_MSG = "\"%s\" is a required parameter. ";
    private CmdUtil cmdUtil = new CmdUtil();
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/src/")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}/templates/")
    private File templateDirectory;
    @Parameter(defaultValue="dalgen/config/config.xml")
    private File config;
    @Parameter(defaultValue="true")
    private boolean copyTemplate;
    private boolean testF = false;

    public DalddlMojo() {
    }

    public DalddlMojo(File outputDirectory, File templateDirectory, File config, MavenProject project, boolean testF) {
        this.outputDirectory = outputDirectory;
        this.templateDirectory = templateDirectory;
        this.config = config;
        this.project = project;
        this.testF = testF;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List buildPlugins = this.project.getBuildPlugins();
        for (Plugin plugin : buildPlugins) {
            if (!"cn.dalgen.plugins".equals(plugin.getGroupId()) || !"mybatis-maven-plugin".equals(plugin.getArtifactId())) continue;
            CmdUtil.DALGEN_VERSION = plugin.getVersion();
            break;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            ConfigUtil.readConfig(this.config);
            String _cmd = this.cmdUtil.consoleInput();
            if (StringUtils.equalsIgnoreCase((String)"Q", (String)_cmd)) {
                this.getLog().info((CharSequence)"dalgen success");
                return;
            }
            this.getLog().info((CharSequence)"dalgen \u6267\u884c\u751f\u6210");
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)MiscUtil.causeMessages((Throwable)e));
            throw new MojoFailureException(MiscUtil.causeMessages((Throwable)e), (Throwable)e);
        }
    }

    private void configInit(boolean testF) throws MojoExecutionException, MojoFailureException {
        if (testF) {
            return;
        }
        if (this.project == null) {
            throw new MojoExecutionException(String.format(DEFAULT_ERROR_MSG, "project") + "This plugin can be used only inside a project.");
        }
        ConfInit.copyConfigFile(this);
        ConfInit.copyTemplateFile(this);
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public File getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public File getTemplateExtDirectory() {
        return null;
    }

    @Override
    public File getConfig() {
        return this.config;
    }

    @Override
    public boolean isCopyTemplate() {
        return this.copyTemplate;
    }
}

