/*
 * Decompiled with CFR 0.152.
 */
package cn.craccd.mongoHelper.utils;

import cn.craccd.mongoHelper.bean.InitValue;
import cn.craccd.mongoHelper.bean.Page;
import cn.craccd.mongoHelper.utils.CriteriaWrapper;
import cn.craccd.mongoHelper.utils.FormatUtils;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service(value="mongoHelper")
public class MongoHelper
implements ApplicationContextAware {
    ApplicationContext applicationContext;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    MongoConverter mongoConverter;
    QueryMapper queryMapper;
    UpdateMapper updateMapper;
    @Value(value="${spring.data.mongodb.print:false}")
    Boolean print;
    @Value(value="${spring.data.mongodb.uri}")
    String uri;
    MongoTemplate mongoTemplatePrimary;
    MongoTemplate mongoTemplateSecondary;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.applicationContext == null) {
            this.applicationContext = applicationContext;
        }
    }

    @PostConstruct
    public void init() {
        if (this.uri.contains("replicaSet")) {
            this.mongoTemplatePrimary = (MongoTemplate)this.applicationContext.getBean(MongoTemplate.class);
            if (this.uri.contains("readPreference")) {
                String[] uriArray = this.uri.split("&");
                String value = null;
                for (String u : uriArray) {
                    if (!u.contains("readPreference")) continue;
                    String[] a = u.split("=");
                    if (a.length <= 1) break;
                    value = a[1];
                    break;
                }
                if (value != null) {
                    this.uri = this.uri.replace(value, "SecondaryPreferred");
                }
            } else {
                this.uri = this.uri + "&readPreference=SecondaryPreferred";
            }
            this.mongoTemplateSecondary = new MongoTemplate((MongoDatabaseFactory)new SimpleMongoClientDbFactory(this.uri));
        } else {
            this.mongoTemplatePrimary = (MongoTemplate)this.applicationContext.getBean(MongoTemplate.class);
            this.mongoTemplateSecondary = (MongoTemplate)this.applicationContext.getBean(MongoTemplate.class);
        }
        this.queryMapper = new QueryMapper(this.mongoConverter);
        this.updateMapper = new UpdateMapper(this.mongoConverter);
    }

    private void logQuery(Class<?> clazz, Query query) {
        if (this.print.booleanValue()) {
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
            Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
            Document mappedField = this.queryMapper.getMappedObject((Bson)query.getFieldsObject(), entity);
            Document mappedSort = this.queryMapper.getMappedObject((Bson)query.getSortObject(), entity);
            String log = "\ndb." + StrUtil.lowerFirst((CharSequence)clazz.getSimpleName()) + ".find(";
            log = log + FormatUtils.bson(mappedQuery.toJson()) + ")";
            if (!query.getFieldsObject().isEmpty()) {
                log = log + ".projection(";
                log = log + FormatUtils.bson(mappedField.toJson()) + ")";
            }
            if (query.isSorted()) {
                log = log + ".sort(";
                log = log + FormatUtils.bson(mappedSort.toJson()) + ")";
            }
            if ((long)query.getLimit() != 0L) {
                log = log + ".limit(" + query.getLimit() + ")";
            }
            if (query.getSkip() != 0L) {
                log = log + ".skip(" + query.getSkip() + ")";
            }
            log = log + ";";
            this.logger.info(log);
        }
    }

    private void logCount(Class<?> clazz, Query query) {
        if (this.print.booleanValue()) {
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
            Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
            String log = "\ndb." + StrUtil.lowerFirst((CharSequence)clazz.getSimpleName()) + ".find(";
            log = log + FormatUtils.bson(mappedQuery.toJson()) + ")";
            log = log + ".count();";
            this.logger.info(log);
        }
    }

    private void logDelete(Class<?> clazz, Query query) {
        if (this.print.booleanValue()) {
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
            Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
            String log = "\ndb." + StrUtil.lowerFirst((CharSequence)clazz.getSimpleName()) + ".remove(";
            log = log + FormatUtils.bson(mappedQuery.toJson()) + ")";
            log = log + ";";
            this.logger.info(log);
        }
    }

    private void logUpdate(Class<?> clazz, Query query, Update update, boolean multi) {
        if (this.print.booleanValue()) {
            MongoPersistentEntity entity = (MongoPersistentEntity)this.mongoConverter.getMappingContext().getPersistentEntity(clazz);
            Document mappedQuery = this.queryMapper.getMappedObject((Bson)query.getQueryObject(), entity);
            Document mappedUpdate = this.updateMapper.getMappedObject((Bson)update.getUpdateObject(), entity);
            String log = "\ndb." + StrUtil.lowerFirst((CharSequence)clazz.getSimpleName()) + ".update(";
            log = log + FormatUtils.bson(mappedQuery.toJson()) + ",";
            log = log + FormatUtils.bson(mappedUpdate.toJson()) + ",";
            log = log + FormatUtils.bson("{multi:" + multi + "})");
            log = log + ";";
            this.logger.info(log);
        }
    }

    private void logSave(Object object) {
        if (this.print.booleanValue()) {
            String log = "\ndb." + StrUtil.lowerFirst((CharSequence)object.getClass().getSimpleName()) + ".save(";
            log = log + JSONUtil.toJsonPrettyStr((Object)object);
            log = log + ");";
            this.logger.info(log);
        }
    }

    private void logSave(List<?> list) {
        if (this.print.booleanValue() && list.size() > 0) {
            Object object = list.get(0);
            String log = "\ndb." + StrUtil.lowerFirst((CharSequence)object.getClass().getSimpleName()) + ".save(";
            log = log + JSONUtil.toJsonPrettyStr(list);
            log = log + ");";
            this.logger.info(log);
        }
    }

    public void insertOrUpdate(Object object) {
        Object objectOrg;
        Long time = System.currentTimeMillis();
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        Object object2 = objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? this.getMongoTemplate().findById((Object)id, object.getClass()) : null;
        if (objectOrg == null) {
            if (ReflectUtil.getField(object.getClass(), (String)"createTime") != null) {
                ReflectUtil.setFieldValue((Object)object, (String)"createTime", (Object)time);
            }
            if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                ReflectUtil.setFieldValue((Object)object, (String)"updateTime", (Object)time);
            }
            this.setDefaultVaule(object);
            ReflectUtil.setFieldValue((Object)object, (String)"id", null);
            this.logSave(object);
            this.mongoTemplatePrimary.save(object);
        } else {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
                if (field.getName().equals("id") || ReflectUtil.getFieldValue((Object)object, (Field)field) == null) continue;
                ReflectUtil.setFieldValue((Object)objectOrg, (Field)field, (Object)ReflectUtil.getFieldValue((Object)object, (Field)field));
            }
            if (ReflectUtil.getField(objectOrg.getClass(), (String)"updateTime") != null) {
                ReflectUtil.setFieldValue((Object)objectOrg, (String)"updateTime", (Object)time);
            }
            this.logSave(objectOrg);
            this.mongoTemplatePrimary.save(objectOrg);
        }
    }

    public void insert(Object object) {
        Object objectOrg;
        String id = (String)ReflectUtil.getFieldValue((Object)object, (String)"id");
        Object object2 = objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? this.getMongoTemplate().findById((Object)id, object.getClass()) : null;
        if (objectOrg != null) {
            ReflectUtil.setFieldValue((Object)object, (String)"id", null);
        }
        this.insertOrUpdate(object);
    }

    public <T> void insertAll(List<T> list) {
        Long time = System.currentTimeMillis();
        HashMap<String, Object> idMap = new HashMap<String, Object>();
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, (String)"id") == null) continue;
            String id = (String)ReflectUtil.getFieldValue(object, (String)"id");
            Object objectOrg = StrUtil.isNotEmpty((CharSequence)id) ? this.getMongoTemplate().findById((Object)id, object.getClass()) : null;
            idMap.put((String)ReflectUtil.getFieldValue(object, (String)"id"), objectOrg);
        }
        for (T object : list) {
            if (ReflectUtil.getFieldValue(object, (String)"id") != null && idMap.get((String)ReflectUtil.getFieldValue(object, (String)"id")) != null) {
                ReflectUtil.setFieldValue(object, (String)"id", null);
            }
            if (ReflectUtil.getField(object.getClass(), (String)"createTime") != null) {
                ReflectUtil.setFieldValue(object, (String)"createTime", (Object)time);
            }
            if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
                ReflectUtil.setFieldValue(object, (String)"updateTime", (Object)time);
            }
            this.setDefaultVaule(object);
        }
        this.logSave(list);
        this.mongoTemplatePrimary.insertAll(list);
    }

    public void updateById(Object object) {
        if (StrUtil.isEmpty((CharSequence)((String)ReflectUtil.getFieldValue((Object)object, (String)"id")))) {
            return;
        }
        this.insertOrUpdate(object);
    }

    public void updateAllColumnById(Object object) {
        if (StrUtil.isEmpty((CharSequence)((String)ReflectUtil.getFieldValue((Object)object, (String)"id")))) {
            return;
        }
        Long time = System.currentTimeMillis();
        if (ReflectUtil.getField(object.getClass(), (String)"updateTime") != null) {
            ReflectUtil.setFieldValue((Object)object, (String)"updateTime", (Object)time);
        }
        this.logSave(object);
        this.mongoTemplatePrimary.save(object);
    }

    public void deleteById(String id, Class<?> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return;
        }
        this.deleteByQuery(Criteria.where((String)"id").is((Object)id), clazz);
    }

    public void deleteByIds(List<String> ids, Class<?> clazz) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        this.deleteByQuery(Criteria.where((String)"id").in(ids), clazz);
    }

    public void deleteByQuery(Query query, Class<?> clazz) {
        this.logDelete(clazz, query);
        this.mongoTemplatePrimary.remove(query, clazz);
    }

    public void deleteByQuery(Criteria criteria, Class<?> clazz) {
        this.deleteByQuery(new Query((CriteriaDefinition)criteria), clazz);
    }

    public void deleteByQuery(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        this.deleteByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()), clazz);
    }

    private void setDefaultVaule(Object object) {
        Field[] fields;
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (!field.isAnnotationPresent(InitValue.class)) continue;
            InitValue defaultValue = field.getAnnotation(InitValue.class);
            String value = defaultValue.value();
            if (ReflectUtil.getFieldValue((Object)object, (Field)field) != null) continue;
            Class<?> type = field.getType();
            if (type.equals(String.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)value);
            }
            if (type.equals(Short.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Short.parseShort(value));
            }
            if (type.equals(Integer.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Integer.parseInt(value));
            }
            if (type.equals(Long.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Long.parseLong(value));
            }
            if (type.equals(Float.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Float.valueOf(Float.parseFloat(value)));
            }
            if (type.equals(Double.class)) {
                ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Double.parseDouble(value));
            }
            if (!type.equals(Boolean.class)) continue;
            ReflectUtil.setFieldValue((Object)object, (Field)field, (Object)Boolean.parseBoolean(value));
        }
    }

    public void updateFirst(Query query, Update update, Class<?> clazz) {
        this.logUpdate(clazz, query, update, false);
        this.mongoTemplatePrimary.updateFirst(query, (UpdateDefinition)update, clazz);
    }

    public void updateFirst(Criteria criteria, Update update, Class<?> clazz) {
        this.updateFirst(new Query((CriteriaDefinition)criteria), update, clazz);
    }

    public void updateFirst(CriteriaWrapper criteriaWrapper, Update update, Class<?> clazz) {
        this.updateFirst(new Query((CriteriaDefinition)criteriaWrapper.build()), update, clazz);
    }

    public void addCountById(String id, String property, Long count, Class<?> clazz) {
        Update update = new Update().inc(property, (Number)count);
        this.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)), update, clazz);
    }

    public void updateMulti(Query query, Update update, Class<?> clazz) {
        this.logUpdate(clazz, query, update, true);
        this.mongoTemplatePrimary.updateMulti(query, (UpdateDefinition)update, clazz);
    }

    public void updateMulti(Criteria criteria, Update update, Class<?> clazz) {
        this.updateMulti(new Query((CriteriaDefinition)criteria), update, clazz);
    }

    public void updateMulti(CriteriaWrapper criteriaWrapper, Update update, Class<?> clazz) {
        this.updateMulti(new Query((CriteriaDefinition)criteriaWrapper.build()), update, clazz);
    }

    private MongoTemplate getMongoTemplate() {
        try {
            if (TransactionAspectSupport.currentTransactionStatus() != null) {
                return this.mongoTemplatePrimary;
            }
        }
        catch (NoTransactionException e) {
            return this.mongoTemplateSecondary;
        }
        return this.mongoTemplateSecondary;
    }

    public Page findPage(Query query, Page page, Class<?> clazz) {
        MongoTemplate mongoTemplate = this.getMongoTemplate();
        Long count = mongoTemplate.count(query, clazz);
        query.skip((long)((page.getCurr() - 1) * page.getLimit()));
        query.limit(page.getLimit().intValue());
        if (!query.isSorted()) {
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        }
        this.logQuery(clazz, query);
        List list = mongoTemplate.find(query, clazz);
        page.setCount(count);
        page.setRecords(list);
        return page;
    }

    public Page findPage(Criteria criteria, Page page, Class<?> clazz) {
        return this.findPage(new Query((CriteriaDefinition)criteria), page, clazz);
    }

    public Page findPage(CriteriaWrapper criteriaWrapper, Page page, Class<?> clazz) {
        return this.findPage(new Query((CriteriaDefinition)criteriaWrapper.build()), page, clazz);
    }

    public Page findPage(Criteria criteria, Sort sort, Page page, Class<?> clazz) {
        return this.findPage(new Query((CriteriaDefinition)criteria).with(sort), page, clazz);
    }

    public Page findPage(CriteriaWrapper criteriaWrapper, Sort sort, Page page, Class<?> clazz) {
        return this.findPage(new Query((CriteriaDefinition)criteriaWrapper.build()).with(sort), page, clazz);
    }

    public Page findPage(Sort sort, Page page, Class<?> clazz) {
        return this.findPage(new Query().with(sort), page, clazz);
    }

    public Page findPage(Page page, Class<?> clazz) {
        return this.findPage(new Query(), page, clazz);
    }

    public <T> T findById(String id, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        this.logQuery(clazz, new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id)));
        return (T)this.getMongoTemplate().findById((Object)id, clazz);
    }

    public <T> T findOneByQuery(Query query, Class<T> clazz) {
        query.limit(1);
        this.logQuery(clazz, query);
        return (T)this.getMongoTemplate().findOne(query, clazz);
    }

    public <T> T findOneByQuery(Criteria criteria, Class<T> clazz) {
        return this.findOneByQuery(new Query((CriteriaDefinition)criteria), clazz);
    }

    public <T> T findOneByQuery(CriteriaWrapper criteriaWrapper, Class<T> clazz) {
        return this.findOneByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()), clazz);
    }

    public <T> T findOneByQuery(Criteria criteria, Sort sort, Class<T> clazz) {
        return this.findOneByQuery(new Query((CriteriaDefinition)criteria).with(sort), clazz);
    }

    public <T> T findOneByQuery(CriteriaWrapper criteriaWrapper, Sort sort, Class<T> clazz) {
        return this.findOneByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()).with(sort), clazz);
    }

    public <T> T findOneByQuery(Sort sort, Class<T> clazz) {
        return this.findOneByQuery(new Query().with(sort), clazz);
    }

    public <T> List<T> findListByQuery(Query query, Class<T> clazz) {
        if (!query.isSorted()) {
            query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id"}));
        }
        this.logQuery(clazz, query);
        return this.getMongoTemplate().find(query, clazz);
    }

    public <T> List<T> findListByQuery(Criteria criteria, Class<T> clazz) {
        return this.findListByQuery(new Query((CriteriaDefinition)criteria), clazz);
    }

    public <T> List<T> findListByQuery(CriteriaWrapper criteriaWrapper, Class<T> clazz) {
        return this.findListByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()), clazz);
    }

    public <T> List<T> findListByQuery(Criteria criteria, Sort sort, Class<T> clazz) {
        return this.findListByQuery(new Query((CriteriaDefinition)criteria).with(sort), clazz);
    }

    public <T> List<T> findListByQuery(CriteriaWrapper criteriaWrapper, Sort sort, Class<T> clazz) {
        return this.findListByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()).with(sort), clazz);
    }

    public <T> List<T> findPropertiesByQuery(Query query, Class<?> documentClass, String property, Class<T> propertyClass) {
        query.fields().include(property);
        List<?> list = this.findListByQuery(query, documentClass);
        List<T> propertyList = this.extractProperty(list, property, propertyClass);
        return propertyList;
    }

    public List<String> findPropertiesByQuery(Query query, Class<?> documentClass, String property) {
        return this.findPropertiesByQuery(query, documentClass, property, String.class);
    }

    public <T> List<T> findPropertiesByQuery(Criteria criteria, Class<?> documentClass, String property, Class<T> propertyClass) {
        return this.findPropertiesByQuery(new Query((CriteriaDefinition)criteria), documentClass, property, propertyClass);
    }

    public <T> List<T> findPropertiesByQuery(CriteriaWrapper criteriaWrapper, Class<?> documentClass, String property, Class<T> propertyClass) {
        return this.findPropertiesByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()), documentClass, property, propertyClass);
    }

    public List<String> findPropertiesByQuery(Criteria criteria, Class<?> documentClass, String property) {
        return this.findPropertiesByQuery(new Query((CriteriaDefinition)criteria), documentClass, property, String.class);
    }

    public List<String> findPropertiesByQuery(CriteriaWrapper criteriaWrapper, Class<?> documentClass, String property) {
        return this.findPropertiesByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()), documentClass, property, String.class);
    }

    public List<String> findPropertiesByIds(Collection<String> ids, Class<?> documentClass, String property) {
        return this.findPropertiesByQuery(Criteria.where((String)"id").in(ids), documentClass, property, String.class);
    }

    public List<String> findIdsByQuery(Query query, Class<?> clazz) {
        HashSet<String> ids = new HashSet<String>();
        query.fields().include("id");
        this.logQuery(clazz, query);
        List list = this.getMongoTemplate().find(query, clazz);
        for (Object object : list) {
            ids.add((String)ReflectUtil.getFieldValue(object, (String)"id"));
        }
        return new ArrayList<String>(ids);
    }

    public List<String> findIdsByQuery(Criteria criteria, Class<?> clazz) {
        return this.findIdsByQuery(new Query((CriteriaDefinition)criteria), clazz);
    }

    public List<String> findIdsByQuery(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        return this.findIdsByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()), clazz);
    }

    public List<String> findIdsByQuery(Criteria criteria, Sort sort, Class<?> clazz) {
        return this.findIdsByQuery(new Query((CriteriaDefinition)criteria).with(sort), clazz);
    }

    public List<String> findIdsByQuery(CriteriaWrapper criteriaWrapper, Sort sort, Class<?> clazz) {
        return this.findIdsByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()).with(sort), clazz);
    }

    public <T> List<T> findListByIds(Collection<String> ids, Class<T> clazz) {
        return this.findListByQuery(new Query((CriteriaDefinition)Criteria.where((String)"id").in(ids)), clazz);
    }

    public <T> List<T> findListByIds(Collection<String> ids, Sort sort, Class<T> clazz) {
        return this.findListByQuery(new Query((CriteriaDefinition)Criteria.where((String)"id").in(ids)).with(sort), clazz);
    }

    public <T> List<T> findAll(Class<T> clazz) {
        return this.findListByQuery(new Query(), clazz);
    }

    public <T> List<T> findAll(Sort sort, Class<T> clazz) {
        return this.findListByQuery(new Criteria(), sort, clazz);
    }

    public List<String> findAllIds(Class<?> clazz) {
        return this.findIdsByQuery(new Query(), clazz);
    }

    public Long findCountByQuery(Query query, Class<?> clazz) {
        this.logCount(clazz, query);
        return this.getMongoTemplate().count(query, clazz);
    }

    public Long findCountByQuery(Criteria criteria, Class<?> clazz) {
        return this.findCountByQuery(new Query((CriteriaDefinition)criteria), clazz);
    }

    public Long findCountByQuery(CriteriaWrapper criteriaWrapper, Class<?> clazz) {
        return this.findCountByQuery(new Query((CriteriaDefinition)criteriaWrapper.build()), clazz);
    }

    public Long findAllCount(Class<?> clazz) {
        return this.findCountByQuery(new Query(), clazz);
    }

    private <T> List<T> extractProperty(List<?> list, String property, Class<T> clazz) {
        HashSet<Object> rs = new HashSet<Object>();
        for (Object object : list) {
            Object value = ReflectUtil.getFieldValue(object, (String)property);
            if (!value.getClass().equals(clazz)) continue;
            rs.add(value);
        }
        return new ArrayList(rs);
    }
}

