/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ota;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.util.SparseArray;
import android.widget.ProgressBar;
import cn.com.heaton.blelibrary.R;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ota.BleOtaUpdater;
import cn.com.heaton.blelibrary.ota.OtaStatus;
import java.io.File;
import java.io.IOException;

public class OtaManager {
    public static final String TAG = "OtaManager";
    private Context mContext;
    private MessageHandler mHandler = new MessageHandler(this);
    private File mOtaFile;
    private ProgressDialog mUpdateDialog;
    private ProgressBar mProgress;
    private UpdateListener mUpdateListener;
    private SparseArray<BleOtaUpdater> mUpdateList = new SparseArray();
    private int mCounter = 0;
    private boolean mSingle = true;
    private boolean mStopUpdate = false;

    public OtaManager(Context context) {
        this.mContext = context;
    }

    public void setSingle(boolean single) {
        this.mSingle = single;
    }

    public UpdateListener getUpdateListener() {
        return this.mUpdateListener;
    }

    public void setUpdateListener(UpdateListener updateListener) {
        this.mUpdateListener = updateListener;
    }

    private void retryUpdate(BleOtaUpdater otaUpdater) {
        if (this.mStopUpdate) {
            return;
        }
        if (otaUpdater == null) {
            return;
        }
        this.mUpdateList.remove(otaUpdater.getIndex());
        this.startOtaUpdate(this.mOtaFile, otaUpdater.getBleDevice(), otaUpdater.getBleManager());
    }

    public boolean startOtaUpdate(File file, BleDevice bleDevice, Ble bleManager) {
        if (bleManager == null || file == null || !file.exists() || !file.canRead()) {
            return false;
        }
        if (this.mSingle && this.mUpdateList.size() > 0) {
            return false;
        }
        ++this.mCounter;
        BleOtaUpdater mBleOtaUpdater = new BleOtaUpdater(this.mHandler);
        mBleOtaUpdater.setIndex(this.mCounter);
        this.mUpdateList.put(this.mCounter, (Object)mBleOtaUpdater);
        try {
            this.mOtaFile = file;
            String mFilePath = file.getCanonicalPath();
            this.mStopUpdate = false;
            if (mBleOtaUpdater.otaStart(mFilePath, bleDevice, bleManager) == OtaStatus.OtaResult.OTA_RESULT_SUCCESS) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void stopAll() {
        if (this.mStopUpdate) {
            return;
        }
        this.mStopUpdate = true;
        if (this.mUpdateList.size() > 0) {
            int len = this.mUpdateList.size();
            for (int i = 0; i < len; ++i) {
                int key = this.mUpdateList.keyAt(i);
                BleOtaUpdater otaUpdater = (BleOtaUpdater)this.mUpdateList.get(key);
                if (otaUpdater == null) continue;
                otaUpdater.otaStop();
            }
        }
    }

    private void showProgress(int progress) {
        if (!this.mSingle) {
            return;
        }
        if (this.mUpdateDialog == null) {
            this.mUpdateDialog = new ProgressDialog(this.mContext);
            this.mUpdateDialog.setTitle(R.string.update_cancel);
            this.mUpdateDialog.setMessage((CharSequence)this.mContext.getString(R.string.updating));
            this.mUpdateDialog.setProgressStyle(1);
        }
        if (!this.mUpdateDialog.isShowing()) {
            this.mUpdateDialog.show();
        }
        this.mUpdateDialog.setProgress(progress);
    }

    private static class MessageHandler
    extends Handler {
        private OtaManager otaManager;

        public MessageHandler(OtaManager otaManager) {
            this.otaManager = otaManager;
        }

        public void dispatchMessage(Message msg) {
            if (this.otaManager != null) {
                Integer idx = (Integer)msg.obj;
                BleOtaUpdater updater = null;
                BleDevice bleDevice = null;
                if (idx != null && (updater = (BleOtaUpdater)this.otaManager.mUpdateList.get(idx.intValue())) != null) {
                    bleDevice = updater.getBleDevice();
                }
                switch (msg.what) {
                    case 4: {
                        if (this.otaManager.mUpdateListener != null) {
                            this.otaManager.mUpdateListener.onPreUpdate(bleDevice);
                        }
                        return;
                    }
                    case 1: {
                        if (this.otaManager.mStopUpdate) {
                            return;
                        }
                        this.otaManager.showProgress(msg.arg1);
                        if (this.otaManager.mUpdateListener != null) {
                            this.otaManager.mUpdateListener.onUpdating(bleDevice, msg.arg1);
                        }
                        return;
                    }
                    case 2: {
                        if (this.otaManager.mUpdateDialog != null) {
                            this.otaManager.mUpdateDialog.dismiss();
                        }
                        if (updater != null) {
                            this.otaManager.mUpdateList.remove(updater.getIndex());
                        }
                        if (this.otaManager.mUpdateListener != null) {
                            this.otaManager.mUpdateListener.onUpdateComplete(bleDevice);
                        }
                        return;
                    }
                    case 3: {
                        if (this.otaManager.mUpdateDialog != null) {
                            this.otaManager.mUpdateDialog.dismiss();
                            AlertDialog.Builder builder = new AlertDialog.Builder(this.otaManager.mContext);
                            builder.setTitle((CharSequence)"\u786c\u4ef6\u66f4\u65b0");
                            builder.setMessage((CharSequence)this.otaManager.mContext.getResources().getString(R.string.ota_error, new Object[]{bleDevice != null ? "[" + bleDevice.getBleName() + "]" : ""}));
                            final BleOtaUpdater otaUpdater = updater;
                            builder.setPositiveButton(R.string.update_retry, new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                    MessageHandler.this.otaManager.retryUpdate(otaUpdater);
                                }
                            });
                            builder.setNegativeButton(R.string.update_cancel, new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    dialog.dismiss();
                                }
                            });
                            AlertDialog noticeDialog = builder.create();
                            noticeDialog.show();
                        }
                        if (this.otaManager.mUpdateListener != null) {
                            this.otaManager.mUpdateListener.onUpdateFailed(bleDevice);
                        }
                        return;
                    }
                }
                super.dispatchMessage(msg);
            }
        }
    }

    public static interface UpdateListener {
        public void onPreUpdate(BleDevice var1);

        public void onUpdating(BleDevice var1, int var2);

        public void onUpdateComplete(BleDevice var1);

        public void onUpdateFailed(BleDevice var1);
    }
}

