/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ota;

import android.os.Handler;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.model.BleDevice;
import cn.com.heaton.blelibrary.ota.OtaListener;
import cn.com.heaton.blelibrary.ota.OtaStatus;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.Semaphore;

public class BleOtaUpdater
implements OtaListener {
    private static final String TAG = BleOtaUpdater.class.getSimpleName();
    private BleDevice mBleDevice;
    private Ble mBleManager;
    private int mStartOffset = 0;
    private int mPercent = 0;
    private final int mTimeout = 12;
    private final int mPacketSize = 256;
    private boolean mShouldStop = false;
    private Handler mHandler;
    private String mFilePath = null;
    private int mByteRate = 0;
    private int mElapsedTime = 0;
    private Thread mUpdateThread;
    private Semaphore semp;
    private OtaStatus.OtaResult mRetValue;
    private Runnable mUpdateRunnable;
    private int mIndex = 0;
    public static final int OTA_UPDATE = 1;
    public static final int OTA_OVER = 2;
    public static final int OTA_FAIL = 3;
    public static final int OTA_BEFORE = 4;

    public BleOtaUpdater(Handler handler) {
        this.mHandler = handler;
        this.mRetValue = OtaStatus.OtaResult.OTA_RESULT_SUCCESS;
        this.mUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                BleOtaUpdater.this.otaUpdateProcess(BleOtaUpdater.this.mFilePath);
            }
        };
    }

    @Override
    public void onWrite() {
        this.notifyReadDataCompleted();
    }

    @Override
    public void onChange(byte[] data) {
        this.otaGetResult(data);
    }

    public void setIndex(int idx) {
        this.mIndex = idx;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public BleDevice getBleDevice() {
        return this.mBleDevice;
    }

    public Ble getBleManager() {
        return this.mBleManager;
    }

    public void otaPrintBytes(byte[] bytes, String tag) {
        if (bytes != null) {
            StringBuilder stringBuilder = new StringBuilder(bytes.length);
            for (byte byteChar : bytes) {
                stringBuilder.append(String.format("%02X ", byteChar));
            }
        }
    }

    private byte cmdToValue(OtaStatus.OtaCmd cmd) {
        switch (cmd) {
            case OTA_CMD_META_DATA: {
                return 1;
            }
            case OTA_CMD_BRICK_DATA: {
                return 2;
            }
            case OTA_CMD_DATA_VERIFY: {
                return 3;
            }
            case OTA_CMD_EXECUTION_NEW_CODE: {
                return 4;
            }
        }
        return 0;
    }

    private OtaStatus.OtaCmd valueToCmd(int val) {
        switch (val & 0xFF) {
            case 1: {
                return OtaStatus.OtaCmd.OTA_CMD_META_DATA;
            }
            case 2: {
                return OtaStatus.OtaCmd.OTA_CMD_BRICK_DATA;
            }
            case 3: {
                return OtaStatus.OtaCmd.OTA_CMD_DATA_VERIFY;
            }
            case 4: {
                return OtaStatus.OtaCmd.OTA_CMD_EXECUTION_NEW_CODE;
            }
        }
        return null;
    }

    private boolean otaWrite(byte[] data) throws InterruptedException {
        if (this.shouldStopUpdate()) {
            return false;
        }
        if (!this.mBleManager.getBleRequest().writeOtaData(this.mBleDevice.getBleAddress(), data)) {
            return false;
        }
        return this.waitWriteDataCompleted();
    }

    private boolean otaSendPacket(OtaStatus.OtaCmd cmd, short checksum, byte[] data, int dataLength) {
        int tempLen;
        byte[] dataPacket;
        int packetLength;
        byte cmdVal = this.cmdToValue(cmd);
        byte[] checksumBytes = new byte[]{(byte)checksum, (byte)(checksum >> 8)};
        byte[] head = new byte[3];
        switch (cmd) {
            case OTA_CMD_META_DATA: 
            case OTA_CMD_BRICK_DATA: {
                head[0] = (byte)(dataLength + 1);
                head[1] = (byte)(dataLength + 1 >> 8);
                head[2] = cmdVal;
                packetLength = head.length + dataLength + checksumBytes.length;
                dataPacket = new byte[packetLength];
                System.arraycopy(head, 0, dataPacket, 0, head.length);
                System.arraycopy(data, 0, dataPacket, head.length, dataLength);
                System.arraycopy(checksumBytes, 0, dataPacket, head.length + dataLength, checksumBytes.length);
                break;
            }
            case OTA_CMD_DATA_VERIFY: 
            case OTA_CMD_EXECUTION_NEW_CODE: {
                packetLength = head.length + checksumBytes.length;
                dataPacket = new byte[packetLength];
                dataPacket[0] = 1;
                dataPacket[1] = 0;
                dataPacket[2] = cmdVal;
                dataPacket[3] = checksumBytes[0];
                dataPacket[4] = checksumBytes[1];
                break;
            }
            default: {
                return false;
            }
        }
        int BytesEachTime = 20;
        for (int left = packetLength; left > 0; left -= tempLen) {
            tempLen = left > BytesEachTime ? BytesEachTime : left;
            byte[] tempPacket = new byte[tempLen];
            System.arraycopy(dataPacket, packetLength - left, tempPacket, 0, tempLen);
            try {
                if (this.otaWrite(tempPacket)) continue;
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private int otaSendMetaData(FileInputStream fin) throws IOException {
        byte[] metaLen = new byte[2];
        fin.read(metaLen);
        short dataLength = (short)(((metaLen[1] & 0xFF) << 8) + (metaLen[0] & 0xFF));
        byte[] data = new byte[dataLength];
        int readLength = fin.read(data);
        if (readLength < 0) {
            return -1;
        }
        short checksum = this.cmdToValue(OtaStatus.OtaCmd.OTA_CMD_META_DATA);
        for (int i = 0; i < readLength; ++i) {
            checksum = (short)(checksum + (data[i] & 0xFF));
        }
        return this.otaSendPacket(OtaStatus.OtaCmd.OTA_CMD_META_DATA, checksum, data, dataLength) ? readLength + 2 : -1;
    }

    private int otaSendBrickData(FileInputStream fin, int dataLength) throws IOException {
        byte[] data = new byte[dataLength];
        int readLength = fin.read(data);
        if (readLength <= 0) {
            return -1;
        }
        if (readLength < dataLength) {
            dataLength = readLength;
        }
        short checksum = this.cmdToValue(OtaStatus.OtaCmd.OTA_CMD_BRICK_DATA);
        for (int i = 0; i < dataLength; ++i) {
            checksum = (short)(checksum + (data[i] & 0xFF));
        }
        if (this.otaSendPacket(OtaStatus.OtaCmd.OTA_CMD_BRICK_DATA, checksum, data, dataLength)) {
            return readLength;
        }
        return -2;
    }

    private boolean otaSendVerifyCmd() {
        byte checksum = this.cmdToValue(OtaStatus.OtaCmd.OTA_CMD_DATA_VERIFY);
        return this.otaSendPacket(OtaStatus.OtaCmd.OTA_CMD_DATA_VERIFY, checksum, null, 0) && this.waitVerifyCmdDone();
    }

    private void otaSendResetCmd() {
        byte checksum = this.cmdToValue(OtaStatus.OtaCmd.OTA_CMD_EXECUTION_NEW_CODE);
        this.otaSendPacket(OtaStatus.OtaCmd.OTA_CMD_EXECUTION_NEW_CODE, checksum, null, 0);
    }

    private void releaseSemaphore(Semaphore semp) {
        semp.release();
    }

    private boolean waitSemaphore(Semaphore semp) {
        int i = 0;
        do {
            if (i++ >= 12000) {
                return false;
            }
            boolean getAccquire = semp.tryAcquire();
            if (getAccquire) {
                return true;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                return true;
            }
        } while (!this.shouldStopUpdate());
        return false;
    }

    private void setOffset(int offset) {
        this.mStartOffset = offset;
        this.releaseSemaphore(this.semp);
    }

    private int getOffset() {
        return this.waitSemaphore(this.semp) ? this.mStartOffset : -1;
    }

    private void notifyVerifyCmdDone() {
        this.releaseSemaphore(this.semp);
    }

    private boolean waitVerifyCmdDone() {
        return this.waitSemaphore(this.semp);
    }

    public void notifyWriteDataCompleted() {
        this.releaseSemaphore(this.semp);
    }

    private boolean waitWriteDataCompleted() {
        return this.waitSemaphore(this.semp);
    }

    private void notifyReadDataCompleted() {
        this.releaseSemaphore(this.semp);
    }

    private boolean waitReadDataCompleted() {
        return this.waitSemaphore(this.semp);
    }

    public void otaGetResult(byte[] notify_data) {
        OtaStatus.OtaCmd cmdType = this.valueToCmd(notify_data[2] & 0xFF);
        if (cmdType == null) {
            this.otaPrintBytes(notify_data, "Notify data: ");
            this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_RECEIVED_INVALID_PACKET);
        } else {
            switch (notify_data[3]) {
                case 0: {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_SUCCESS);
                    break;
                }
                case 1: {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_PKT_CHECKSUM_ERROR);
                    break;
                }
                case 2: {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_PKT_LEN_ERROR);
                    break;
                }
                case 3: {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_DEVICE_NOT_SUPPORT_OTA);
                    break;
                }
                case 4: {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_FW_SIZE_ERROR);
                    break;
                }
                case 5: {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_FW_VERIFY_ERROR);
                    break;
                }
                default: {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_INVALID_ARGUMENT);
                }
            }
            if (this.mRetValue != OtaStatus.OtaResult.OTA_RESULT_SUCCESS) {
                this.otaPrintBytes(notify_data, "Notify data: ");
            } else {
                switch (cmdType) {
                    case OTA_CMD_META_DATA: {
                        short offset = (short)((notify_data[4] & 0xFF) + ((notify_data[5] & 0xFF) << 8));
                        this.setOffset(offset);
                        break;
                    }
                    case OTA_CMD_BRICK_DATA: {
                        short size = (short)((notify_data[4] & 0xFF) + ((notify_data[5] & 0xFF) << 8));
                        this.notifyReadDataCompleted();
                        break;
                    }
                    case OTA_CMD_DATA_VERIFY: {
                        this.notifyVerifyCmdDone();
                        break;
                    }
                    case OTA_CMD_EXECUTION_NEW_CODE: {
                        break;
                    }
                    default: {
                        this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_INVALID_ARGUMENT);
                    }
                }
            }
        }
    }

    private boolean shouldStopUpdate() {
        return this.mShouldStop;
    }

    private void serErrorCode(OtaStatus.OtaResult ret) {
        this.mRetValue = ret;
    }

    public OtaStatus.OtaResult otaStart(String file, BleDevice bleDevice, Ble bleManager) {
        if (!file.isEmpty() && bleManager != null) {
            this.mFilePath = file;
            this.mBleDevice = bleDevice;
            this.mBleManager = bleManager;
            this.mBleManager.getBleRequest().setOtaListener(this);
            this.mShouldStop = false;
            this.mPercent = 0;
            this.mByteRate = 0;
            this.mElapsedTime = 0;
            this.semp = new Semaphore(0);
            this.mUpdateThread = new Thread(this.mUpdateRunnable);
            this.mUpdateThread.start();
            return OtaStatus.OtaResult.OTA_RESULT_SUCCESS;
        }
        return OtaStatus.OtaResult.OTA_RESULT_INVALID_ARGUMENT;
    }

    private void otaUpdateProcess(String filePath) {
        try {
            FileInputStream fileInputStream;
            int fileSize;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(4, (Object)this.mIndex).sendToTarget();
            }
            if ((fileSize = (fileInputStream = new FileInputStream(filePath)).available()) == 0 || this.mShouldStop) {
                fileInputStream.close();
                this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_FW_SIZE_ERROR);
                if (this.mHandler != null) {
                    this.mHandler.obtainMessage(3, (Object)this.mIndex).sendToTarget();
                }
                return;
            }
            int metaSize = this.otaSendMetaData(fileInputStream);
            if (metaSize < 0 || this.mShouldStop) {
                fileInputStream.close();
                this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_SEND_META_ERROR);
                if (this.mHandler != null) {
                    this.mHandler.obtainMessage(3, (Object)this.mIndex).sendToTarget();
                }
                return;
            }
            int offset1 = this.getOffset();
            if (offset1 < 0 || this.mShouldStop) {
                fileInputStream.close();
                this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_META_RESPONSE_TIMEOUT);
                if (this.mHandler != null) {
                    this.mHandler.obtainMessage(3, (Object)this.mIndex).sendToTarget();
                }
                return;
            }
            if (offset1 > 0) {
                fileInputStream.skip(offset1);
            }
            int brickDataSize = fileSize - metaSize;
            int transfereedSize = 0;
            long begin = Calendar.getInstance().getTimeInMillis();
            do {
                int ret1;
                if ((ret1 = this.otaSendBrickData(fileInputStream, 256)) < 0 || this.mShouldStop) {
                    fileInputStream.close();
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_DATA_RESPONSE_TIMEOUT);
                    if (this.mHandler != null) {
                        this.mHandler.obtainMessage(3, (Object)this.mIndex).sendToTarget();
                    }
                    return;
                }
                if (!this.waitReadDataCompleted() || this.mShouldStop) {
                    this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_DATA_RESPONSE_TIMEOUT);
                    if (this.mHandler != null) {
                        this.mHandler.obtainMessage(3, (Object)this.mIndex).sendToTarget();
                    }
                    return;
                }
                this.mPercent = (offset1 += ret1) * 100 / fileSize;
                if (this.mHandler != null) {
                    this.mHandler.obtainMessage(1, this.mPercent, 0, (Object)this.mIndex).sendToTarget();
                }
                long now = Calendar.getInstance().getTimeInMillis();
                this.mElapsedTime = (int)((now - begin) / 1000L);
                this.mByteRate = (int)((long)((transfereedSize += 256) * 1000) / (now - begin));
            } while (offset1 < brickDataSize);
            if (!this.otaSendVerifyCmd() || this.mShouldStop) {
                fileInputStream.close();
                this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_FW_VERIFY_ERROR);
                if (this.mHandler != null) {
                    this.mHandler.obtainMessage(3, (Object)this.mIndex).sendToTarget();
                }
                return;
            }
            this.mPercent = 100;
            this.otaSendResetCmd();
            fileInputStream.close();
        }
        catch (Exception e) {
            this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_DATA_RESPONSE_TIMEOUT);
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(3, (Object)this.mIndex).sendToTarget();
            }
            return;
        }
        if (this.mHandler != null) {
            this.mHandler.obtainMessage(2, (Object)this.mIndex).sendToTarget();
        }
        this.serErrorCode(OtaStatus.OtaResult.OTA_RESULT_SUCCESS);
    }

    public OtaStatus.OtaResult otaGetProcess(int[] extra) {
        if (extra.length < 8) {
            return OtaStatus.OtaResult.OTA_RESULT_INVALID_ARGUMENT;
        }
        Arrays.fill(extra, 0);
        extra[0] = this.mPercent;
        extra[1] = this.mByteRate;
        extra[2] = this.mElapsedTime;
        return this.mRetValue;
    }

    public void otaStop() {
        this.mShouldStop = true;
        if (this.mUpdateThread != null) {
            this.mUpdateThread.interrupt();
        }
    }
}

