/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.utils;

public class UuidUtils {
    private static final String base_uuid_regex = "0000([0-9a-f][0-9a-f][0-9a-f][0-9a-f])-0000-1000-8000-00805f9b34fb";

    public static boolean isBaseUUID(String uuid) {
        return uuid.toLowerCase().matches(base_uuid_regex);
    }

    public static String uuid128To16(String uuid) {
        return UuidUtils.uuid128To16(uuid, true);
    }

    public static String uuid128To16(String uuid, boolean lower_case) {
        String uuid_16 = "";
        if (uuid.length() == 36) {
            uuid_16 = lower_case ? uuid.substring(4, 8).toLowerCase() : uuid.substring(4, 8).toUpperCase();
            return uuid_16;
        }
        return null;
    }

    public static String uuid16To128(String uuid) {
        return UuidUtils.uuid16To128(uuid, true);
    }

    public static String uuid16To128(String uuid, boolean lower_case) {
        String uuid_128 = "";
        uuid_128 = lower_case ? (base_uuid_regex.substring(0, 4) + uuid + base_uuid_regex.substring(38)).toLowerCase() : (base_uuid_regex.substring(0, 4) + uuid + base_uuid_regex.substring(38)).toUpperCase();
        return uuid_128;
    }
}

