/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.utils;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import java.util.List;

public class Utils {
    public static boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(context.getPackageName())) continue;
            return appProcess.importance != 100;
        }
        return false;
    }

    public static boolean isGpsOpen(Context context) {
        int locationMode = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            return locationMode != 0;
        }
        String locationProviders = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed");
        return !TextUtils.isEmpty((CharSequence)locationProviders);
    }

    public static boolean isPermission(Context context, String permission2) {
        return Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }
}

