/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.utils;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RestrictTo;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ThreadUtils {
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private static Executor mParallelExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
    private static Executor mSerialExecutor = AsyncTask.SERIAL_EXECUTOR;
    private static Handler sHandler = new Handler(Looper.getMainLooper());

    private ThreadUtils() {
        mParallelExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
        mSerialExecutor = AsyncTask.SERIAL_EXECUTOR;
    }

    public static void ui(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            sHandler.post(runnable);
        }
    }

    public static void asyn(Runnable task) {
        ThreadUtils.asyn(task, true);
    }

    public static void asynQueue(Runnable task) {
        ThreadUtils.asyn(task, false);
    }

    public static void asyn(Runnable task, boolean parallel) {
        if (parallel) {
            mParallelExecutor.execute(task);
            return;
        }
        mSerialExecutor.execute(task);
    }

    public static void submit(Callable callable) {
        executorService.submit(callable);
    }
}

