/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.utils;

public class CrcUtils {

    public static class CRC32 {
        public static long CRC32(byte[] source, int offset, int length) {
            long wCRCin = 0xFFFFFFFFL;
            long wCPoly = 3988292384L;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= (long)source[i] & 0xFFL;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1L) != 0L) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0xFFFFFFFFL;
        }

        public static long CRC32_B(byte[] source, int offset, int length) {
            long wCRCin = 0xFFFFFFFFL;
            long wCPoly = 79764919L;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c31 = (wCRCin >> 31 & 1L) == 1L;
                    wCRCin <<= 1;
                    if (!(c31 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFFFFFFL;
            return wCRCin ^= 0xFFFFFFFFL;
        }

        public static long CRC32_C(byte[] source, int offset, int length) {
            long wCRCin = 0xFFFFFFFFL;
            long wCPoly = 2197175160L;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= (long)source[i] & 0xFFL;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1L) != 0L) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0xFFFFFFFFL;
        }

        public static long CRC32_D(byte[] source, int offset, int length) {
            long wCRCin = 0xFFFFFFFFL;
            long wCPoly = 3558460437L;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= (long)source[i] & 0xFFL;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1L) != 0L) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0xFFFFFFFFL;
        }

        public static long CRC32_MPEG_2(byte[] source, int offset, int length) {
            long wCRCin = 0xFFFFFFFFL;
            long wCPoly = 79764919L;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c31 = (wCRCin >> 31 & 1L) == 1L;
                    wCRCin <<= 1;
                    if (!(c31 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFFFFFFL;
            return wCRCin ^= 0L;
        }

        public static long CRC32_POSIX(byte[] source, int offset, int length) {
            long wCRCin = 0L;
            long wCPoly = 79764919L;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c31 = (wCRCin >> 31 & 1L) == 1L;
                    wCRCin <<= 1;
                    if (!(c31 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFFFFFFL;
            return wCRCin ^= 0xFFFFFFFFL;
        }
    }

    public static class CRC16 {
        public static int CRC16_IBM(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 40961;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= source[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0;
        }

        public static int CRC16_CCITT(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 33800;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= source[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0;
        }

        public static int CRC16_CCITT_FALSE(byte[] source, int offset, int length) {
            int wCRCin = 65535;
            int wCPoly = 4129;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c15 = (wCRCin >> 15 & 1) == 1;
                    wCRCin <<= 1;
                    if (!(c15 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFF;
            return wCRCin ^= 0;
        }

        public static int CRC16_DECT_R(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 1417;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c15 = (wCRCin >> 15 & 1) == 1;
                    wCRCin <<= 1;
                    if (!(c15 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFF;
            return wCRCin ^= 1;
        }

        public static int CRC16_DECT_X(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 1417;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c15 = (wCRCin >> 15 & 1) == 1;
                    wCRCin <<= 1;
                    if (!(c15 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFF;
            return wCRCin ^= 0;
        }

        public static int CRC16_DNP(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 42684;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= source[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0xFFFF;
        }

        public static int CRC16_GENIBUS(byte[] source, int offset, int length) {
            int wCRCin = 65535;
            int wCPoly = 4129;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c15 = (wCRCin >> 15 & 1) == 1;
                    wCRCin <<= 1;
                    if (!(c15 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFF;
            return wCRCin ^= 0xFFFF;
        }

        public static int CRC16_MAXIM(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 40961;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= source[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0xFFFF;
        }

        public static int CRC16_MODBUS(byte[] source, int offset, int length) {
            int wCRCin = 65535;
            int wCPoly = 40961;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= source[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0;
        }

        public static int CRC16_USB(byte[] source, int offset, int length) {
            int wCRCin = 65535;
            int wCPoly = 40961;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= source[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0xFFFF;
        }

        public static int CRC16_X25(byte[] source, int offset, int length) {
            int wCRCin = 65535;
            int wCPoly = 33800;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin ^= source[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0xFFFF;
        }

        public static int CRC16_XMODEM(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 4129;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c15 = (wCRCin >> 15 & 1) == 1;
                    wCRCin <<= 1;
                    if (!(c15 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFFFF;
            return wCRCin ^= 0;
        }
    }

    public static class CRC8 {
        public static int CRC8(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 7;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c07 = (wCRCin >> 7 & 1) == 1;
                    wCRCin <<= 1;
                    if (!(c07 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFF;
            return wCRCin ^= 0;
        }

        public static int CRC8_DARC(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 156;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin = (int)((long)wCRCin ^ (long)source[i] & 0xFFL);
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0;
        }

        public static int CRC8_ITU(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 7;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                for (int j = 0; j < 8; ++j) {
                    boolean bit = (source[i] >> 7 - j & 1) == 1;
                    boolean c07 = (wCRCin >> 7 & 1) == 1;
                    wCRCin <<= 1;
                    if (!(c07 ^ bit)) continue;
                    wCRCin ^= wCPoly;
                }
            }
            wCRCin &= 0xFF;
            return wCRCin ^= 0x55;
        }

        public static int CRC8_MAXIM(byte[] source, int offset, int length) {
            int wCRCin = 0;
            int wCPoly = 140;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin = (int)((long)wCRCin ^ (long)source[i] & 0xFFL);
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0;
        }

        public static int CRC8_ROHC(byte[] source, int offset, int length) {
            int wCRCin = 255;
            int wCPoly = 224;
            int cnt = offset + length;
            for (int i = offset; i < cnt; ++i) {
                wCRCin = (int)((long)wCRCin ^ (long)source[i] & 0xFFL);
                for (int j = 0; j < 8; ++j) {
                    if ((wCRCin & 1) != 0) {
                        wCRCin >>= 1;
                        wCRCin ^= wCPoly;
                        continue;
                    }
                    wCRCin >>= 1;
                }
            }
            return wCRCin ^= 0;
        }
    }
}

