/*
 * Decompiled with CFR 0.152.
 */
package cn.com.heaton.blelibrary.ble.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.ParcelUuid;
import android.util.Log;
import cn.com.heaton.blelibrary.ble.Ble;
import cn.com.heaton.blelibrary.ble.BleLog;
import cn.com.heaton.blelibrary.ble.callback.wrapper.ScanWrapperCallback;
import cn.com.heaton.blelibrary.ble.model.ScanRecord;
import cn.com.heaton.blelibrary.ble.scan.BleScannerCompat;
import cn.com.heaton.blelibrary.ble.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@TargetApi(value=21)
class BluetoothScannerImplLollipop
extends BleScannerCompat {
    private static final String TAG = "BluetoothScannerImplLol";
    private BluetoothLeScanner scanner;
    private ScanSettings scanSettings;
    private List<ScanFilter> filters = new ArrayList<ScanFilter>();
    private ScanCallback scannerCallback = new ScanCallback(){

        public void onScanResult(int callbackType, ScanResult result) {
            ScanRecord parseRecord;
            Log.e((String)BluetoothScannerImplLollipop.TAG, (String)("onScanResult: " + result.getScanRecord().getDeviceName()));
            BluetoothDevice device = result.getDevice();
            byte[] scanRecord = result.getScanRecord().getBytes();
            if (BluetoothScannerImplLollipop.this.scanWrapperCallback != null) {
                BluetoothScannerImplLollipop.this.scanWrapperCallback.onLeScan(device, result.getRssi(), scanRecord);
            }
            if (Ble.options().isParseScanData && (parseRecord = ScanRecord.parseFromBytes(scanRecord)) != null && BluetoothScannerImplLollipop.this.scanWrapperCallback != null) {
                BluetoothScannerImplLollipop.this.scanWrapperCallback.onParsedData(device, parseRecord);
            }
        }

        public void onBatchScanResults(List<ScanResult> results) {
            for (ScanResult sr : results) {
                BleLog.d("ScanResult - Results", sr.toString());
            }
        }

        public void onScanFailed(int errorCode) {
            BleLog.e("Scan Failed", "Error Code: " + errorCode);
            if (BluetoothScannerImplLollipop.this.scanWrapperCallback != null) {
                BluetoothScannerImplLollipop.this.scanWrapperCallback.onScanFailed(errorCode);
            }
        }
    };

    BluetoothScannerImplLollipop() {
    }

    @Override
    public void startScan(ScanWrapperCallback scanWrapperCallback) {
        super.startScan(scanWrapperCallback);
        if (this.scanner == null) {
            this.scanner = this.bluetoothAdapter.getBluetoothLeScanner();
        }
        this.setScanSettings();
        this.scanner.startScan(this.filters, this.scanSettings, this.scannerCallback);
    }

    @Override
    public void stopScan() {
        if (this.scanner == null) {
            this.scanner = this.bluetoothAdapter.getBluetoothLeScanner();
        }
        this.scanner.stopScan(this.scannerCallback);
        super.stopScan();
    }

    private void setScanSettings() {
        boolean background = Utils.isBackground(Ble.getInstance().getContext());
        BleLog.d(TAG, "currently in the background:>>>>>" + background);
        ScanFilter filter = Ble.options().scanFilter;
        if (filter != null) {
            this.filters.add(filter);
        }
        if (background) {
            UUID uuidService = Ble.options().getUuidService();
            if (filter == null) {
                this.filters.add(new ScanFilter.Builder().setServiceUuid(ParcelUuid.fromString((String)uuidService.toString())).build());
            }
            this.scanSettings = new ScanSettings.Builder().setScanMode(0).build();
        } else {
            if (filter == null) {
                this.filters.clear();
            }
            this.scanSettings = new ScanSettings.Builder().setScanMode(2).build();
        }
    }
}

